import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;

public class VMGuestAppMonitor {
   public native int enable();
   public native int disable();
   public native int isEnabled();
   public native int markActive();
   public native String getAppStatus();

   static {
     System.loadLibrary("VMGuestAppMonitorNative");
   }

   public static void main(String args[]) {
      VMGuestAppMonitor appMon=new VMGuestAppMonitor();
      String command = "";
      while(true) {
         System.out.println("Enter one of the following commands:" +
			    "enable|disable|markActive|isEnabled|" +
                            "getStatus|quit");
         try {
            BufferedReader bufferRead = new BufferedReader(new InputStreamReader(System.in));
            command = bufferRead.readLine();

            System.out.println("Command entered= " + command);
         }
         catch(IOException e)
	 {
	    e.printStackTrace();
	 }
         int result = -1;
         if(command.equals("enable")) {
            result = appMon.enable();
         } else if(command.equals("disable")) {
            result = appMon.disable();
         } else if(command.equals("markActive")) {
            result = appMon.markActive();
         } else if(command.equals("isEnabled")) {
            result = appMon.isEnabled();
         } else if(command.equals("getStatus")) {
            String status = appMon.getAppStatus();
            System.out.println("Status : " + status);
         } else if(command.equals("quit")) {
            System.exit(1);
         }  else {
            System.out.println("Bad command " + command);
            System.exit(1);
         }

         System.out.println(command + " result " + result);
      }
   }
}
