/* **********************************************************
 * Copyright 2010-2016 VMware, Inc.  All rights reserved.
 * **********************************************************/

/*
 * The sample program enables Application Monitoring and sends heartbeats
 * every 15 seconds. Once the program is running issuing Ctrl-c will bring
 * three choice:
 * stop(s)     - stop heartbeating and exit program. This should cause a
 * reset of the VM
 * disable(d)  - disable application monitoring and exit program. This will
 * not cause a reset.
 * continue(c) - keep sending heartbeats.
 *
 * Please make sure you are running ESX[i] 4.1 or later. Please,
 * also, make sure you enabled application monitoring while configuring HA.
 */

#include "stdafx.h"

#include "../../../../include/vmGuestAppMonitorLib.h"

#include <stdio.h>
#include <windows.h>
#include <iostream>

static BOOL
CtrlHandler( DWORD fdwCtrlType )
{
   switch( fdwCtrlType ) {
   case CTRL_C_EVENT:

      char c;
      printf( "Please chose heartbeat action: stop(s), disable(d), continue(c) \n\n" );
      std::cin >> c;
      switch(c)
         {
         case 'c':
            printf("Continuing heartbeating\n");
            return TRUE;
         case 'd':
            int error;
            printf("Disabling app monitoring\n");
            error = VMGuestAppMonitor_Disable();
            if (error != VMGUESTAPPMONITORLIB_ERROR_SUCCESS) {
               printf("Error %d disabling app monitoring", error);
               exit(1);
            }
            exit(0);
         case 's':
            printf("Stopping heartbeating\n");
            exit(0);
         default:
            printf("Invalid action %c\n", c);
         }
      return TRUE;

   default:
      return FALSE;
  }
}


int _tmain(int argc,
           _TCHAR* argv[])
{
   int error;

   if( !SetConsoleCtrlHandler( (PHANDLER_ROUTINE) CtrlHandler, TRUE ) ) {
      printf( "\nUnable to install Control Handler.\n" );
      return 1;
   }

   printf("Enabling app monitoring\n");
   error  = VMGuestAppMonitor_Enable();

   if (error != VMGUESTAPPMONITORLIB_ERROR_SUCCESS) {
      printf("Error %d enabling app monitoring\n", error);
      return error;
   }

   printf("Heartbeating....\n");
   while(1) {
      error = VMGuestAppMonitor_MarkActive();
      if (error != VMGUESTAPPMONITORLIB_ERROR_SUCCESS) {
         printf("Error %d heartbeating\n", error);
         return error;
      }

      Sleep(15 * 1000);
   }

   return 0;
}
