/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.common;

import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.vcd.v1.GatewaySnapshotType;
import com.vmware.ares.vcd.v2.VMRecordType;
import com.vmware.ares.vcd.v2.VdcSnapshotType;
import com.vmware.vcim.ngc.service.cache.common.CacheConfigurator;
import com.vmware.vcim.ngc.service.cache.common.CacheController;
import com.vmware.vcim.ngc.service.cache.common.CacheProxy;
import com.vmware.vcim.ngc.service.cache.common.CloudObjectEntity;
import com.vmware.vcim.ngc.service.cache.common.ObjectTreeFetcher;
import com.vmware.vcim.ngc.service.cache.helper.CloudInstanceVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.DatacenterVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.GatewayVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.VmVpcHelper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.DcSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.GatewaySnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VMRecordTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VdcSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.model.CacheEntries;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;
import org.springframework.web.client.RestClientException;

public class CacheControllerImpl
implements CacheController,
CacheConfigurator {
    private boolean cacheAvailable;
    private boolean useCache;
    private final CacheProxy cacheProxy;
    private final ObjectTreeFetcher objectTreeFetcher;
    private final VcimSessionManager vcimSessionMgr;
    private CloudInstanceVpcHelper cloudInstanceVpcHelper;
    private DatacenterVpcHelper datacenterVpcHelper;
    private VmVpcHelper vmVpcHelper;
    private GatewayVpcHelper gatewayVpcHelper;
    private boolean cacheControllerLoaded = true;
    private static final Logger logger = LoggerFactory.getLogger(CacheControllerImpl.class);

    public CacheControllerImpl(VcimSessionManager vcimSessionMgr, ObjectTreeFetcher objectTreeFetcher, CacheProxy cacheProxy) {
        this.vcimSessionMgr = vcimSessionMgr;
        this.objectTreeFetcher = objectTreeFetcher;
        this.cacheProxy = cacheProxy;
        this.useCache = false;
        this.cacheAvailable = false;
        this.cacheControllerLoaded = true;
        new CacheAvailabilityThread().start();
    }

    @Override
    public void configCache(String cacheUrl, String username, String password, String proxyUrl, String proxyPort, String proxyUsername, String proxyPassword, boolean useProxy, boolean useCache) {
        if (useCache) {
            this.cacheProxy.configCacheSystem(cacheUrl, username, password, proxyUrl, proxyPort, proxyUsername, proxyPassword, useProxy);
        } else {
            this.cacheAvailable = false;
        }
        this.useCache = useCache;
    }

    public CloudInstanceVpcHelper getCloudInstanceVpcHelper() {
        return this.cloudInstanceVpcHelper;
    }

    public void setCloudInstanceVpcHelper(CloudInstanceVpcHelper cloudInstanceVpcHelper) {
        this.cloudInstanceVpcHelper = cloudInstanceVpcHelper;
    }

    public DatacenterVpcHelper getDatacenterVpcHelper() {
        return this.datacenterVpcHelper;
    }

    public void setDatacenterVpcHelper(DatacenterVpcHelper datacenterVpcHelper) {
        this.datacenterVpcHelper = datacenterVpcHelper;
    }

    public VmVpcHelper getVmVpcHelper() {
        return this.vmVpcHelper;
    }

    public void setVmVpcHelper(VmVpcHelper vmVpcHelper) {
        this.vmVpcHelper = vmVpcHelper;
    }

    public GatewayVpcHelper getGatewayVpcHelper() {
        return this.gatewayVpcHelper;
    }

    public void setGatewayVpcHelper(GatewayVpcHelper gatewayVpcHelper) {
        this.gatewayVpcHelper = gatewayVpcHelper;
    }

    @Override
    public boolean isCacheAvailable() {
        return this.cacheAvailable;
    }

    @Override
    public void deleteVdc(String vdcId, String username) {
        String url = "/vdc/<VDC_ID>";
        url = url.replace("<VDC_ID>", vdcId);
        url = this.getUserQualifiedUrl(url, this.vcimSessionMgr.getSessionForUser(username).getClientSessionId());
        this.cacheProxy.sendDeleteRequest(url, null, null);
    }

    @Override
    public void deleteVm(String vmId, String username) {
        String url = "/vm/<VM_ID>";
        url = url.replace("<VM_ID>", vmId);
        url = this.getUserQualifiedUrl(url, this.vcimSessionMgr.getSessionForUser(username).getClientSessionId());
        this.cacheProxy.sendDeleteRequest(url, null, null);
    }

    @Override
    public void deleteGateway(String gatewayId, String username) {
        String url = "/gateway/<GATEWAY_ID>";
        url = url.replace("<GATEWAY_ID>", gatewayId);
        url = this.getUserQualifiedUrl(url, this.vcimSessionMgr.getSessionForUser(username).getClientSessionId());
        this.cacheProxy.sendDeleteRequest(url, null, null);
    }

    @Override
    public void updateVdc(String vdcId, String username) {
        String clientSessionId = this.vcimSessionMgr.getSessionForUser(username).getClientSessionId();
        VdcSnapshotType vdc = this.getVdc(vdcId, clientSessionId);
        List<CloudObjectEntity> clouds = null;
        boolean isShared = true;
        if (CloudTypeType.VPC == vdc.getContainerCloudType()) {
            clouds = this.cloudInstanceVpcHelper.getPublicClouds(clientSessionId);
            isShared = true;
        } else {
            clouds = this.cloudInstanceVpcHelper.getPrivateClouds(clientSessionId);
            isShared = false;
        }
        String vdcCloudId = null;
        vdcCloudId = true == isShared ? vdc.getId() : vdc.getCloudId();
        CloudObjectEntity cloudObject = null;
        for (CloudObjectEntity cloud : clouds) {
            String cloudId = cloud.getId();
            cloudId = true == isShared ? cloudId.substring("public~".length()) : cloudId.substring("private~".length());
            if (!cloudId.equals(vdcCloudId)) continue;
            cloudObject = cloud;
            break;
        }
        if (null != cloudObject) {
            List<CloudObjectEntity> datacenters = this.datacenterVpcHelper.getDatacenters(clientSessionId, cloudObject);
            for (CloudObjectEntity vdcObject : datacenters) {
                if (!vdcObject.getId().equals(vdcId)) continue;
                CacheEntry vdcEntry = this.getCacheEntryFromObject(vdcObject);
                String url = "/vdc/<VDC_ID>";
                url = url.replace("<VDC_ID>", vdcId);
                url = this.getUserQualifiedUrl(url, clientSessionId);
                this.cacheProxy.sendPutRequest(url, vdcEntry, null);
                CloudObjectEntity vdcDetailsObject = this.datacenterVpcHelper.getDatacenterDetails(clientSessionId, vdcObject);
                url = "/vdcdetail/<VDC_ID>";
                url = url.replace("<VDC_ID>", vdcId);
                url = this.getUserQualifiedUrl(url, clientSessionId);
                CacheEntry vdcDetailsEntry = this.getCacheEntryFromObject(vdcDetailsObject);
                this.cacheProxy.sendPutRequest(url, vdcDetailsEntry, null);
                break;
            }
        }
    }

    @Override
    public void updateVm(String vmId, String username) {
        String clientSessionId = this.vcimSessionMgr.getSessionForUser(username).getClientSessionId();
        VMRecordType vmRecordType = this.getVm(vmId, clientSessionId);
        String vdcId = vmRecordType.getVDCId();
        VdcSnapshotType vdc = this.getVdc(vdcId, clientSessionId);
        CloudObjectEntity vdcObject = new CloudObjectEntity(VchsObjectType.DATACENTER, vdc.getId(), null);
        String isShared = null;
        String isDR2C = null;
        String cloudId = null;
        if (CloudTypeType.DR_2_C == vdc.getContainerCloudType()) {
            isDR2C = "true";
            isShared = "true";
            cloudId = "public~" + vdc.getId();
        } else if (CloudTypeType.VPC == vdc.getContainerCloudType()) {
            isShared = "true";
            cloudId = "public~" + vdc.getId();
        } else {
            isShared = "false";
            cloudId = "private~" + vdc.getCloudId();
        }
        vdcObject.getObjectProperties().put("isDR2C", isDR2C);
        vdcObject.getObjectProperties().put("isShared", isShared);
        vdcObject.getObjectProperties().put("cloudId", cloudId);
        List<CloudObjectEntity> vms = this.vmVpcHelper.getVirtualMachines(clientSessionId, vdcObject);
        for (CloudObjectEntity vm : vms) {
            if (!vmId.equals(vm.getId())) continue;
            String url = "/vm/<VM_ID>";
            url = url.replace("<VM_ID>", vmId);
            url = this.getUserQualifiedUrl(url, clientSessionId);
            this.cacheProxy.sendPutRequest(url, this.getCacheEntryFromObject(vm), null);
            url = "/vmdetail/<VM_ID>";
            url = url.replace("<VM_ID>", vmId);
            url = this.getUserQualifiedUrl(url, clientSessionId);
            CloudObjectEntity vmDetails = this.vmVpcHelper.getVirtualMachineDetails(clientSessionId, vm);
            this.cacheProxy.sendPutRequest(url, this.getCacheEntryFromObject(vmDetails), null);
            break;
        }
    }

    @Override
    public void updateGateway(String gatewayId, String username) {
        String clientSessionId = this.vcimSessionMgr.getSessionForUser(username).getClientSessionId();
        String url = "/cloud";
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity response = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        CacheEntries cloudEntries = (CacheEntries)response.getBody();
        block0: for (CacheEntry cloudEntry : cloudEntries.getCacheEntries()) {
            url = "/cloud/<CLOUD_ID>/vdc";
            url = url.replace("<CLOUD_ID>", cloudEntry.getId());
            url = this.getUserQualifiedUrl(url, clientSessionId);
            response = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
            CacheEntries vdcEntries = (CacheEntries)response.getBody();
            CloudObjectEntity vdcObject = null;
            boolean vdcFound = false;
            for (CacheEntry vdcEntry : vdcEntries.getCacheEntries()) {
                url = "/vdc/<VDC_ID>/gateway";
                url = url.replace("<VDC_ID>", vdcEntry.getId());
                url = this.getUserQualifiedUrl(url, clientSessionId);
                response = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
                CacheEntries gatewayEntries = (CacheEntries)response.getBody();
                for (CacheEntry gatewayEntry : gatewayEntries.getCacheEntries()) {
                    if (!gatewayEntry.getId().equals(gatewayId)) continue;
                    String cloudId = cloudEntry.getId();
                    String isShared = null;
                    Object isDr2c = null;
                    if (cloudId.startsWith("private~")) {
                        cloudId = cloudId.substring("private~".length());
                        isShared = "false";
                    } else {
                        cloudId = cloudId.substring("public~".length());
                        isShared = "true";
                    }
                    String vdcId = vdcEntry.getId();
                    vdcObject = new CloudObjectEntity(VchsObjectType.DATACENTER, vdcId, null);
                    vdcObject.getObjectProperties().put("isShared", isShared);
                    vdcObject.getObjectProperties().put("cloudId", cloudId);
                    vdcFound = true;
                    break;
                }
                if (!vdcFound) continue;
                break;
            }
            if (null == vdcObject) continue;
            List<CloudObjectEntity> gateways = this.gatewayVpcHelper.getGateways(clientSessionId, vdcObject);
            for (CloudObjectEntity gateway : gateways) {
                if (!gateway.getId().equals(gatewayId)) continue;
                url = "/gateway/<GATEWAY_ID>";
                url = url.replace("<GATEWAY_ID>", gatewayId);
                url = this.getUserQualifiedUrl(url, clientSessionId);
                this.cacheProxy.sendPutRequest(url, this.getCacheEntryFromObject(gateway), null);
                continue block0;
            }
        }
    }

    @Override
    public void addVdc(String vdcId, String username) {
    }

    @Override
    public void addVm(String vmId, String username) {
    }

    @Override
    public void addGateway(String gatewayId, String username) {
    }

    private CacheEntry getCacheEntryFromObject(CloudObjectEntity object) {
        CacheEntry cacheEntry = new CacheEntry();
        cacheEntry.setId(object.getId());
        cacheEntry.setXmlChunk(object.getPayload());
        return cacheEntry;
    }

    private VMRecordType getVm(String vmId, String clientSessionId) {
        String url = "/vm/<VM_ID>";
        url = url.replace("<VM_ID>", vmId);
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity vdcResponse = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntry.class);
        CacheEntry cacheEntry = (CacheEntry)vdcResponse.getBody();
        String payload = cacheEntry.getXmlChunk();
        VMRecordTypeWrapper vMRecordTypeWrapper = this.unmarshal(payload, VMRecordTypeWrapper.class);
        return vMRecordTypeWrapper.getVmRecordType();
    }

    private VdcSnapshotType getVdc(String vdcId, String clientSessionId) {
        String url = "/vdc/<VDC_ID>";
        url = url.replace("<VDC_ID>", vdcId);
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity vdcResponse = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntry.class);
        CacheEntry cacheEntry = (CacheEntry)vdcResponse.getBody();
        String payload = cacheEntry.getXmlChunk();
        VdcSnapshotTypeWrapper vdcSnapshotTypeWrapper = this.unmarshal(payload, VdcSnapshotTypeWrapper.class);
        return vdcSnapshotTypeWrapper.getVdcSnapshotType();
    }

    private Object getCloud(String cloudId, String clientSessionId) {
        String url = "/cloud/<CLOUD_ID>";
        url = url.replace("<CLOUD_ID>", cloudId);
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity vdcResponse = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntry.class);
        CacheEntry cacheEntry = (CacheEntry)vdcResponse.getBody();
        String payload = cacheEntry.getXmlChunk();
        String id = cacheEntry.getId();
        if (id.startsWith("private~")) {
            DcSnapshotTypeWrapper dcSnapshotTypeWrapper = this.unmarshal(payload, DcSnapshotTypeWrapper.class);
            return dcSnapshotTypeWrapper.getDcSnapshotType();
        }
        VdcSnapshotTypeWrapper vdcSnapshotTypeWrapper = this.unmarshal(payload, VdcSnapshotTypeWrapper.class);
        return vdcSnapshotTypeWrapper.getVdcSnapshotType();
    }

    private GatewaySnapshotType getGateway(String gatewayId, String clientSessionId) {
        String url = "/gateway/<GATEWAY_ID>";
        url = url.replace("<GATEWAY_ID>", gatewayId);
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity vdcResponse = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntry.class);
        CacheEntry cacheEntry = (CacheEntry)vdcResponse.getBody();
        String payload = cacheEntry.getXmlChunk();
        GatewaySnapshotTypeWrapper gatewaySnapshotTypeWrapper = this.unmarshal(payload, GatewaySnapshotTypeWrapper.class);
        return gatewaySnapshotTypeWrapper.getGatewaySnapshotType();
    }

    @Override
    public CacheEntry getCacheEntryForUser(String username) {
        String clientSessionId = this.vcimSessionMgr.getSessionForUser(username).getClientSessionId();
        String url = "/user";
        url = this.getUserQualifiedUrl(url, clientSessionId);
        try {
            ResponseEntity cacheEntry = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntry.class);
            return (CacheEntry)cacheEntry.getBody();
        }
        catch (Exception ex) {
            return null;
        }
    }

    @Override
    public void loadObjectTreeForUser(String username) {
        String clientSessionId = this.vcimSessionMgr.getSessionForUser(username).getClientSessionId();
        String url = "/user";
        url = this.getUserQualifiedUrl(url, clientSessionId);
        this.cacheProxy.sendDeleteRequest(url, null, null);
        this.objectTreeFetcher.loadObjectTree(username);
    }

    @Override
    public void cancelObjectTreeLoading(String username) {
    }

    @Override
    public void cleanUpCache(String username) {
        if (this.cacheProxy == null || !this.cacheAvailable) {
            return;
        }
        String clientSessionId = this.vcimSessionMgr.getSessionForUser(username).getClientSessionId();
        String url = "/user";
        url = this.getUserQualifiedUrl(url, clientSessionId);
        this.cacheProxy.sendDeleteRequest(url, null, null);
    }

    private <T> T unmarshal(String payload, Class<T> objectType) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{objectType});
            Unmarshaller um = context.createUnmarshaller();
            return (T)um.unmarshal((Reader)new StringReader(payload));
        }
        catch (JAXBException jAXBException) {
            return null;
        }
    }

    private String getUserQualifiedUrl(String url, String clientSessionId) {
        VCimSession vcimSession = this.vcimSessionMgr.getSession(clientSessionId);
        return url.concat((url.endsWith("?") ? "" : "?") + "username=" + vcimSession.getUsername().toLowerCase());
    }

    public void stopCacheController() {
        this.cacheControllerLoaded = false;
    }

    private class CacheAvailabilityThread
    extends Thread {
        private CacheAvailabilityThread() {
        }

        @Override
        public void run() {
            while (CacheControllerImpl.this.cacheControllerLoaded) {
                if (CacheControllerImpl.this.useCache) {
                    try {
                        ResponseEntity response = (ResponseEntity)CacheControllerImpl.this.cacheProxy.sendGetRequest("/version", String.class);
                        logger.info("vCHS Cache is reachable now. Marking as available.");
                        if (!CacheControllerImpl.this.cacheAvailable) {
                            CacheControllerImpl.this.cacheAvailable = true;
                            String url = "/users";
                            CacheControllerImpl.this.cacheProxy.sendDeleteRequest(url, null, null);
                            Map<String, VCimSession> sessions = CacheControllerImpl.this.vcimSessionMgr.getActiveSessionsForUniqueUsers();
                            logger.info("We will attempt to reload object heirarchy for all the users intp cache..!");
                            for (VCimSession session : sessions.values()) {
                                CacheControllerImpl.this.objectTreeFetcher.loadObjectTree(session.getUsername());
                            }
                        }
                    }
                    catch (RestClientException ex) {
                        logger.info("vCHS Cache not reachable. Marking as not available.", (Throwable)ex);
                        CacheControllerImpl.this.cacheAvailable = false;
                    }
                    catch (Exception ex) {
                        logger.info("vCHS Cache not reachable. Marking as not available.", (Throwable)ex);
                        CacheControllerImpl.this.cacheAvailable = false;
                    }
                }
                try {
                    Thread.sleep(5000L);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }
}

