/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.impl;

import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;

public abstract class CacheAdapter {
    private VcimSessionManager vcimSessionMgr;

    public CacheAdapter(VcimSessionManager vcimSessionMgr) {
        this.vcimSessionMgr = vcimSessionMgr;
    }

    public <T> String marshal(Object object, Class<T> objectType) {
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{objectType});
            Marshaller marshaller = context.createMarshaller();
            StringWriter stringWriter = new StringWriter();
            marshaller.marshal(object, (Writer)stringWriter);
            return stringWriter.toString();
        }
        catch (JAXBException jAXBException) {
            return null;
        }
    }

    public <T> T unmarshal(JAXBContext context, String payload, Class<T> objectType) {
        try {
            Unmarshaller um = context.createUnmarshaller();
            return (T)um.unmarshal((Reader)new StringReader(payload));
        }
        catch (JAXBException e) {
            return null;
        }
    }

    public String getUserQualifiedUrl(String url, String clientSessionId) {
        VCimSession vcimSession = this.vcimSessionMgr.getSession(clientSessionId);
        return url.concat((url.endsWith("?") ? "" : "?") + "username=" + vcimSession.getUsername().toLowerCase());
    }
}

