/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.impl;

import com.vmware.ares.vcd.v1.DirectLinkDetailsType;
import com.vmware.ares.vcd.v1.FenceModeType;
import com.vmware.ares.vcd.v1.GatewayNetworkType;
import com.vmware.ares.vcd.v1.IpRangeType;
import com.vmware.ares.vcd.v1.NetworkSnapshotType;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.cache.common.CacheProxy;
import com.vmware.vcim.ngc.service.cache.impl.CacheAdapter;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.GatewayNetworkTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.NetworkSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.model.CacheEntries;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.IpRange;
import com.vmware.vcim.ngc.service.model.Network;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.NetworkOperations;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class NetworkCacheAdapter
extends CacheAdapter
implements NetworkOperations,
DataAdapter {
    private CacheProxy cacheProxy;
    private DataAdapterFactory dataAdapterFactory;
    private JAXBContext networkSnapshotTypeWrapperContext;
    private JAXBContext gatewayNetworkTypeWrapperContext;
    private static final Logger logger = LoggerFactory.getLogger(NetworkCacheAdapter.class);
    private final String PLC_NETWORK_NAME = "PRIVATE LINK CONNECT";

    public NetworkCacheAdapter(VcimSessionManager vcimSessionMgr, CacheProxy cacheProxy) {
        super(vcimSessionMgr);
        this.cacheProxy = cacheProxy;
        try {
            this.networkSnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{NetworkSnapshotTypeWrapper.class});
            this.gatewayNetworkTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{GatewayNetworkTypeWrapper.class});
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
    }

    @Override
    public List<Network> getNetworks(String clientSessionId, String vpcId, String vdcId) {
        ArrayList<Network> networks = new ArrayList<Network>();
        CacheEntries networksList = null;
        String url = "/vdc/<VDC_ID>/network";
        url = url.replace("<VDC_ID>", vdcId);
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity response = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        networksList = (CacheEntries)response.getBody();
        logger.info("Got networks for cloud id - " + vpcId + ", vdc Id - " + vdcId);
        for (CacheEntry networkEntry : networksList.getCacheEntries()) {
            NetworkSnapshotTypeWrapper networkSnapshotTypeWrapper = this.unmarshal(this.networkSnapshotTypeWrapperContext, networkEntry.getXmlChunk(), NetworkSnapshotTypeWrapper.class);
            NetworkSnapshotType networkSnapshot = networkSnapshotTypeWrapper.getNetworkSnapshotType();
            Network network = new Network(networkSnapshot.getId(), networkSnapshot.getName(), networkSnapshot.getHref());
            network.setType("NonPlc");
            network.setDefault(networkSnapshot.isDefaultNetwork());
            network.setEdgeGatewayName("");
            Network.FenceMode fenceMode = Network.FenceMode.ISOLATED;
            if (FenceModeType.NAT_ROUTED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.NAT_ROUTED;
                network.setEdgeGatewayName(networkSnapshot.getRoutedNetwork().getEdgeGatewayName());
                network.setEdgeGatewayAddress(networkSnapshot.getRoutedNetwork().getEdgeGatewayAddress());
                network.setAllocatedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getAllocated());
                network.setUsedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getUsed());
            } else if (FenceModeType.BRIDGED == networkSnapshot.getFenceMode()) {
                fenceMode = Network.FenceMode.BRIDGED;
            }
            network.setFenceMode(fenceMode);
            network.setVdcId(vdcId);
            network.setVpcId(vpcId);
            network.setGatewayId("");
            networks.add(network);
        }
        return networks;
    }

    @Override
    public List<Network> getNetworksForGateway(String clientSessionId, String vpcId, String vdcId, String gatewayId) {
        ArrayList<Network> networksForGateway = new ArrayList<Network>();
        String url = "/gateway/<GATEWAY_ID>/gatewaynetwork";
        url = url.replace("<GATEWAY_ID>", gatewayId);
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity response = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        CacheEntries gatewayNetworkTypes = (CacheEntries)response.getBody();
        logger.info("Got networks for gateway id - " + gatewayId);
        for (CacheEntry cacheEntry : gatewayNetworkTypes.getCacheEntries()) {
            Network network;
            GatewayNetworkTypeWrapper gatewayNetworkTypeWrapper = this.unmarshal(this.gatewayNetworkTypeWrapperContext, cacheEntry.getXmlChunk(), GatewayNetworkTypeWrapper.class);
            GatewayNetworkType gatewayNetworkType = gatewayNetworkTypeWrapper.getGatewayNetworkType();
            for (NetworkSnapshotType networkSnapshot : gatewayNetworkType.getNetworkList().getNetworkSnapshot()) {
                network = new Network(networkSnapshot.getId(), networkSnapshot.getName(), networkSnapshot.getHref());
                network.setDefault(networkSnapshot.isDefaultNetwork());
                network.setEdgeGatewayName("");
                Network.FenceMode fenceMode = Network.FenceMode.ISOLATED;
                if (FenceModeType.NAT_ROUTED == networkSnapshot.getFenceMode()) {
                    fenceMode = Network.FenceMode.NAT_ROUTED;
                    network.setEdgeGatewayName(networkSnapshot.getRoutedNetwork().getEdgeGatewayName());
                    network.setEdgeGatewayAddress(networkSnapshot.getRoutedNetwork().getEdgeGatewayAddress());
                    network.setAllocatedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getAllocated());
                    network.setUsedPublicIps(networkSnapshot.getRoutedNetwork().getPublicIpUsage().getUsed());
                } else if (FenceModeType.BRIDGED == networkSnapshot.getFenceMode()) {
                    fenceMode = Network.FenceMode.BRIDGED;
                }
                network.setAllocatedVMs(networkSnapshot.getVmsAllocated());
                network.setPoweredOnVMs(networkSnapshot.getVmsPoweredOn());
                for (IpRangeType ipRange : networkSnapshot.getIpRanges().getIpRange()) {
                    IpRange range = new IpRange(ipRange.getStartAddress(), ipRange.getEndAddress());
                    network.getIpRange().add(range);
                }
                network.setDefaultGatewayIp(networkSnapshot.getDefaultGateway());
                network.setFenceMode(fenceMode);
                network.setType("NonPlc");
                network.setVdcId(vdcId);
                network.setVpcId(vpcId);
                network.setGatewayId(gatewayId);
                networksForGateway.add(network);
            }
            for (DirectLinkDetailsType directLink : gatewayNetworkType.getDirectLinksList().getDirectLinkDetails()) {
                network = new Network(directLink.getGatewayAddress(), "PRIVATE LINK CONNECT", "");
                network.setType("Plc");
                network.setIpPool(directLink.getIpPool());
                network.setEdgeGatewayName(directLink.getGatewayName());
                network.setEdgeGatewayAddress(directLink.getGatewayAddress());
                network.setVdcId(vdcId);
                network.setVpcId(vpcId);
                network.setGatewayId(gatewayId);
                networksForGateway.add(network);
                logger.info("Got PLC network " + directLink.getGatewayName() + " for gateway - " + gatewayId);
            }
        }
        return networksForGateway;
    }

    @Override
    public Network getNetwork(String clientSessionId, String vpcId, String vdcId, URI networkUri) {
        String gatewayId = Network.getGatewayId(networkUri);
        logger.info("Getting network for cloud id - " + vpcId + ", vdc id - " + vdcId + " and having URI - " + networkUri.toString());
        List<Network> networks = this.getNetworksForGateway(clientSessionId, vpcId, vdcId, gatewayId);
        for (Network network : networks) {
            if (!network.getUri().equals(networkUri)) continue;
            logger.info("Found network having URI - " + networkUri.toString());
            return network;
        }
        return null;
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_ONLY_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.NETWORK;
    }

    @Override
    public Object getDR2CNetworks(String sessionId, String string, String string2) {
        return null;
    }

    @Override
    public Network getDR2CNetwork(String clientSessionId, String vpcId, String vdcId, URI networkUri) {
        return null;
    }

    @Override
    public List<Network> getDR2CNetworksForGateway(String clientSessionId, String vpcId, String vdcId, String gatewayId) {
        return null;
    }
}

