/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.impl;

import com.vmware.ares.common.v1.EntityState;
import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.vcd.v1.VdcUserType;
import com.vmware.ares.vcd.v2.VdcSnapshotType;
import com.vmware.ares.vcd.v2.VdcType;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.cache.common.CacheProxy;
import com.vmware.vcim.ngc.service.cache.impl.CacheAdapter;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VdcSnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VdcTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VdcUserTypeWrapper;
import com.vmware.vcim.ngc.service.cache.model.CacheEntries;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.DR2CVMCount;
import com.vmware.vcim.ngc.service.model.VCimRegion;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachineReplicationStatus;
import com.vmware.vcim.ngc.service.model.VCimVpc;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.model.VdcUser;
import com.vmware.vcim.ngc.service.vpc.contracts.CloudInstanceOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.RegionOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vcim.ngc.service.vpc.impl.RegionVpcAdapter;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class VirtualDatacenterCacheAdapter
extends CacheAdapter
implements VirtualDatacenterOperations,
DataAdapter {
    private DataAdapterFactory dataAdapterFactory;
    private final AdapterWrapper adapterWrapper;
    private final CacheProxy cacheProxy;
    private final RegionVpcAdapter regionAdapter;
    private static final Logger logger = LoggerFactory.getLogger(VirtualDatacenterCacheAdapter.class);
    private JAXBContext vdcTypeWrapperContext;
    private JAXBContext vdcUserTypeWrapperContext;
    private JAXBContext vdcSnapshotTypeWrapperContext;

    public VirtualDatacenterCacheAdapter(VcimSessionManager vcimSessionMgr, CacheProxy cacheProxy, AdapterWrapper adapterWrapper, RegionVpcAdapter regionAdapter) {
        super(vcimSessionMgr);
        this.cacheProxy = cacheProxy;
        this.adapterWrapper = adapterWrapper;
        this.regionAdapter = regionAdapter;
        try {
            this.vdcTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VdcTypeWrapper.class});
            this.vdcUserTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VdcUserTypeWrapper.class});
            this.vdcSnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VdcSnapshotTypeWrapper.class});
        }
        catch (JAXBException e) {
            // empty catch block
        }
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimVirtualDatacenter> getVDCs(String clientSessionId) {
        ArrayList<VCimVirtualDatacenter> vdcs = new ArrayList<VCimVirtualDatacenter>();
        List<VCimRegion> regions = this.regionAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vdcs.addAll(this.getVDCs(clientSessionId, region, DatacenterType.BOTH));
        }
        return vdcs;
    }

    @Override
    public List<VCimVirtualDatacenter> getSharedVDCs(String clientSessionId) {
        ArrayList<VCimVirtualDatacenter> vdcs = new ArrayList<VCimVirtualDatacenter>();
        List<VCimRegion> regions = this.regionAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vdcs.addAll(this.getVDCs(clientSessionId, region, DatacenterType.SHARED));
        }
        return vdcs;
    }

    private List<VCimVirtualDatacenter> getVDCs(String clientSessionId, VCimRegion region, DatacenterType vdcType) {
        logger.info("Fetching vdcs of region " + region.getName());
        ArrayList<VCimVirtualDatacenter> vDCs = new ArrayList<VCimVirtualDatacenter>();
        String url = "/<REGION_ID>/cloud";
        url = url.replace("<REGION_ID>", region.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity clouds = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        for (CacheEntry cacheEntry : ((CacheEntries)clouds.getBody()).getCacheEntries()) {
            url = "/cloud/<CLOUD_ID>/vdc";
            url = url.replace("<CLOUD_ID>", cacheEntry.getId());
            url = this.getUserQualifiedUrl(url, clientSessionId);
            ResponseEntity vdcs = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
            for (CacheEntry vdcEntry : ((CacheEntries)vdcs.getBody()).getCacheEntries()) {
                VdcSnapshotTypeWrapper vdcSnapshotTypeWrapper = this.unmarshal(this.vdcSnapshotTypeWrapperContext, vdcEntry.getXmlChunk(), VdcSnapshotTypeWrapper.class);
                VdcSnapshotType vdc = vdcSnapshotTypeWrapper.getVdcSnapshotType();
                if (vdcType != DatacenterType.BOTH && (vdc.getContainerCloudType() != CloudTypeType.DC || vdcType != DatacenterType.PRIVATE) && (vdc.getContainerCloudType() != CloudTypeType.VPC || vdcType != DatacenterType.SHARED)) continue;
                VCimVirtualDatacenter vDC = new VCimVirtualDatacenter(vdc);
                vDC.setRegionName(region.getName());
                vDC.setRegionId(region.getId());
                vDCs.add(vDC);
            }
        }
        return vDCs;
    }

    private void getVDCDetails(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching details of vdcs - " + vDC.getName());
        String url = "/vdcdetail/<VDC_ID>";
        url = url.replace("<VDC_ID>", vDC.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity vdcDetails = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntry.class);
        VdcTypeWrapper vdcTypeWrapper = this.unmarshal(this.vdcTypeWrapperContext, ((CacheEntry)vdcDetails.getBody()).getXmlChunk(), VdcTypeWrapper.class);
        VdcType vdcType = vdcTypeWrapper.getVdcType();
        vDC.setDescription(vdcType.getDescription());
        vDC.setEnabled(vdcType.isIsEnabled());
        vDC.setVmQuota(vdcType.getVmQuota());
    }

    private void getVPCDetailsForVDC(String clientSessionId, VCimVirtualDatacenter vDC, String vpcId) {
        logger.info("Fetching cloud details of vdc" + vDC.getName());
        VCimVpc vpc = this.getCloudReadOnlyAdapter().getVpcById(clientSessionId, vpcId);
        vDC.setVpcVcpuAvailable(vpc.getCpuAvailable());
        vDC.setVpcMemoryAvailable(vpc.getMemoryAvailable());
        vDC.setVpcStorageAvailable(vpc.getStorageAvailable());
    }

    @Override
    public VCimVirtualDatacenter getVDC(String clientSessionId, URI vDCUri) {
        logger.info("Fetching VDC with URI - " + vDCUri.toString());
        List<VCimVirtualDatacenter> vDCs = this.getVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vDCUri.equals(vDC.getUri())) continue;
                try {
                    this.getVDCDetails(clientSessionId, vDC);
                }
                catch (Exception ex) {
                    logger.error("Error fetching details of VDC", (Throwable)ex);
                }
                String vpcId = VCimVirtualDatacenter.getVpcId(vDCUri);
                this.getVPCDetailsForVDC(clientSessionId, vDC, vpcId);
                logger.info("VDC found");
                return vDC;
            }
        }
        return null;
    }

    @Override
    public VCimVirtualDatacenter getVDCById(String clientSessionId, String vdcId) {
        logger.info("Fetching VDC with id - " + vdcId);
        List<VCimVirtualDatacenter> vDCs = this.getVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vDC.getId().equalsIgnoreCase(vdcId)) continue;
                logger.info("VDC found - " + vDC.getName());
                return vDC;
            }
        }
        return null;
    }

    @Override
    public List<VdcUser> getVdcUsers(String clientSessionId, String vpcId, String vdcId) {
        logger.info("Fetching users of VDC with id - " + vdcId);
        ArrayList<VdcUser> users = new ArrayList<VdcUser>();
        String url = "/vdc/<VDC_ID>/user";
        url = url.replace("<VDC_ID>", vdcId);
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity clouds = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        for (CacheEntry userEntry : ((CacheEntries)clouds.getBody()).getCacheEntries()) {
            VdcUserTypeWrapper vdcUserTypeWrapper = this.unmarshal(this.vdcUserTypeWrapperContext, userEntry.getXmlChunk(), VdcUserTypeWrapper.class);
            VdcUserType vdcUser = vdcUserTypeWrapper.getVdcUserType();
            if (null == vdcUser) continue;
            VdcUser user = new VdcUser();
            user.setId(vdcUser.getId());
            user.setFirstName(vdcUser.getFirstName());
            user.setLastName(vdcUser.getLastName());
            user.setUsername(vdcUser.getUsername());
            user.setHref(vdcUser.getHref());
            user.setEditable(vdcUser.isEditable());
            user.setRoles(vdcUser.getRoles());
            user.setHasVdcAccess(vdcUser.isHasVdcAccess());
            users.add(user);
        }
        return users;
    }

    @Override
    public void addVdc(String clientSessionId, String vdcName, String vpcId, int cpu, int memory, String storage, int publicIps) {
    }

    @Override
    public void updateVdcSettings(String clientSessionId, String href, String vdcName, String vdcDesc, int cpuAlloc, int memoryAlloc, String storageAlloc) {
    }

    @Override
    public void updateVdcVMQuota(String clientSessionId, String href, int vmQuota) {
    }

    @Override
    public void deleteVdc(String clientSessionId, String href) {
    }

    @Override
    public void changeVdcStatus(String clientSessionId, String href, boolean status) {
    }

    @Override
    public List<VCimVirtualDatacenter> getVDCsForVpc(String clientSessionId, String vpcId) {
        ArrayList<VCimVirtualDatacenter> vdcList = new ArrayList<VCimVirtualDatacenter>();
        VCimVpc vpc = this.getCloudReadOnlyAdapter().getVpcById(clientSessionId, vpcId);
        logger.info("Get VDCs2 for cloud - " + vpc.getName());
        URI vpcUri = vpc.getUri();
        String regionId = VCimVpc.getRegionId(vpcUri);
        boolean isPrivate = VCimVpc.isPrivate(vpcUri);
        VCimRegion region = this.regionAdapter.getRegion(clientSessionId, regionId);
        List<VCimVirtualDatacenter> vDCs = this.getVDCs(clientSessionId, region, isPrivate ? DatacenterType.PRIVATE : DatacenterType.SHARED);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vpcId.equalsIgnoreCase(vDC.getCloudId()) || EntityState.ERROR == vDC.getState()) continue;
                vDC.setVpcVcpuAvailable(vpc.getCpuAvailable());
                vDC.setVpcMemoryAvailable(vpc.getMemoryAvailable());
                vDC.setVpcStorageAvailable(vpc.getStorageAvailable());
                vdcList.add(vDC);
            }
        }
        return vdcList;
    }

    @Override
    public List<VCimVirtualDatacenter> getPrivateVDCs(String clientSessionId) {
        ArrayList<VCimVirtualDatacenter> vdcs = new ArrayList<VCimVirtualDatacenter>();
        List<VCimRegion> regions = this.regionAdapter.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            vdcs.addAll(this.getVDCs(clientSessionId, region, DatacenterType.PRIVATE));
        }
        return vdcs;
    }

    @Override
    public String getVcdSsoToken(String clientSessionId, String vdcId) {
        return null;
    }

    @Override
    public String getVcdSsoToken(String clientSessionId, VCimVirtualDatacenter vdc) {
        return null;
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_ONLY_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.DATACENTER;
    }

    private RegionOperations getRegionReadOnlyAdapter() {
        return (RegionOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.REGION));
    }

    private CloudInstanceOperations getCloudReadOnlyAdapter() {
        return (CloudInstanceOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.CLOUD));
    }

    @Override
    public List<VCimVirtualMachineReplicationStatus> getVirtualMachineReplicationStatusesForVdc(String clientSessionId, String vdcId) {
        return null;
    }

    @Override
    public DR2CVMCount getDR2CVMCount(String clientSessionId, String vdcId) {
        return null;
    }

    private static enum DatacenterType {
        PRIVATE,
        SHARED,
        BOTH;

    }
}

