/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.impl;

import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.vcd.v1.NetworkDetailsType;
import com.vmware.ares.vcd.v1.VmSettingsType;
import com.vmware.ares.vcd.v1.VmStorageParamsType;
import com.vmware.ares.vcd.v2.VMRecordType;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.cache.common.CacheProxy;
import com.vmware.vcim.ngc.service.cache.impl.CacheAdapter;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VMRecordTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.VmSettingsTypeWrapper;
import com.vmware.vcim.ngc.service.cache.model.CacheEntries;
import com.vmware.vcim.ngc.service.cache.model.CacheEntry;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.LinkType;
import com.vmware.vcim.ngc.service.model.ResourceSummary;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachine;
import com.vmware.vcim.ngc.service.model.VMNetwork;
import com.vmware.vcim.ngc.service.model.VMStorage;
import com.vmware.vcim.ngc.service.model.VMSummary;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.model.VdcAvailableComputeData;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualMachineOperations;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class VirtualMachineCacheAdapter
extends CacheAdapter
implements VirtualMachineOperations,
DataAdapter {
    private DataAdapterFactory dataAdapterFactory;
    private final AdapterWrapper adapterWrapper;
    private final CacheProxy cacheProxy;
    private JAXBContext vmRecordTypeWrapperContext;
    private JAXBContext vmSettingsTypeWrapperContext;
    private static final Logger logger = LoggerFactory.getLogger(VirtualMachineCacheAdapter.class);

    private VirtualMachineCacheAdapter(VcimSessionManager vcimSessionMgr, CacheProxy cacheProxy, AdapterWrapper adapterWrapper) {
        super(vcimSessionMgr);
        this.cacheProxy = cacheProxy;
        this.adapterWrapper = adapterWrapper;
        try {
            this.vmRecordTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VMRecordTypeWrapper.class});
            this.vmSettingsTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{VmSettingsTypeWrapper.class});
        }
        catch (JAXBException e) {
            // empty catch block
        }
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimVirtualMachine> getVirtualMachines(String clientSessionId) {
        ArrayList<VCimVirtualMachine> vms = new ArrayList<VCimVirtualMachine>();
        logger.debug("Fetching virtual machines for client id - " + clientSessionId);
        List<VCimVirtualDatacenter> vDCs = this.getVdcReadOnlyAdapter().getVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                vms.addAll(this.getVirtualMachines(clientSessionId, vDC));
            }
        }
        return vms;
    }

    @Override
    public List<VCimVirtualMachine> getVirtualMachinesForVdc(String clientSessionId, String vdcId) {
        List<VCimVirtualMachine> vms = new ArrayList<VCimVirtualMachine>();
        VCimVirtualDatacenter vDC = this.getVdcReadOnlyAdapter().getVDCById(clientSessionId, vdcId);
        if (null != vDC) {
            vms = this.getVirtualMachines(clientSessionId, vDC);
        }
        return vms;
    }

    @Override
    public List<VCimVirtualMachine> getVirtualMachinesForVdc(String clientSessionId, VCimVirtualDatacenter vdc) {
        List<VCimVirtualMachine> vms = new ArrayList<VCimVirtualMachine>();
        if (null != vdc) {
            vms = this.getVirtualMachines(clientSessionId, vdc);
        }
        return vms;
    }

    private List<VCimVirtualMachine> getVirtualMachines(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.debug("Fetching virtual machines for VDC - " + vDC.getName());
        Date currentTimestamp = new Date();
        logger.info("Fetching virtual machines for VDC " + vDC.getName() + " from cache, Timestamp @ " + currentTimestamp.getTime());
        ArrayList<VCimVirtualMachine> vms = new ArrayList<VCimVirtualMachine>();
        String url = "/vdc/<VDC_ID>/vm";
        url = url.replace("<VDC_ID>", vDC.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        Boolean isShared = false;
        if (!vDC.isPrivate()) {
            isShared = true;
        }
        ResponseEntity vmEntries = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntries.class);
        for (CacheEntry vmEntry : ((CacheEntries)vmEntries.getBody()).getCacheEntries()) {
            VMRecordTypeWrapper vmRecordTypeWrapper = this.unmarshal(this.vmRecordTypeWrapperContext, vmEntry.getXmlChunk(), VMRecordTypeWrapper.class);
            VMRecordType vmRecord = vmRecordTypeWrapper.getVmRecordType();
            vmRecord.setVDCId(vDC.getId());
            VCimVirtualMachine vm = null;
            vm = vDC.getContainerCloudType() == CloudTypeType.DR_2_C ? new VCimVirtualMachine(vmRecord, isShared != false ? "" : vDC.getCloudId(), true, null) : new VCimVirtualMachine(vmRecord, isShared != false ? "" : vDC.getCloudId());
            vm.setVDC(vDC);
            vm.setvAppName(vmRecord.getVAppDetails().getVAPPName());
            vm.setAllocatedMemory(vmRecord.getLiveUsage().getMemoryAllocated());
            vms.add(vm);
        }
        currentTimestamp = new Date();
        logger.info("Completed fetching virtual machines for VDC " + vDC.getName() + " from cache, Timestamp @ " + currentTimestamp.getTime());
        return vms;
    }

    private VmSettingsType getVMSettings(String clientSessionId, VCimVirtualMachine vm) {
        logger.debug("Fetching settings for VM - " + vm.getName());
        String url = "/vmdetail/<VM_ID>";
        url = url.replace("<VM_ID>", vm.getId());
        url = this.getUserQualifiedUrl(url, clientSessionId);
        ResponseEntity vdcDetails = (ResponseEntity)this.cacheProxy.sendGetRequest(url, CacheEntry.class);
        VmSettingsTypeWrapper vmSettingsTypeWrapper = this.unmarshal(this.vmSettingsTypeWrapperContext, ((CacheEntry)vdcDetails.getBody()).getXmlChunk(), VmSettingsTypeWrapper.class);
        return vmSettingsTypeWrapper.getVmSettingsType();
    }

    @Override
    public VCimVirtualMachine getVirtualMachine(String clientSessionId, URI vmUri) {
        logger.debug("Getting details of VM with URI: " + vmUri.toString());
        String vpcId = VCimVirtualMachine.getVpcId(vmUri);
        List<VCimVirtualDatacenter> vDCs = StringUtils.isEmpty((String)vpcId) ? this.getVdcReadOnlyAdapter().getSharedVDCs(clientSessionId) : this.getVdcReadOnlyAdapter().getPrivateVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                List<VCimVirtualMachine> vms = this.getVirtualMachines(clientSessionId, vDC);
                if (vms == null) continue;
                for (VCimVirtualMachine vm : vms) {
                    if (!vmUri.equals(vm.getUri())) continue;
                    VmSettingsType vmSettings = this.getVMSettings(clientSessionId, vm);
                    vm.setAllocatedCPU(vmSettings.getVCpu());
                    vm.setAllocatedMemory(vmSettings.getMemoryMb());
                    vm.setSnapshotStateBoolean(this.isSnapshotAvailable(clientSessionId, vmUri));
                    vm.setGuestOSCustomization(vmSettings.isEnableGuestCustomization());
                    vm.setGuestOSPassword(vmSettings.getGuestPassword());
                    vm.setVmwareTools(vmSettings.getVmwareTools());
                    long storage = 0L;
                    for (int i = 0; i < vmSettings.getStorageMb().size(); ++i) {
                        storage += (long)vmSettings.getStorageMb().get(i).getCapacityMb();
                    }
                    vm.setAllocatedStorage(storage);
                    return vm;
                }
            }
        }
        return null;
    }

    @Override
    public void powerOnVirtualMachine(String clientSessionId, URI vmUri) {
    }

    @Override
    public void powerOffVirtualMachine(String clientSessionId, URI vmUri) {
    }

    @Override
    public String getScreenTicket(String clientSessionId, URI vmUri) {
        return null;
    }

    @Override
    public void suspendVirtualMachine(String clientSessionId, URI vmUri) {
    }

    @Override
    public void resetVirtualMachine(String clientSessionId, URI vmUri) {
    }

    public ResourceSummary getVMSummary(String clientSessionId) {
        return null;
    }

    @Override
    public void deleteVirtualMachine(String clientSessionId, URI vmUri) {
    }

    @Override
    public VMSummary getVMData(String clientSessionId, URI vmUri) {
        logger.debug("Fetching VM Summary for VM with URI: " + vmUri.toString());
        VCimVirtualMachine vm = this.getVirtualMachine(clientSessionId, vmUri);
        VmSettingsType vmSettings = this.getVMSettings(clientSessionId, vm);
        VMSummary vmSummary = this.getVMSummaryFromVMSettings(vmSettings);
        vmSummary.setVdcId(vm.getVDCId());
        vmSummary.setPowerState(vm.getVMState());
        vmSummary.setVpcId(vm.getVpcId());
        return vmSummary;
    }

    private VMSummary getVMSummaryFromVMSettings(VmSettingsType vmSettings) {
        ArrayList<VMStorage> storage = new ArrayList<VMStorage>();
        ArrayList<VMNetwork> network = new ArrayList<VMNetwork>();
        VMSummary vmSummary = new VMSummary(0, 0L, null);
        ArrayList<LinkType> links = new ArrayList<LinkType>();
        for (com.vmware.ares.common.v1.LinkType linkType : vmSettings.getVCloudUILink()) {
            LinkType vcdLink = new LinkType(linkType.getHref(), linkType.getName(), linkType.getRel());
            links.add(vcdLink);
        }
        vmSummary.setLinks(links);
        vmSummary.setId(vmSettings.getId());
        vmSummary.setHref(vmSettings.getHref());
        vmSummary.setName(vmSettings.getName());
        vmSummary.setDescription(vmSettings.getDescription());
        vmSummary.setvAppId(vmSettings.getVAppId());
        vmSummary.setBackup(vmSettings.isBackup());
        vmSummary.setVmwareTools(vmSettings.getVmwareTools());
        vmSummary.setVcpu(vmSettings.getVCpu());
        vmSummary.setMemory(vmSettings.getMemoryMb());
        vmSummary.setEnableGuestCustomization(vmSettings.isEnableGuestCustomization());
        vmSummary.setOwner(vmSettings.getOwner());
        vmSummary.setGuestPassword(vmSettings.getGuestPassword());
        vmSummary.setVdcAvailableComputeResources(new VdcAvailableComputeData(vmSettings.getVdcAvailableComputeDetails().getVCpu(), vmSettings.getVdcAvailableComputeDetails().getMemoryMb(), vmSettings.getVdcAvailableComputeDetails().getStorageMb()));
        vmSummary.setDpsProvisioned(vmSettings.isDPSProvisioned());
        for (VmStorageParamsType vmStore : vmSettings.getStorageMb()) {
            VMStorage vmStorage = new VMStorage(0, 0);
            vmStorage.setCapacity(vmStore.getCapacityMb());
            vmStorage.setPort(vmStore.getPort());
            storage.add(vmStorage);
        }
        for (NetworkDetailsType networkDetails : vmSettings.getNetworkDetails()) {
            VMNetwork vmNetwork = new VMNetwork();
            ArrayList<String> gatewayNames = new ArrayList<String>();
            ArrayList<String> gatewayIps = new ArrayList<String>();
            vmNetwork.setNetworkId(networkDetails.getId());
            vmNetwork.setHref(networkDetails.getHref());
            vmNetwork.setName(networkDetails.getName());
            for (JAXBElement<?> element : networkDetails.getRest()) {
                String elementName = element.getName().getLocalPart();
                if (elementName.equalsIgnoreCase("Type")) {
                    vmNetwork.setType(element.getValue().toString());
                    continue;
                }
                if (!elementName.equalsIgnoreCase("vmIP")) continue;
                vmNetwork.setIpAddress(element.getValue().toString());
            }
            vmNetwork.setGatewayNames(gatewayNames);
            vmNetwork.setGatewayIps(gatewayIps);
            network.add(vmNetwork);
        }
        vmSummary.setStorage(storage);
        vmSummary.setNetwork(network);
        return vmSummary;
    }

    @Override
    public void editVMSettings(String clientSessionId, URI vmUri, VMSummary vmSummary) {
    }

    @Override
    public void updateVMNetworks(String clientSessionId, URI vmUri, String vAppId, List<VMNetwork> networks) {
    }

    @Override
    public void createSnapshot(String clientSessionId, URI vmUri) {
    }

    @Override
    public void revertSnapshot(String clientSessionId, URI vmUri) {
    }

    @Override
    public void deleteSnapshot(String clientSessionId, URI vmUri) {
    }

    @Override
    public boolean isSnapshotAvailable(String clientSessionId, URI vmUri) {
        return false;
    }

    @Override
    public void enrollVmForDps(String clientSessionId, URI vmUri, boolean backup) {
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_ONLY_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.VIRTUAL_MACHINE;
    }

    private VirtualDatacenterOperations getVdcReadOnlyAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER));
    }

    @Override
    public void test(String clientSessionId, URI vm) {
    }

    @Override
    public void cleanup(String clientSessionId, URI vm) {
    }

    @Override
    public void failover(String clientSessionId, URI vm) {
    }

    @Override
    public void removereplication(String clientSessionId, URI vm) {
    }
}

