/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.vpc.impl;

import com.vmware.ares.vcd.v1.GatewayNetworkType;
import com.vmware.ares.vcd.v1.GatewaySnapshotListType;
import com.vmware.ares.vcd.v1.GatewaySnapshotType;
import com.vmware.vcim.ngc.service.cache.common.CloudObjectEntity;
import com.vmware.vcim.ngc.service.cache.helper.GatewayVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.VpcHelper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.GatewayNetworkTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.GatewaySnapshotTypeWrapper;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.springframework.http.ResponseEntity;

public class GatewayVpcHelperImpl
extends VpcHelper
implements GatewayVpcHelper {
    private JAXBContext gatewaySnapshotTypeWrapperContext;
    private JAXBContext gatewayNetworkTypeWrapperContext;

    public GatewayVpcHelperImpl(VcimRestClient vcimRestClient, VcimSessionManager vcimSessionMgr) {
        super(vcimRestClient, vcimSessionMgr);
        try {
            this.gatewaySnapshotTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{GatewaySnapshotTypeWrapper.class});
            this.gatewayNetworkTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{GatewayNetworkTypeWrapper.class});
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    @Override
    public List<CloudObjectEntity> getGateways(String clientSessionId, CloudObjectEntity vdcObject) {
        boolean isShared = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isShared"));
        boolean isDr2c = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isDR2C"));
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/edgeGateways";
        String cloudId = null;
        if (isShared) {
            url = isDr2c ? "/api/private/dr2c/<VDC_ID>/edgeGateways" : "/api/private/vpc/<VDC_ID>/edgeGateways";
        } else {
            cloudId = vdcObject.getObjectProperties().get("cloudId");
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            url = url.replace("<VPC_ID>", cloudId);
        }
        ArrayList<CloudObjectEntity> gatewayObjects = new ArrayList<CloudObjectEntity>();
        String vdcId = vdcObject.getId();
        url = url.replace("<VDC_ID>", vdcId);
        ResponseEntity gatewayResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, GatewaySnapshotListType.class, null, clientSessionId);
        if (null != gatewayResponse) {
            GatewaySnapshotListType gateWays = (GatewaySnapshotListType)gatewayResponse.getBody();
            for (GatewaySnapshotType gatewaySnapshot : gateWays.getGatewaySnapshot()) {
                GatewaySnapshotTypeWrapper gatewaySnapshotTypeWrapper = new GatewaySnapshotTypeWrapper();
                gatewaySnapshotTypeWrapper.setGatewaySnapshotType(gatewaySnapshot);
                CloudObjectEntity gatewayObject = new CloudObjectEntity(VchsObjectType.GATEWAY, gatewaySnapshot.getId(), this.marshal(this.gatewaySnapshotTypeWrapperContext, gatewaySnapshotTypeWrapper));
                gatewayObject.setObjectProperties(vdcObject.getObjectProperties());
                gatewayObject.getObjectProperties().put("vdcId", vdcId);
                if (!isShared) {
                    gatewayObject.getObjectProperties().put("cloudId", cloudId);
                }
                gatewayObjects.add(gatewayObject);
            }
        }
        return gatewayObjects;
    }

    @Override
    public List<CloudObjectEntity> getGatewayNetworks(String clientSessionId, CloudObjectEntity gatewayObject) {
        ArrayList<CloudObjectEntity> gatewayNetworkObjects = new ArrayList<CloudObjectEntity>();
        boolean isShared = Boolean.parseBoolean(gatewayObject.getObjectProperties().get("isShared"));
        boolean isDr2c = Boolean.parseBoolean(gatewayObject.getObjectProperties().get("isDR2C"));
        String vdcId = gatewayObject.getObjectProperties().get("vdcId");
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/edgeGateway/<GATEWAY_ID>/networks";
        if (!isShared) {
            String cloudId = gatewayObject.getObjectProperties().get("cloudId");
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            url = url.replace("<VPC_ID>", cloudId);
        } else {
            url = true == isDr2c ? "/api/private/dr2c/<VDC_ID>/edgeGateway/<GATEWAY_ID>/networks" : "/api/private/vpc/<VDC_ID>/edgeGateway/<GATEWAY_ID>/networks";
        }
        url = url.replace("<VDC_ID>", vdcId);
        url = url.replace("<GATEWAY_ID>", gatewayObject.getId());
        ResponseEntity response = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, GatewayNetworkType.class, null, clientSessionId);
        GatewayNetworkTypeWrapper gatewayNetworkTypeWrapper = new GatewayNetworkTypeWrapper();
        GatewayNetworkType gatewayNetworkType = (GatewayNetworkType)response.getBody();
        gatewayNetworkTypeWrapper.setGatewayNetworkType(gatewayNetworkType);
        CloudObjectEntity gatewayNetwork = new CloudObjectEntity(VchsObjectType.GATEWAY_NETWORK, gatewayObject.getId(), this.marshal(this.gatewayNetworkTypeWrapperContext, gatewayNetworkTypeWrapper));
        gatewayNetwork.setObjectProperties(gatewayObject.getObjectProperties());
        gatewayNetworkObjects.add(gatewayNetwork);
        return gatewayNetworkObjects;
    }
}

