/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.cache.vpc.impl;

import com.vmware.ares.vcd.v1.MyImageRecordType;
import com.vmware.ares.vcd.v1.MyImagesListType;
import com.vmware.ares.vcd.v1.OperatingSystemCatalogRecordListType;
import com.vmware.ares.vcd.v1.OperatingSystemCatalogRecordType;
import com.vmware.vcim.ngc.service.cache.common.CloudObjectEntity;
import com.vmware.vcim.ngc.service.cache.helper.TemplateVpcHelper;
import com.vmware.vcim.ngc.service.cache.helper.VpcHelper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.MyImageRecordTypeWrapper;
import com.vmware.vcim.ngc.service.cache.jaxbwrapper.OperatingSystemCatalogRecordTypeWrappper;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import org.springframework.http.ResponseEntity;

public class TemplateVpcHelperImpl
extends VpcHelper
implements TemplateVpcHelper {
    private JAXBContext osCatalogRecordTypeWrappperContext;
    private JAXBContext myImageRecordTypeWrapperContext;

    public TemplateVpcHelperImpl(VcimRestClient vcimRestClient, VcimSessionManager vcimSessionMgr) {
        super(vcimRestClient, vcimSessionMgr);
        try {
            this.osCatalogRecordTypeWrappperContext = JAXBContext.newInstance((Class[])new Class[]{OperatingSystemCatalogRecordTypeWrappper.class});
            this.myImageRecordTypeWrapperContext = JAXBContext.newInstance((Class[])new Class[]{MyImageRecordTypeWrapper.class});
        }
        catch (JAXBException jAXBException) {
            // empty catch block
        }
    }

    @Override
    public List<CloudObjectEntity> getOsCatalogs(String clientSessionId, CloudObjectEntity vdcObject) {
        boolean isShared = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isShared"));
        boolean isDr2c = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isDR2C"));
        String vdcId = vdcObject.getObjectProperties().get("vdcId");
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/spCatalogs";
        if (isShared) {
            url = isDr2c ? "/api/private/dr2c/<VDC_ID>/spCatalogs" : "/api/private/vpc/<VDC_ID>/spCatalogs";
        } else {
            String cloudId = vdcObject.getObjectProperties().get("cloudId");
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            url = url.replace("<VPC_ID>", cloudId);
        }
        url = url.replace("<VDC_ID>", vdcId);
        return this.getOsCatalogs(clientSessionId, url, vdcObject);
    }

    @Override
    public List<CloudObjectEntity> getMyImages(String clientSessionId, CloudObjectEntity vdcObject) {
        boolean isShared = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isShared"));
        boolean isDr2c = Boolean.parseBoolean(vdcObject.getObjectProperties().get("isDR2C"));
        String vdcId = vdcObject.getObjectProperties().get("vdcId");
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/myCatalogs";
        if (isShared) {
            url = isDr2c ? "/api/private/dr2c/<VDC_ID>/myCatalogs" : "/api/private/vpc/<VDC_ID>/myCatalogs";
        } else {
            String cloudId = vdcObject.getObjectProperties().get("cloudId");
            cloudId = cloudId.substring(cloudId.indexOf("~") + 1);
            url = url.replace("<VPC_ID>", cloudId);
        }
        url = url.replace("<VDC_ID>", vdcId);
        return this.getMyImages(clientSessionId, url, vdcObject);
    }

    private List<CloudObjectEntity> getOsCatalogs(String clientSessionId, String url, CloudObjectEntity vdcObject) {
        ResponseEntity osCatalogResponse = null;
        try {
            osCatalogResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, OperatingSystemCatalogRecordListType.class, null, clientSessionId);
        }
        catch (Exception ex) {
            // empty catch block
        }
        ArrayList<CloudObjectEntity> templates = new ArrayList<CloudObjectEntity>();
        if (null != osCatalogResponse) {
            OperatingSystemCatalogRecordListType osList = (OperatingSystemCatalogRecordListType)osCatalogResponse.getBody();
            for (OperatingSystemCatalogRecordType osCatalogRecord : osList.getOsCatalogRecords()) {
                OperatingSystemCatalogRecordTypeWrappper osCatalogRecordTypeWrappper = new OperatingSystemCatalogRecordTypeWrappper();
                osCatalogRecordTypeWrappper.setOperatingSystemCatalogRecordType(osCatalogRecord);
                String payload = this.marshal(this.osCatalogRecordTypeWrappperContext, osCatalogRecordTypeWrappper);
                String vdcId = vdcObject.getId();
                CloudObjectEntity templateObject = new CloudObjectEntity(VchsObjectType.TEMPLATE, vdcId + "~" + osCatalogRecord.getId(), payload);
                templateObject.setObjectProperties(vdcObject.getObjectProperties());
                templateObject.getObjectProperties().put("vdcId", vdcId);
                templates.add(templateObject);
            }
        }
        return templates;
    }

    private List<CloudObjectEntity> getMyImages(String clientSessionId, String url, CloudObjectEntity vdcObject) {
        ResponseEntity myImageResponse = null;
        try {
            myImageResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, MyImagesListType.class, null, clientSessionId);
        }
        catch (Exception ex) {
            // empty catch block
        }
        ArrayList<CloudObjectEntity> myImageObjects = new ArrayList<CloudObjectEntity>();
        if (null != myImageResponse) {
            MyImagesListType imageList = (MyImagesListType)myImageResponse.getBody();
            for (MyImageRecordType imageRecord : imageList.getMyImage()) {
                MyImageRecordTypeWrapper myImageRecordTypeWrapper = new MyImageRecordTypeWrapper();
                myImageRecordTypeWrapper.setMyImageRecordType(imageRecord);
                String payload = this.marshal(this.myImageRecordTypeWrapperContext, myImageRecordTypeWrapper);
                CloudObjectEntity templateObject = new CloudObjectEntity(VchsObjectType.TEMPLATE, imageRecord.getId(), payload);
                templateObject.setObjectProperties(vdcObject.getObjectProperties());
                templateObject.getObjectProperties().put("vdcId", vdcObject.getId());
                myImageObjects.add(templateObject);
            }
        }
        return myImageObjects;
    }
}

