/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.common;

import com.vmware.vcim.ngc.service.common.CacheUtil;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public class CacheUtilImpl
implements CacheUtil {
    private static CacheUtilImpl instance;
    private Map<String, List<?>> cache = new HashMap();

    private CacheUtilImpl() {
    }

    public static synchronized CacheUtilImpl getInstance() {
        if (null == instance) {
            instance = new CacheUtilImpl();
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void invalidateCacheEntry(String key) {
        String string = key.intern();
        synchronized (string) {
            if (this.cache.containsKey(key)) {
                this.cache.remove(key);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addEntry(String key, List<?> objects) {
        String string = key.intern();
        synchronized (string) {
            this.cache.put(key, objects);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public List<?> getEntry(String key, int from, int count) {
        List<?> records = this.cache.get(key);
        if (null != records && from < records.size()) {
            String string = key.intern();
            synchronized (string) {
                return records.subList(from, from + count < records.size() ? from + count : records.size());
            }
        }
        return null;
    }

    public void removeCache(String partialKey) {
        LinkedList<String> selectedKeys = new LinkedList<String>();
        for (String key : this.cache.keySet()) {
            if (!key.startsWith(partialKey)) continue;
            selectedKeys.add(key);
        }
        for (String key : selectedKeys) {
            this.invalidateCacheEntry(key);
        }
    }
}

