/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.common.crypt;

import com.vmware.vcim.ngc.service.common.crypt.Cryptor;
import com.vmware.vcim.ngc.service.common.crypt.EncryptionException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESCryptorImpl
implements Cryptor {
    private static final String ALGORITHM = "AES";
    private Key key;

    public AESCryptorImpl(String seedKey) {
        this.key = this.generateKey(seedKey);
    }

    @Override
    public String encrypt(String valueToEncrypt) throws EncryptionException {
        try {
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(1, this.key);
            byte[] encValue = c.doFinal(valueToEncrypt.getBytes());
            String encryptedValue = new String(Base64.encodeBase64((byte[])encValue));
            return encryptedValue;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Unable to encrypt value", e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException("Unable to encrypt value", e);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException("Unable to encrypt value", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to encrypt value", e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException("Unable to encrypt value", e);
        }
    }

    @Override
    public String decrypt(String encryptedValue) throws EncryptionException {
        try {
            Cipher c = Cipher.getInstance(ALGORITHM);
            c.init(2, this.key);
            byte[] decodedValue = Base64.decodeBase64((byte[])encryptedValue.getBytes());
            String decryptedValue = new String(c.doFinal(decodedValue));
            return decryptedValue;
        }
        catch (NoSuchAlgorithmException e) {
            throw new EncryptionException("Unable to decrypt value", e);
        }
        catch (NoSuchPaddingException e) {
            throw new EncryptionException("Unable to decrypt value", e);
        }
        catch (InvalidKeyException e) {
            throw new EncryptionException("Unable to decrypt value", e);
        }
        catch (IllegalBlockSizeException e) {
            throw new EncryptionException("Unable to decrypt value", e);
        }
        catch (BadPaddingException e) {
            throw new EncryptionException("Unable to decrypt value", e);
        }
    }

    public Key generateKey(String keyValue) {
        return new SecretKeySpec(Base64.decodeBase64((byte[])keyValue.getBytes()), ALGORITHM);
    }
}

