/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.ares.common.v1.EntityState;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.common.AccessController;
import com.vmware.vcim.ngc.service.contracts.GatewayService;
import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.model.VCimGateway;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.GatewayOperations;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.usersession.UserSessionService;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang.StringUtils;

@type(value="comvmwarevcimngc:Gateway")
public class GatewayDataService
extends VCimDataService
implements GatewayService {
    private AccessController accessController;
    private AdapterWrapper adapterWrapper;
    private static final String GATEWAY_DSN = "comvmwarevcimngc:Gateway";
    private static final String EDIT_GATEWAY = "EDIT_GATEWAY";
    private static final String DELETE_GATEWAY = "DELETE_GATEWAY";

    public GatewayDataService(ResourceTypeResolverRegistry resourceTypeResolverRegistry, UserSessionService userSessionService, AccessController accessController, AdapterWrapper adapterWrapper) {
        super(GATEWAY_DSN, resourceTypeResolverRegistry, userSessionService);
        this.accessController = accessController;
        this.adapterWrapper = adapterWrapper;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        List<?> gateways = null;
        if (GATEWAY_DSN.equals(constraint.targetType)) {
            String sessionId = this.getClientSessionId();
            String cacheKey = sessionId + "#" + GATEWAY_DSN + "#" + "ALL";
            boolean cacheHit = false;
            if (null != resultSpec) {
                if (0 == resultSpec.offset) {
                    this.cacheUtil.invalidateCacheEntry(sessionId);
                } else {
                    List<?> objects = this.cacheUtil.getEntry(cacheKey, resultSpec.offset, resultSpec.maxResultCount);
                    if (null != objects) {
                        cacheHit = true;
                        gateways = objects;
                    }
                }
            }
            if (!cacheHit) {
                String key = "GET_ALL_GATEWAYS#" + sessionId;
                gateways = (List)this.queryUtil.getResults(key, new Object[0]);
                this.cacheUtil.addEntry(cacheKey, gateways);
            }
            if (gateways != null) {
                for (VCimGateway gateway : gateways) {
                    ResultItem ri = this.getGatewayProperties(gateway, propertySpecs);
                    if (null == ri) continue;
                    items.add(ri);
                }
            }
        }
        return items;
    }

    @Override
    protected Object getObject(Object target) {
        return this.getGateway(target);
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return this.getGatewayProperties((VCimGateway)object, propertySpecs);
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        RelationalConstraint rc = (RelationalConstraint)constraint;
        assert (rc != null);
        assert (rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        ObjectIdentityConstraint oic = (ObjectIdentityConstraint)rc.constraintOnRelatedObject;
        if (rc.relation.equals("vdcToGateway") && GATEWAY_DSN.equals(rc.targetType)) {
            String vdcId;
            URI vdcUri = (URI)oic.target;
            String vpcId = VCimVirtualDatacenter.getVpcId(vdcUri);
            List<VCimGateway> gateways = this.getGatewaysForVDC(vpcId, vdcId = VCimVirtualDatacenter.getVdcId(vdcUri));
            if (gateways != null) {
                for (VCimGateway gateway : gateways) {
                    ResultItem ri = this.getGatewayProperties(gateway, propertySpecs);
                    if (ri == null) continue;
                    items.add(ri);
                }
            }
            return items;
        }
        return this.processSimpleConstraint((Constraint)rc, propertySpecs, null);
    }

    private ResultItem getGatewayProperties(VCimGateway gateway, PropertySpec[] propertySpecs) {
        ResultItem ri = new ResultItem();
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        ri.resourceObject = gateway.getUri();
        HashMap<String, Field> objFields = new HashMap<String, Field>();
        Field[] fields = gateway.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            objFields.put(fields[index].getName(), fields[index]);
        }
        for (PropertySpec ps : propertySpecs) {
            if (!GATEWAY_DSN.equals(ps.type)) continue;
            for (String prop : ps.propertyNames) {
                PropertyValue pv = new PropertyValue();
                Object propValue = this.UNSUPPORTED_PROPERTY_FLAG;
                if (prop.equals("id")) {
                    propValue = gateway.getId();
                } else if (prop.equals("name")) {
                    propValue = gateway.getName();
                } else if (prop.equals("description")) {
                    propValue = gateway.getDescription();
                } else if (prop.equals("href")) {
                    propValue = gateway.getHref();
                } else if (prop.equals("gatewayName")) {
                    propValue = gateway.getGatewayName();
                } else if (prop.equals("vdcName")) {
                    propValue = gateway.getVDCName();
                } else if (prop.equals("gatewayIp")) {
                    propValue = gateway.getGatewayIP();
                } else if (prop.equals("gatewayConfiguration")) {
                    propValue = gateway.getGatewayBackingConfig();
                } else if (prop.equals("gatewayAvailability")) {
                    propValue = gateway.isHaEnabled() ? "Enabled" : "Disabled";
                } else if (prop.equals("gatewayNetworks")) {
                    propValue = gateway.getNumberOfOrgNetworks();
                } else if (prop.equals("allocatedPublicIps")) {
                    propValue = gateway.getPublicIP().getAllocated();
                } else if (prop.equals("usedPublicIps")) {
                    propValue = gateway.getPublicIP().getUsed();
                } else if (prop.equals("freePublicIps")) {
                    propValue = gateway.getPublicIP().getFree();
                } else if (prop.equals("vpcId")) {
                    propValue = gateway.getVpcId();
                } else if (prop.equals("vdcId")) {
                    propValue = gateway.getVdcId();
                } else if (prop.equals("vcdUrl")) {
                    propValue = gateway.getGatewayVcdUri();
                } else if (prop.equals("privateGateway")) {
                    propValue = StringUtils.isEmpty((String)gateway.getVpcId()) ? Boolean.valueOf(false) : Boolean.valueOf(true);
                } else if (prop.equals("gatewayStatus")) {
                    propValue = gateway.getState().value();
                } else if (prop.equals("editGatewayAllowed")) {
                    propValue = gateway.getState() == EntityState.ACTIVE && this.accessController.operationAllowed(EDIT_GATEWAY);
                } else if (prop.equals("deleteGatewayAllowed")) {
                    propValue = gateway.getState() == EntityState.ACTIVE && !StringUtils.isEmpty((String)gateway.getVpcId()) && this.accessController.operationAllowed(DELETE_GATEWAY);
                }
                pv.value = propValue;
                if (pv.value == this.UNSUPPORTED_PROPERTY_FLAG) continue;
                pv.resourceObject = gateway.getUri();
                pv.propertyName = prop;
                pvs.add(pv);
            }
        }
        ri.properties = pvs.toArray(new PropertyValue[0]);
        return ri;
    }

    @Override
    public VCimGateway getGateway(Object gatewayUri) {
        VCimGateway gateway = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_GATEWAY#" + ((URI)gatewayUri).toString() + "#" + sessionId;
        gateway = (VCimGateway)this.queryUtil.getResults(key, gatewayUri);
        return gateway;
    }

    @Override
    public void addGateway(String vpcId, String vdcId, String gatewayName, String gatewayDesc, int gatewayIpCount) {
        this.getGatewayAdapter().addGateway(this.getClientSessionId(), vpcId, vdcId, gatewayName, gatewayDesc, gatewayIpCount);
    }

    @Override
    public List<VCimGateway> getGateways() {
        List gateways = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_ALL_GATEWAYS#" + sessionId;
        gateways = (List)this.queryUtil.getResults(key, new Object[0]);
        return gateways;
    }

    @Override
    public List<VCimGateway> getGatewaysForVDC(String vpcId, String vdcId) {
        List gateways = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_GATEWAYS_FOR_VDC#" + vpcId + "#" + vdcId + "#" + sessionId;
        gateways = (List)this.queryUtil.getResults(key, vpcId, vdcId);
        return gateways;
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        String sessionId = this.getClientSessionId();
        if (identifier.startsWith("GET_ALL_GATEWAYS#")) {
            return this.getGatewayReadOnlyAdapter().getGateways(sessionId);
        }
        if (identifier.startsWith("GET_GATEWAY#")) {
            if (arguments.length > 0) {
                return this.getGatewayReadOnlyAdapter().getGateway(sessionId, (URI)arguments[0]);
            }
        } else if (identifier.startsWith("GET_GATEWAYS_FOR_VDC#") && arguments.length > 1) {
            return this.getGatewayReadOnlyAdapter().getGatewaysForVDC(this.getClientSessionId(), (String)arguments[0], (String)arguments[1]);
        }
        return null;
    }

    @Override
    public void updateGateway(String href, String gatewayName, String gatewayDesc) {
        this.getGatewayAdapter().updateGateway(this.getClientSessionId(), href, gatewayName, gatewayDesc);
    }

    @Override
    public void deleteGateway(String href) {
        this.getGatewayAdapter().deleteGateway(this.getClientSessionId(), href);
    }

    private GatewayOperations getGatewayReadOnlyAdapter() {
        return (GatewayOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.GATEWAY));
    }

    private GatewayOperations getGatewayAdapter() {
        return (GatewayOperations)((Object)this.adapterWrapper.getWritableAdapter(VchsObjectType.GATEWAY));
    }
}

