/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.contracts.NetworkService;
import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.model.Network;
import com.vmware.vcim.ngc.service.model.VCimGateway;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.NetworkOperations;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.usersession.UserSessionService;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;

@type(value="comvmwarevcimngc:Network")
public class NetworkDataService
extends VCimDataService
implements NetworkService {
    private static final String NETWORK_DSN = "comvmwarevcimngc:Network";
    private AdapterWrapper adapterWrapper;

    public NetworkDataService(UserSessionService userSessionService, AdapterWrapper adapterWrapper) {
        super(NETWORK_DSN, null, userSessionService);
        this.adapterWrapper = adapterWrapper;
    }

    @Override
    public List<Network> getNetworks(String vpcId, String vdcId) {
        List networks = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_ALL_NETWORKS#" + sessionId;
        networks = (List)this.queryUtil.getResults(key, vpcId, vdcId);
        return networks;
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        String sessionId = this.getClientSessionId();
        if (identifier.startsWith("GET_ALL_NETWORKS#")) {
            if (arguments.length > 1) {
                return this.getNetworkReadOnlyAdapter().getNetworks(sessionId, (String)arguments[0], (String)arguments[1]);
            }
        } else if (identifier.startsWith("GET_ALL_DR2C_NETWORKS#")) {
            if (arguments.length > 1) {
                return this.getNetworkReadOnlyAdapter().getDR2CNetworks(sessionId, (String)arguments[0], (String)arguments[1]);
            }
        } else if (identifier.startsWith("GET_NETWORK#")) {
            if (arguments.length > 2) {
                return this.getNetworkReadOnlyAdapter().getNetwork(sessionId, (String)arguments[0], (String)arguments[1], (URI)arguments[2]);
            }
        } else if (identifier.startsWith("GET_DR2C_NETWORK#") && arguments.length > 2) {
            return this.getNetworkReadOnlyAdapter().getDR2CNetwork(sessionId, (String)arguments[0], (String)arguments[1], (URI)arguments[2]);
        }
        return null;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        List<?> networks = null;
        if (NETWORK_DSN.equals(constraint.targetType)) {
            String sessionId = this.getClientSessionId();
            String cacheKey = sessionId + "#" + NETWORK_DSN + "#" + "ALL";
            boolean cacheHit = false;
            if (null != resultSpec) {
                if (0 == resultSpec.offset) {
                    this.cacheUtil.invalidateCacheEntry(sessionId);
                } else {
                    List<?> objects = this.cacheUtil.getEntry(cacheKey, resultSpec.offset, resultSpec.maxResultCount);
                    if (null != objects) {
                        cacheHit = true;
                        networks = objects;
                    }
                }
            }
            if (!cacheHit) {
                String key = "GET_ALL_NETWORKS#" + sessionId;
                networks = (List)this.queryUtil.getResults(key, new Object[0]);
                this.cacheUtil.addEntry(cacheKey, networks);
            }
            if (networks != null) {
                for (Network network : networks) {
                    ResultItem ri = this.getNetworkProperties(network, propertySpecs);
                    if (null == ri) continue;
                    items.add(ri);
                }
            }
        }
        return items;
    }

    @Override
    protected Object getObject(Object target) {
        URI test = (URI)target;
        if (test.toString().contains("dr2c")) {
            return this.getDR2CNetwork((URI)target);
        }
        return this.getNetwork((URI)target);
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return this.getNetworkProperties((Network)object, propertySpecs);
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        RelationalConstraint rc = (RelationalConstraint)constraint;
        assert (rc != null);
        assert (rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        ObjectIdentityConstraint oic = (ObjectIdentityConstraint)rc.constraintOnRelatedObject;
        if (rc.relation.equals("gatewayToNetwork")) {
            URI gatewayUri = (URI)oic.target;
            String vpcId = VCimGateway.getVpcId(gatewayUri);
            String vdcId = VCimGateway.getVdcId(gatewayUri);
            String gatewayId = VCimGateway.getGatewayId(gatewayUri);
            List<Network> networks = null;
            networks = gatewayUri.toString().contains("dr2c") ? this.getNetworkReadOnlyAdapter().getDR2CNetworksForGateway(this.getClientSessionId(), vpcId, vdcId, gatewayId) : this.getNetworkReadOnlyAdapter().getNetworksForGateway(this.getClientSessionId(), vpcId, vdcId, gatewayId);
            if (networks != null) {
                for (Network network : networks) {
                    ResultItem ri = this.getNetworkProperties(network, propertySpecs);
                    items.add(ri);
                }
            }
            return items;
        }
        return this.processSimpleConstraint((Constraint)rc, propertySpecs, null);
    }

    private ResultItem getNetworkProperties(Network network, PropertySpec[] propertySpecs) {
        ResultItem ri = new ResultItem();
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        ri.resourceObject = network.getUri();
        HashMap<String, Field> objFields = new HashMap<String, Field>();
        Field[] fields = network.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            objFields.put(fields[index].getName(), fields[index]);
        }
        for (PropertySpec ps : propertySpecs) {
            if (!NETWORK_DSN.equals(ps.type)) continue;
            for (String prop : ps.propertyNames) {
                PropertyValue pv = new PropertyValue();
                Object propValue = this.UNSUPPORTED_PROPERTY_FLAG;
                if (prop.equals("id")) {
                    propValue = network.getId();
                } else if (prop.equals("name")) {
                    propValue = network.getName();
                } else if (prop.equals("gatewayName")) {
                    propValue = network.getEdgeGatewayName();
                } else if (prop.equals("gatewayAddress")) {
                    propValue = network.getEdgeGatewayAddress();
                } else if (prop.equals("allocatedPublicIps")) {
                    propValue = network.getAllocatedPublicIps();
                } else if (prop.equals("usedPublicIps")) {
                    propValue = network.getUsedPublicIps();
                } else if (prop.equals("isDefault")) {
                    propValue = network.isDefault();
                } else if (prop.equals("type")) {
                    propValue = network.getType();
                } else if (prop.equals("gatewayId")) {
                    propValue = network.getGatewayId();
                } else if (prop.equals("ipPool")) {
                    propValue = network.getIpPool();
                } else if (prop.equals("allocatedVMs")) {
                    propValue = network.getAllocatedVMs();
                } else if (prop.equals("poweredOnVMs")) {
                    propValue = network.getPoweredOnVMs();
                } else if (prop.equals("ipRange")) {
                    propValue = network.getIpRange();
                } else if (prop.equals("defaultGatewayIp")) {
                    propValue = network.getDefaultGatewayIp();
                }
                pv.value = propValue;
                if (pv.value == this.UNSUPPORTED_PROPERTY_FLAG) continue;
                pv.resourceObject = network.getUri();
                pv.propertyName = prop;
                pvs.add(pv);
            }
        }
        ri.properties = pvs.toArray(new PropertyValue[0]);
        return ri;
    }

    public Network getNetwork(URI networkUri) {
        Network network = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_NETWORK#" + networkUri.toString() + "#" + sessionId;
        String vpcId = Network.getVpcId(networkUri);
        String vdcId = Network.getVdcId(networkUri);
        network = (Network)this.queryUtil.getResults(key, vpcId, vdcId, networkUri);
        return network;
    }

    public Network getDR2CNetwork(URI networkUri) {
        Network network = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_DR2C_NETWORK#" + networkUri.toString() + "#" + sessionId;
        String vpcId = Network.getVpcId(networkUri);
        String vdcId = Network.getVdcId(networkUri);
        network = (Network)this.queryUtil.getResults(key, vpcId, vdcId, networkUri);
        return network;
    }

    private NetworkOperations getNetworkReadOnlyAdapter() {
        return (NetworkOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.NETWORK));
    }

    @Override
    public List<Network> getDR2CNetworks(String vpcId, String vdcId) {
        List networks = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_ALL_DR2C_NETWORKS#" + sessionId;
        networks = (List)this.queryUtil.getResults(key, vpcId, vdcId);
        return networks;
    }
}

