/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.contracts.RegionService;
import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.model.VCimRegion;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.RegionOperations;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.usersession.UserSessionService;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;

@type(value="comvmwarevcimngc:Region")
public class RegionDataService
extends VCimDataService
implements RegionService {
    private static final String REGION_DSN = "comvmwarevcimngc:Region";
    private AdapterWrapper adapterWrapper;

    public RegionDataService(UserSessionService userSessionService, AdapterWrapper adapterWrapper) {
        super(REGION_DSN, null, userSessionService);
        this.adapterWrapper = adapterWrapper;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        List regions = null;
        if (REGION_DSN.equals(constraint.targetType)) {
            String sessionId = this.getClientSessionId();
            String key = "GET_ALL_REGIONS#" + sessionId;
            regions = (List)this.queryUtil.getResults(key, new Object[0]);
        }
        for (VCimRegion region : regions) {
            ResultItem ri = this.getRegionProperties(region, propertySpecs);
            if (null == ri) continue;
            items.add(ri);
        }
        return items;
    }

    @Override
    protected Object getObject(Object target) {
        String sessionId = this.getClientSessionId();
        String key = "GET_REGION#" + ((URI)target).toString() + "#" + sessionId;
        return this.queryUtil.getResults(key, target);
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return this.getRegionProperties((VCimRegion)object, propertySpecs);
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        RelationalConstraint rc = (RelationalConstraint)constraint;
        assert (rc != null);
        assert (rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        ArrayList<ResultItem> returnItems = new ArrayList<ResultItem>();
        return returnItems;
    }

    private ResultItem getRegionProperties(VCimRegion region, PropertySpec[] propertySpecs) {
        ResultItem ri = new ResultItem();
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        ri.resourceObject = region.getUri();
        for (PropertySpec ps : propertySpecs) {
            if (!REGION_DSN.equals(ps.type)) continue;
            for (String prop : ps.propertyNames) {
                PropertyValue pv = new PropertyValue();
                Object propValue = this.UNSUPPORTED_PROPERTY_FLAG;
                if (prop.equals("name")) {
                    propValue = region.getName();
                }
                pv.value = propValue;
                if (pv.value == this.UNSUPPORTED_PROPERTY_FLAG) continue;
                pv.resourceObject = region.getUri();
                pv.propertyName = prop;
                pvs.add(pv);
            }
        }
        ri.properties = pvs.toArray(new PropertyValue[0]);
        return ri;
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        String sessionId = this.getClientSessionId();
        if (identifier.startsWith("GET_ALL_REGIONS#")) {
            return this.getRegionReadOnlyAdapter().getRegions(sessionId);
        }
        if (identifier.startsWith("GET_REGION#") && arguments.length > 0) {
            return this.getRegionReadOnlyAdapter().getRegion(sessionId, (URI)arguments[0]);
        }
        return null;
    }

    private RegionOperations getRegionReadOnlyAdapter() {
        return (RegionOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.REGION));
    }
}

