/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.ares.auth.v1.SessionType;
import com.vmware.ares.company.v1.RegionListType;
import com.vmware.ares.company.v1.RegionType;
import com.vmware.vcim.ngc.service.impl.VCimAuthenticator;
import com.vmware.vcim.ngc.service.model.VCimRegion;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import org.springframework.web.client.RestTemplate;

public class VCimSession {
    private String username;
    private String password;
    private String aresAuthToken;
    private RestTemplate restTemplate;
    private Date lastActivityTimeStamp;
    private String vpcUrl;
    private String proxyUrl;
    private String proxyPort;
    private String proxyUsername;
    private String proxyPassword;
    private boolean useProxy;
    private SessionType vchsSession;
    private VCimAuthenticator authenticator;
    private String clientSessionId;
    private Timer timer;
    private RenewSessionTask task;
    private static final long DELAY = 840000L;

    public VCimSession(VCimAuthenticator authenticator, String clientSessionId) {
        this.authenticator = authenticator;
        this.clientSessionId = clientSessionId;
        this.timer = new Timer();
    }

    public String getAresAuthToken() {
        return this.aresAuthToken;
    }

    public void setAresAuthToken(String aresAuthToken) {
        this.aresAuthToken = aresAuthToken;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public RestTemplate getRestTemplate() {
        return this.restTemplate;
    }

    public void setRestTemplate(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public Date getLastActivityTimeStamp() {
        return this.lastActivityTimeStamp;
    }

    public void setLastActivityTimeStamp(Date timeStamp) {
        this.lastActivityTimeStamp = timeStamp;
    }

    public String getVpcUrl() {
        return this.vpcUrl;
    }

    public void setVpcUrl(String vpcUrl) {
        this.vpcUrl = vpcUrl;
    }

    public String getProxyUrl() {
        return this.proxyUrl;
    }

    public void setProxyUrl(String proxyUrl) {
        this.proxyUrl = proxyUrl;
    }

    public String getProxyPort() {
        return this.proxyPort;
    }

    public void setProxyPort(String proxyPort) {
        this.proxyPort = proxyPort;
    }

    public String getProxyUsername() {
        return this.proxyUsername;
    }

    public void setProxyUsername(String proxyUsername) {
        this.proxyUsername = proxyUsername;
    }

    public String getProxyPassword() {
        return this.proxyPassword;
    }

    public void setProxyPassword(String proxyPassword) {
        this.proxyPassword = proxyPassword;
    }

    public boolean isUseProxy() {
        return this.useProxy;
    }

    public void setUseProxy(boolean useProxy) {
        this.useProxy = useProxy;
    }

    public List<VCimRegion> getRegions() {
        RegionListType regionList = this.vchsSession.getUser().getRegions();
        if (regionList != null && regionList.getRegion() != null && regionList.getRegion().size() > 0) {
            ArrayList<VCimRegion> regions = new ArrayList<VCimRegion>(regionList.getRegion().size());
            for (RegionType region : regionList.getRegion()) {
                VCimRegion vcimRegion = new VCimRegion();
                vcimRegion.setId(region.getId());
                vcimRegion.setName(region.getName());
                vcimRegion.setDefault(false);
                regions.add(vcimRegion);
            }
            return regions;
        }
        return null;
    }

    public void setVchsSession(SessionType vchsSession) {
        this.vchsSession = vchsSession;
    }

    public SessionType getVchsSession() {
        return this.vchsSession;
    }

    public String getClientSessionId() {
        return this.clientSessionId;
    }

    public void setClientSessionId(String clientSessionId) {
        this.clientSessionId = clientSessionId;
    }

    public void enableSessionRenew() {
        if (this.task != null) {
            this.task.cancel();
        }
        if (this.timer != null) {
            this.timer.purge();
        }
        this.task = new RenewSessionTask();
        this.timer.schedule((TimerTask)this.task, 840000L);
    }

    public void cleanup() {
        this.timer.cancel();
        this.timer.purge();
        this.timer = null;
    }

    private class RenewSessionTask
    extends TimerTask {
        private RenewSessionTask() {
        }

        @Override
        public void run() {
            VCimSession.this.authenticator.renewSession(VCimSession.this.clientSessionId);
        }
    }
}

