/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.common.AccessController;
import com.vmware.vcim.ngc.service.contracts.VirtualMachineService;
import com.vmware.vcim.ngc.service.impl.VCimDataService;
import com.vmware.vcim.ngc.service.impl.VCimUriResolver;
import com.vmware.vcim.ngc.service.model.ResourceSummary;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachine;
import com.vmware.vcim.ngc.service.model.VCimVpc;
import com.vmware.vcim.ngc.service.model.VMNetwork;
import com.vmware.vcim.ngc.service.model.VMSummary;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualMachineOperations;
import com.vmware.vise.data.Constraint;
import com.vmware.vise.data.PropertySpec;
import com.vmware.vise.data.query.ObjectIdentityConstraint;
import com.vmware.vise.data.query.PropertyValue;
import com.vmware.vise.data.query.RelationalConstraint;
import com.vmware.vise.data.query.ResultItem;
import com.vmware.vise.data.query.ResultSpec;
import com.vmware.vise.data.query.type;
import com.vmware.vise.data.uri.ResourceTypeResolver;
import com.vmware.vise.data.uri.ResourceTypeResolverRegistry;
import com.vmware.vise.usersession.UserSessionService;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@type(value="comvmwarevcimngc:VirtualMachine,comvmwarevcimngc:Datacenter,comvmwarevcimngc:VirtualMachineReplicationStatus")
public class VCimVirtualMachineDataService
extends VCimDataService
implements VirtualMachineService {
    private static final VCimUriResolver URI_RESOLVER = new VCimUriResolver();
    private static final String VIRTUALMACHINE_DSN = "comvmwarevcimngc:VirtualMachine";
    private final AccessController accessController;
    private final AdapterWrapper adapterWrapper;
    private final Logger logger = LoggerFactory.getLogger(VCimVirtualMachineDataService.class);

    public VCimVirtualMachineDataService(ResourceTypeResolverRegistry resourceTypeResolverRegistry, UserSessionService userSessionService, AccessController accessController, AdapterWrapper adapterWrapper) {
        super(VIRTUALMACHINE_DSN, resourceTypeResolverRegistry, userSessionService);
        this.resourceTypeResolverRegistry.registerSchemeResolver("vcim", (ResourceTypeResolver)URI_RESOLVER);
        this.accessController = accessController;
        this.adapterWrapper = adapterWrapper;
    }

    @Override
    protected List<ResultItem> processSimpleConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        List<VCimVirtualMachine> virtualMachines = null;
        if (VIRTUALMACHINE_DSN.equals(constraint.targetType)) {
            String sessionId = this.getClientSessionId();
            String cacheKey = sessionId + "#" + VIRTUALMACHINE_DSN + "#" + "ALL";
            boolean cacheHit = false;
            if (null != resultSpec) {
                if (0 == resultSpec.offset) {
                    this.cacheUtil.invalidateCacheEntry(sessionId);
                } else {
                    List<?> objects = this.cacheUtil.getEntry(cacheKey, resultSpec.offset, resultSpec.maxResultCount);
                    if (null != objects) {
                        cacheHit = true;
                        virtualMachines = objects;
                    }
                }
            }
            if (!cacheHit) {
                virtualMachines = this.getAllVMs(sessionId);
                this.cacheUtil.addEntry(cacheKey, virtualMachines);
            }
            if (virtualMachines != null) {
                for (VCimVirtualMachine virtualMachine : virtualMachines) {
                    ResultItem ri = this.getVirtualMachineProperties(virtualMachine, propertySpecs);
                    if (null == ri) continue;
                    items.add(ri);
                }
            }
        }
        return items;
    }

    private List<VCimVirtualMachine> getAllVMs(String sessionId) {
        List virtualMachines = null;
        String key = "GET_ALL_VMS#" + sessionId;
        virtualMachines = (List)this.queryUtil.getResults(key, new Object[0]);
        return virtualMachines;
    }

    private List<VCimVirtualMachine> getVMsForVdc(String sessionId, String vdcId) {
        List virtualMachines = null;
        String key = "GET_VMS_FOR_VDC_BY_ID#" + vdcId + "#" + sessionId;
        virtualMachines = (List)this.queryUtil.getResults(key, vdcId);
        return virtualMachines;
    }

    private List<VCimVirtualMachine> getVMsForVdc(String sessionId, VCimVirtualDatacenter vdc) {
        List virtualMachines = null;
        String key = "GET_VMS_FOR_VDC#" + vdc.getId() + "#" + sessionId;
        virtualMachines = (List)this.queryUtil.getResults(key, vdc);
        return virtualMachines;
    }

    @Override
    protected Object getObject(Object target) {
        return this.getVirtualMachine(target);
    }

    @Override
    protected ResultItem getObjectProperties(Object object, PropertySpec[] propertySpecs) {
        return this.getVirtualMachineProperties((VCimVirtualMachine)object, propertySpecs);
    }

    @Override
    protected List<ResultItem> processRelationalConstraint(Constraint constraint, PropertySpec[] propertySpecs, ResultSpec resultSpec) {
        ArrayList<ResultItem> items = new ArrayList<ResultItem>();
        RelationalConstraint rc = (RelationalConstraint)constraint;
        assert (rc != null);
        assert (rc.constraintOnRelatedObject instanceof ObjectIdentityConstraint);
        ObjectIdentityConstraint oic = (ObjectIdentityConstraint)rc.constraintOnRelatedObject;
        if (rc.relation.equals("vdcToVm")) {
            URI vdcUri = (URI)oic.target;
            String vdcId = VCimVirtualDatacenter.getVdcId(vdcUri);
            List<VCimVirtualMachine> virtualMachines = this.getVMsForVdc(this.getClientSessionId(), vdcId);
            if (virtualMachines != null) {
                for (VCimVirtualMachine virtualMachine : virtualMachines) {
                    ResultItem ri = this.getVirtualMachineProperties(virtualMachine, propertySpecs);
                    if (null == ri) continue;
                    items.add(ri);
                }
            }
            return items;
        }
        if (rc.relation.equals("cloudInstanceToVm") && VIRTUALMACHINE_DSN.equals(rc.targetType)) {
            URI vpcUri = (URI)oic.target;
            String vpcId = VCimVpc.getVpcId(vpcUri);
            List<VCimVirtualDatacenter> vDCs = this.getVdcReadOnlyAdapter().getVDCsForVpc(this.getClientSessionId(), vpcId);
            for (VCimVirtualDatacenter vdc : vDCs) {
                List<VCimVirtualMachine> virtualMachines = this.getVMsForVdc(this.getClientSessionId(), vdc);
                if (virtualMachines == null) continue;
                for (VCimVirtualMachine virtualMachine : virtualMachines) {
                    ResultItem ri = this.getVirtualMachineProperties(virtualMachine, propertySpecs);
                    if (null == ri) continue;
                    items.add(ri);
                }
            }
            return items;
        }
        return this.processSimpleConstraint((Constraint)rc, propertySpecs, null);
    }

    private boolean isNotStandardTestRecoveredDR2CVM(VCimVirtualMachine virtualMachine) {
        return virtualMachine.isDR2cVm() && !virtualMachine.getRecoveryStatus().equalsIgnoreCase("Standard") && !virtualMachine.getRecoveryStatus().equalsIgnoreCase("Test Ready") && !virtualMachine.getRecoveryStatus().equalsIgnoreCase("Recovered");
    }

    private ResultItem getVirtualMachineProperties(VCimVirtualMachine virtualMachine, PropertySpec[] propertySpecs) {
        ResultItem ri = new ResultItem();
        ArrayList<PropertyValue> pvs = new ArrayList<PropertyValue>();
        ri.resourceObject = virtualMachine.getUri();
        HashMap<String, Field> objFields = new HashMap<String, Field>();
        Field[] fields = virtualMachine.getClass().getDeclaredFields();
        for (int index = 0; index < fields.length; ++index) {
            objFields.put(fields[index].getName(), fields[index]);
        }
        for (PropertySpec ps : propertySpecs) {
            if (!VIRTUALMACHINE_DSN.equals(ps.type)) continue;
            for (String prop : ps.propertyNames) {
                PropertyValue pv = new PropertyValue();
                Object propValue = this.UNSUPPORTED_PROPERTY_FLAG;
                this.logger.debug("prop name:" + prop);
                if (prop.equals("id")) {
                    propValue = virtualMachine.getId();
                } else if (prop.equals("name")) {
                    propValue = virtualMachine.getVMName();
                } else if (prop.equals("vmName")) {
                    propValue = virtualMachine.getVMName();
                } else if (prop.equals("vmState")) {
                    propValue = virtualMachine.getVMState();
                } else if (prop.equals("canVmPowerOn")) {
                    propValue = virtualMachine.getVDC().isEnabled() && !virtualMachine.isVmPoweredOn() && this.accessController.operationAllowed("POWER_ON_OFF");
                    if (this.isNotStandardTestRecoveredDR2CVM(virtualMachine)) {
                        propValue = Boolean.FALSE;
                    }
                } else if (prop.equals("canVmPowerOff")) {
                    propValue = virtualMachine.getVDC().isEnabled() && (virtualMachine.isVmPoweredOn() || virtualMachine.isVmSuspended()) && this.accessController.operationAllowed("POWER_ON_OFF");
                    if (this.isNotStandardTestRecoveredDR2CVM(virtualMachine)) {
                        propValue = Boolean.FALSE;
                    }
                } else if (prop.equals("canVmSuspend")) {
                    propValue = virtualMachine.getVDC().isEnabled() && virtualMachine.isVmPoweredOn() && this.accessController.operationAllowed("POWER_ON_OFF");
                    if (this.isNotStandardTestRecoveredDR2CVM(virtualMachine)) {
                        propValue = Boolean.FALSE;
                    }
                } else if (prop.equals("canVmReset")) {
                    propValue = virtualMachine.isVmPoweredOn() && this.accessController.operationAllowed("POWER_ON_OFF");
                    if (this.isNotStandardTestRecoveredDR2CVM(virtualMachine)) {
                        propValue = Boolean.FALSE;
                    }
                } else if (prop.equals("canVmDelete")) {
                    propValue = !virtualMachine.isVmPoweredOn() && this.accessController.operationAllowed("POWER_ON_OFF");
                    if (this.isNotStandardTestRecoveredDR2CVM(virtualMachine)) {
                        propValue = Boolean.FALSE;
                    }
                    if (virtualMachine.isDR2cVm() && virtualMachine.getRecoveryStatus().equalsIgnoreCase("Test Ready")) {
                        propValue = new Boolean(virtualMachine.dr2cTestDeleteVM());
                    }
                } else if (prop.equals("snapshotExists")) {
                    propValue = virtualMachine.isSnapshotStateBoolean();
                    if (this.isNotStandardTestRecoveredDR2CVM(virtualMachine)) {
                        propValue = Boolean.FALSE;
                    }
                } else if (prop.equals("NotADR2CVMAndSnapshotDoesNotExist")) {
                    propValue = Boolean.TRUE;
                    if (virtualMachine.isDR2cVm()) {
                        propValue = virtualMachine.getRecoveryStatus().equalsIgnoreCase("Standard") || virtualMachine.getRecoveryStatus().equalsIgnoreCase("Test Ready") || virtualMachine.getRecoveryStatus().equalsIgnoreCase("Recovered") ? Boolean.TRUE : Boolean.FALSE;
                    }
                } else if (prop.equals("vcpu")) {
                    propValue = virtualMachine.getVCPU();
                } else if (prop.equals("operatingSystem")) {
                    propValue = virtualMachine.getOperatingSystem();
                } else if (prop.equals("vAppName")) {
                    propValue = virtualMachine.getVAppDetails().getVAPPName();
                } else if (prop.equals("vdcName")) {
                    propValue = virtualMachine.getVDCName();
                } else if (prop.equals("cpuUsed")) {
                    propValue = virtualMachine.getAllocatedCPU();
                } else if (prop.equals("memoryUsed")) {
                    propValue = virtualMachine.getAllocatedMemory();
                } else if (prop.equals("storageUsed")) {
                    propValue = virtualMachine.getAllocatedStorage();
                } else if (prop.equals("guestOSCustomization")) {
                    propValue = virtualMachine.getGuestOSCustomization();
                } else if (prop.equals("guestOsPassword")) {
                    propValue = virtualMachine.getGuestOSPassword();
                } else if (prop.equals("vmwareTools")) {
                    propValue = virtualMachine.getVmwareTools();
                } else if (prop.equals("vdcLocked")) {
                    propValue = !virtualMachine.getVDC().isEnabled();
                } else if (prop.equals("recoveryStatus")) {
                    propValue = virtualMachine.getRecoveryStatus();
                } else if (prop.equals("runningTime")) {
                    propValue = virtualMachine.getRunningTime();
                } else if (prop.equals("testdr2cvmBoolean")) {
                    propValue = virtualMachine.testdr2cvmBoolean();
                } else if (prop.equals("cleandr2cvmBoolean")) {
                    propValue = virtualMachine.cleandr2cvmBoolean();
                } else if (prop.equals("recoverdr2vmBoolean")) {
                    propValue = virtualMachine.recoverdr2vmBoolean();
                } else if (prop.equals("removeReplicationAllowed")) {
                    propValue = virtualMachine.removeRepliationAllowed();
                } else if (prop.equals("snapshotExistsBoolean")) {
                    propValue = virtualMachine.isSnapshotStateBoolean();
                    if (this.isNotStandardTestRecoveredDR2CVM(virtualMachine)) {
                        propValue = Boolean.FALSE;
                    }
                }
                pv.value = propValue;
                if (pv.value == this.UNSUPPORTED_PROPERTY_FLAG) continue;
                pv.resourceObject = virtualMachine.getUri();
                pv.propertyName = prop;
                pvs.add(pv);
            }
        }
        ri.properties = pvs.toArray(new PropertyValue[0]);
        return ri;
    }

    @Override
    public Object powerOn(Object vm) {
        this.getVmAdapter().powerOnVirtualMachine(this.getClientSessionId(), (URI)vm);
        return (URI)vm;
    }

    @Override
    public Object powerOff(Object vm) {
        this.getVmAdapter().powerOffVirtualMachine(this.getClientSessionId(), (URI)vm);
        return (URI)vm;
    }

    @Override
    public Object getScreenTicket(Object vmUri) {
        return this.getVmAdapter().getScreenTicket(this.getClientSessionId(), (URI)vmUri);
    }

    @Override
    public Object suspend(Object vmUri) {
        this.getVmAdapter().suspendVirtualMachine(this.getClientSessionId(), (URI)vmUri);
        return (URI)vmUri;
    }

    @Override
    public ResourceSummary getResourceSummary() {
        return null;
    }

    @Override
    public Object delete(Object vmUri) {
        this.getVmAdapter().deleteVirtualMachine(this.getClientSessionId(), (URI)vmUri);
        return (URI)vmUri;
    }

    @Override
    public Object reset(Object vmUri) {
        this.getVmAdapter().resetVirtualMachine(this.getClientSessionId(), (URI)vmUri);
        return (URI)vmUri;
    }

    @Override
    public VMSummary getVMData(Object vmUri) {
        return this.getVmReadOnlyAdapter().getVMData(this.getClientSessionId(), (URI)vmUri);
    }

    @Override
    public void editVMSettings(Object vmUri, VMSummary vmSummary) {
        this.getVmAdapter().editVMSettings(this.getClientSessionId(), (URI)vmUri, vmSummary);
    }

    @Override
    public VCimVirtualMachine getVirtualMachine(Object vmUri) {
        VCimVirtualMachine virtualMachine = null;
        String sessionId = this.getClientSessionId();
        String key = "GET_VM#" + ((URI)vmUri).toString() + "#" + sessionId;
        virtualMachine = (VCimVirtualMachine)this.queryUtil.getResults(key, vmUri);
        return virtualMachine;
    }

    @Override
    public void updateVMNetworks(Object vmUri, String vAppId, List<VMNetwork> networks) {
        this.getVmAdapter().updateVMNetworks(this.getClientSessionId(), (URI)vmUri, vAppId, networks);
    }

    @Override
    public void createSnapshot(URI vmUri) {
        this.getVmAdapter().createSnapshot(this.getClientSessionId(), vmUri);
    }

    @Override
    public void revertSnapshot(URI vmUri) {
        this.getVmAdapter().revertSnapshot(this.getClientSessionId(), vmUri);
    }

    @Override
    public void deleteSnapshot(URI vmUri) {
        this.getVmAdapter().deleteSnapshot(this.getClientSessionId(), vmUri);
    }

    @Override
    public boolean isSnapshotAvailable(URI vmUri) {
        return this.getVmAdapter().isSnapshotAvailable(this.getClientSessionId(), vmUri);
    }

    @Override
    public void enrollVmForDps(Object vmUri, boolean backup) {
        this.getVmAdapter().enrollVmForDps(this.getClientSessionId(), (URI)vmUri, backup);
    }

    @Override
    public Object execute(String identifier, Object ... arguments) {
        String sessionId = this.getClientSessionId();
        if (identifier.startsWith("GET_ALL_VMS#")) {
            return this.getVmReadOnlyAdapter().getVirtualMachines(sessionId);
        }
        if (identifier.startsWith("GET_VM#")) {
            if (arguments.length > 0) {
                return this.getVmReadOnlyAdapter().getVirtualMachine(sessionId, (URI)arguments[0]);
            }
        } else if (identifier.startsWith("GET_VMS_FOR_VDC_BY_ID#")) {
            if (arguments.length > 0) {
                return this.getVmReadOnlyAdapter().getVirtualMachinesForVdc(sessionId, (String)arguments[0]);
            }
        } else if (identifier.startsWith("GET_VMS_FOR_VDC#") && arguments.length > 0) {
            return this.getVmReadOnlyAdapter().getVirtualMachinesForVdc(sessionId, (VCimVirtualDatacenter)arguments[0]);
        }
        return null;
    }

    @Override
    public void unregisterScheme() {
        this.resourceTypeResolverRegistry.unregisterSchemeResolver("vcim");
    }

    @Override
    public List<VCimVirtualMachine> getVirtualMachinesForVdc(String vdcId) {
        return this.getVmReadOnlyAdapter().getVirtualMachinesForVdc(this.getClientSessionId(), vdcId);
    }

    private VirtualDatacenterOperations getVdcReadOnlyAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER));
    }

    private VirtualMachineOperations getVmReadOnlyAdapter() {
        return (VirtualMachineOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.VIRTUAL_MACHINE));
    }

    private VirtualMachineOperations getVmAdapter() {
        return (VirtualMachineOperations)((Object)this.adapterWrapper.getWritableAdapter(VchsObjectType.VIRTUAL_MACHINE));
    }

    @Override
    public Object test(Object vm) {
        this.getVmAdapter().test(this.getClientSessionId(), (URI)vm);
        return vm;
    }

    @Override
    public Object cleanup(Object vm) {
        this.getVmAdapter().cleanup(this.getClientSessionId(), (URI)vm);
        return vm;
    }

    @Override
    public Object failover(Object vm) {
        this.getVmAdapter().failover(this.getClientSessionId(), (URI)vm);
        return vm;
    }

    @Override
    public Object removereplication(Object vm) {
        this.getVmAdapter().removereplication(this.getClientSessionId(), (URI)vm);
        return vm;
    }
}

