/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.impl;

import com.vmware.vcim.ngc.service.impl.VCimAuthenticator;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import java.util.HashMap;
import java.util.Map;

public class VcimSessionManager {
    private Map<String, VCimSession> sessionMap = new HashMap<String, VCimSession>();

    public VCimSession getSession(String clientSessionId) {
        VCimSession vCimSession = this.sessionMap.get(clientSessionId);
        return vCimSession;
    }

    public VCimSession createSession(VCimAuthenticator authenticator, String clientSessionId) {
        VCimSession vCimSession = this.sessionMap.get(clientSessionId);
        if (null == vCimSession) {
            vCimSession = new VCimSession(authenticator, clientSessionId);
            this.sessionMap.put(clientSessionId, vCimSession);
        }
        return vCimSession;
    }

    public void removeSession(String clientSessionId) {
        this.sessionMap.remove(clientSessionId);
    }

    public boolean isSessionAvailable(String clientSessionId) {
        return this.sessionMap.containsKey(clientSessionId);
    }

    public VCimSession getSessionForUser(String username) {
        VCimSession vCimSession = null;
        for (String key : this.sessionMap.keySet()) {
            VCimSession session = this.sessionMap.get(key);
            if (null == session || !username.equalsIgnoreCase(session.getVchsSession().getUser().getUserName())) continue;
            return session;
        }
        return vCimSession;
    }

    public String getClientSessionId(String username) {
        for (String key : this.sessionMap.keySet()) {
            VCimSession session = this.sessionMap.get(key);
            if (null == session || !username.equalsIgnoreCase(session.getVchsSession().getUser().getUserName())) continue;
            return key;
        }
        return null;
    }

    public Map<String, VCimSession> getActiveSessionsForUniqueUsers() {
        HashMap<String, VCimSession> sessions = new HashMap<String, VCimSession>();
        for (VCimSession session : this.sessionMap.values()) {
            String username = session.getUsername().toLowerCase();
            if (sessions.containsKey(username)) continue;
            sessions.put(username, session);
        }
        return sessions;
    }
}

