/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.security;

import com.vmware.vcim.ngc.service.security.exceptions.TrustStoreException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClientConnectionConfiguration {
    private static final Logger logger = LoggerFactory.getLogger(ClientConnectionConfiguration.class);
    private char[] keyStorePass;
    private String keyStorePath;
    private String keyStoreType;
    private String[] supportedSSLProtocols;
    private String[] supportedSSLCipherSuites;
    private KeyStore keystore;
    private String SSLContextAlgorithm;
    private String endpointIdentificationAlgorithm;
    private static final String[] PSP_CIPHER_SUITES = new String[]{"TLS_ECDHE_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDHE_RSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_ECDSA_WITH_AES_256_CBC_SHA", "TLS_ECDH_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_DSS_WITH_AES_256_CBC_SHA", "TLS_RSA_WITH_AES_256_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA", "TLS_DHE_RSA_WITH_AES_128_CBC_SHA", "TLS_DHE_DSS_WITH_AES_128_CBC_SHA"};
    private static final String[] PSP_SSL_PROTOCOLS = new String[]{"TLSv1.2"};
    private static final String DEFAULT_SSL_CONTEXT_ALGORITHM = "TLS";

    private KeyStore loadKeyStore(String path, char[] pass) throws TrustStoreException {
        KeyStore keyStore;
        try {
            keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        }
        catch (KeyStoreException e) {
            throw new TrustStoreException(TrustStoreException.TrustStoreError.E_NO_PROVIDER);
        }
        FileInputStream keyStoreFile = null;
        try {
            keyStoreFile = new FileInputStream(path);
        }
        catch (FileNotFoundException e) {
            logger.error("Key store file not found");
            throw new TrustStoreException(TrustStoreException.TrustStoreError.E_FILE_NOT_FOUND);
        }
        try {
            keyStore.load(keyStoreFile, pass);
        }
        catch (NoSuchAlgorithmException e) {
            logger.error("Not able to load Key store file");
            throw new TrustStoreException(TrustStoreException.TrustStoreError.E_KEYSTORE_LOAD);
        }
        catch (CertificateException e) {
            logger.error("Not able to load Key store file");
            throw new TrustStoreException(TrustStoreException.TrustStoreError.E_KEYSTORE_LOAD);
        }
        catch (IOException e) {
            logger.error("Not able to load Key store file");
            throw new TrustStoreException(TrustStoreException.TrustStoreError.E_KEYSTORE_LOAD);
        }
        finally {
            try {
                if (keyStoreFile != null) {
                    keyStoreFile.close();
                }
            }
            catch (IOException e) {
                throw new TrustStoreException(TrustStoreException.TrustStoreError.E_KEYSTORE_LOAD);
            }
        }
        return keyStore;
    }

    public ClientConnectionConfiguration(String path, char[] pass) throws TrustStoreException {
        this.keyStorePath = path;
        this.keyStorePass = pass;
        this.keystore = this.loadKeyStore(path, pass);
        this.SSLContextAlgorithm = DEFAULT_SSL_CONTEXT_ALGORITHM;
        this.keyStoreType = KeyStore.getDefaultType();
        this.setPSPdefaults();
        this.endpointIdentificationAlgorithm = "HTTPS";
    }

    public final String getKeyStorePath() {
        return this.keyStorePath;
    }

    public final char[] getKeyStorePassword() {
        return this.keyStorePass;
    }

    public final String getKeyStoreType() {
        return this.keyStoreType;
    }

    public final void setKeyStoreType(String type) {
        this.keyStoreType = type;
    }

    public final String[] getSupportedProtocols() {
        return this.supportedSSLProtocols;
    }

    public final void setSupportedProtocols(String[] protocols) {
        this.supportedSSLProtocols = protocols;
    }

    public final String[] getSupportedCipherSuites() {
        return this.supportedSSLCipherSuites;
    }

    public final void setSupportedCipherSuites(String[] cipherSuites) {
        this.supportedSSLCipherSuites = cipherSuites;
    }

    public final KeyStore getKeyStore() {
        return this.keystore;
    }

    public final String getSSLContextAlgorithm() {
        return this.SSLContextAlgorithm;
    }

    public final void setSSLContextAlgorithm(String algorithm) {
        this.SSLContextAlgorithm = algorithm;
    }

    public final void setPSPdefaults() {
        this.supportedSSLCipherSuites = PSP_CIPHER_SUITES;
        this.supportedSSLProtocols = PSP_SSL_PROTOCOLS;
    }

    public void setEndpointIdentificationAlgorithm(String algorithm) {
        this.endpointIdentificationAlgorithm = algorithm;
    }

    public String getEndpointIdentificationAlgorithm() {
        return this.endpointIdentificationAlgorithm;
    }
}

