/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.security;

import com.vmware.vcim.ngc.service.security.ClientConnectionConfiguration;
import com.vmware.vcim.ngc.service.security.exceptions.TrustManagerException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509TrustManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonX509TrustManager
implements X509TrustManager {
    private static final Logger logger = LoggerFactory.getLogger(CommonX509TrustManager.class);
    private X509TrustManager defaultTrustManager = null;
    private ClientConnectionConfiguration config = null;

    public CommonX509TrustManager(ClientConnectionConfiguration config) throws TrustManagerException {
        TrustManagerFactory trustMgrFactory = null;
        this.config = config;
        KeyStore certificateStore = config.getKeyStore();
        String defaultTrustMgrAlgorithm = TrustManagerFactory.getDefaultAlgorithm();
        try {
            trustMgrFactory = TrustManagerFactory.getInstance(defaultTrustMgrAlgorithm);
        }
        catch (NoSuchAlgorithmException e1) {
            logger.error("TrustMgrFactory: Not valid algorithm");
            throw new TrustManagerException(TrustManagerException.TrustManagerError.E_NO_SUCH_ALGORITHM);
        }
        try {
            trustMgrFactory.init(certificateStore);
        }
        catch (KeyStoreException e) {
            logger.error("Unable to initialise Trust manager");
            throw new TrustManagerException(TrustManagerException.TrustManagerError.E_KEYSTORE_INIT);
        }
        TrustManager[] trustManagers = trustMgrFactory.getTrustManagers();
        for (int i = 0; i < trustManagers.length; ++i) {
            if (!(trustManagers[i] instanceof X509TrustManager)) continue;
            this.defaultTrustManager = (X509TrustManager)trustManagers[i];
            return;
        }
        throw new TrustManagerException(TrustManagerException.TrustManagerError.E_NO_X509_TRUST_MANAGER);
    }

    @Override
    public void checkClientTrusted(X509Certificate[] certificateChain, String authType) throws CertificateException {
        this.defaultTrustManager.checkClientTrusted(certificateChain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.defaultTrustManager.checkServerTrusted(chain, authType);
        logger.info("vchs certificate verified");
        return;
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.defaultTrustManager.getAcceptedIssuers();
    }
}

