/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.security;

import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLSocket;
import org.apache.http.conn.ConnectTimeoutException;
import org.apache.http.conn.ssl.SSLSocketFactory;
import org.apache.http.params.HttpParams;

public class CustomSSLFactory
extends SSLSocketFactory {
    private SSLParameters sslParams;

    public CustomSSLFactory(SSLContext sslContext, SSLParameters paramForSSL) {
        super(sslContext);
        this.sslParams = paramForSSL;
    }

    private Socket wrapSocket(Socket sock) {
        SSLSocket sslSock = (SSLSocket)sock;
        sslSock.setSSLParameters(this.sslParams);
        return sslSock;
    }

    public Socket connectSocket(Socket arg0, InetSocketAddress arg1, InetSocketAddress arg2, HttpParams arg3) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)super.connectSocket(arg0, arg1, arg2, arg3);
        return this.wrapSocket(sslSocket);
    }

    @Deprecated
    public Socket connectSocket(Socket arg0, String arg1, int arg2, InetAddress arg3, int arg4, HttpParams arg5) throws IOException, UnknownHostException, ConnectTimeoutException {
        SSLSocket sslSocket = (SSLSocket)super.connectSocket(arg0, arg1, arg2, arg3, arg4, arg5);
        return this.wrapSocket(sslSocket);
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)super.createLayeredSocket(socket, host, port, autoClose);
        return this.wrapSocket(sslSocket);
    }

    public Socket createLayeredSocket(Socket socket, String host, int port, HttpParams params) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)super.createLayeredSocket(socket, host, port, params);
        return this.wrapSocket(sslSocket);
    }

    @Deprecated
    public Socket createSocket() throws IOException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket();
        return this.wrapSocket(sslSocket);
    }

    public Socket createSocket(HttpParams params) throws IOException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket();
        return this.wrapSocket(sslSocket);
    }

    @Deprecated
    public Socket createSocket(Socket socket, String host, int port, boolean autoClose) throws IOException, UnknownHostException {
        SSLSocket sslSocket = (SSLSocket)super.createSocket(socket, host, port, autoClose);
        return this.wrapSocket(sslSocket);
    }
}

