/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.tasks.impl;

import com.vmware.vcim.ngc.service.cache.common.CacheController;
import com.vmware.vcim.ngc.service.model.Notification;
import com.vmware.vcim.ngc.service.tasks.ObjectType;
import com.vmware.vcim.ngc.service.tasks.TaskListener;
import com.vmware.vcim.ngc.service.tasks.VCimTask;
import com.vmware.vcim.ngc.service.tasks.VcimTaskMessage;
import com.vmware.vcim.ngc.service.tasks.impl.TaskAssembler;
import flex.messaging.MessageBroker;
import flex.messaging.messages.AsyncMessage;
import flex.messaging.messages.Message;
import flex.messaging.util.UUIDUtils;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskCompletedBroadcaster
implements TaskListener {
    private static final String MESSAGE_HEADER = "UserName";
    private static final String MESSAGE_DESTINATION = "vchsTaskNotifications";
    private static final Logger logger = LoggerFactory.getLogger(TaskCompletedBroadcaster.class);
    private ThreadPoolExecutor executor = new ThreadPoolExecutor(1, 10, 500L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
    private CacheController cacheController;
    private MessageBroker messageBroker;
    private TaskAssembler taskAssembler = new TaskAssembler();

    public TaskCompletedBroadcaster(CacheController cacheController) {
        this.cacheController = cacheController;
    }

    public void setMessageBroker(MessageBroker messageBroker) {
        this.messageBroker = messageBroker;
    }

    @Override
    public void callback(final VCimTask task) {
        if (null != this.messageBroker) {
            this.executor.execute(new Runnable(){

                @Override
                public void run() {
                    if (TaskCompletedBroadcaster.this.cacheController.isCacheAvailable() && (VCimTask.TaskState.SUCCESS == task.getState() || VCimTask.TaskState.ERROR == task.getState())) {
                        try {
                            Notification notification = task.getNotification();
                            String entityId = notification.getOwnerId();
                            String username = notification.getUserName();
                            if (notification.getOwnerMediaType().equalsIgnoreCase("application/xml;class=vnd.vmware.ares.vdc")) {
                                if (notification.getTaskType().equals("Update")) {
                                    TaskCompletedBroadcaster.this.cacheController.updateVdc(entityId, username);
                                } else if (notification.getTaskType().equals("Delete")) {
                                    TaskCompletedBroadcaster.this.cacheController.deleteVdc(entityId, username);
                                }
                            } else if (notification.getOwnerMediaType().equalsIgnoreCase("application/xml;class=vnd.vmware.ares.vmtype")) {
                                if (notification.getTaskType().equals("Delete")) {
                                    TaskCompletedBroadcaster.this.cacheController.deleteVm(entityId, username);
                                } else {
                                    TaskCompletedBroadcaster.this.cacheController.updateVm(entityId, username);
                                }
                            } else if (notification.getOwnerMediaType().equalsIgnoreCase("application/xml;class=vnd.vmware.ares.gateway")) {
                                if (notification.getTaskType().equals("Update")) {
                                    TaskCompletedBroadcaster.this.cacheController.updateGateway(entityId, username);
                                } else if (notification.getTaskType().equals("Delete")) {
                                    TaskCompletedBroadcaster.this.cacheController.deleteGateway(entityId, username);
                                }
                            }
                        }
                        catch (Exception ex) {
                            // empty catch block
                        }
                    }
                    VcimTaskMessage messageBody = new VcimTaskMessage();
                    messageBody.setClientTaskInfo(TaskCompletedBroadcaster.this.taskAssembler.buildClientTaskInfo(task));
                    messageBody.setObjectType(task.getEntityType() != null ? task.getEntityType() : ObjectType.VM);
                    AsyncMessage message = new AsyncMessage();
                    message.setDestination(TaskCompletedBroadcaster.MESSAGE_DESTINATION);
                    message.setMessageId(UUIDUtils.createUUID());
                    message.setTimestamp(System.currentTimeMillis());
                    message.setHeader(TaskCompletedBroadcaster.MESSAGE_HEADER, (Object)task.getOwner().toLowerCase());
                    message.setBody((Object)messageBody);
                    try {
                        TaskCompletedBroadcaster.this.messageBroker.routeMessageToService((Message)message, null);
                    }
                    catch (Exception ex) {
                        logger.error("Unable to push message to ui", (Throwable)ex);
                    }
                }
            });
        }
    }
}

