/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.tasks.monitor.impl;

import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.rest.vcim.VcloudRestClient;
import com.vmware.vcim.ngc.service.tasks.ObjectType;
import com.vmware.vcim.ngc.service.tasks.TaskException;
import com.vmware.vcim.ngc.service.tasks.TaskService;
import com.vmware.vcim.ngc.service.tasks.VCimTask;
import com.vmware.vcloud.api.rest.schema_v1_5.TaskType;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class VCloudTaskMonitor {
    private TaskService taskService;
    private VcloudRestClient vcloudRestClient;
    private VcimSessionManager vcimSessionMgr;
    private Map<String, ObjectType> entityTypes;
    private static final Logger logger = LoggerFactory.getLogger(VCloudTaskMonitor.class);

    public VCloudTaskMonitor(TaskService taskService, VcloudRestClient vcloudRestClient, VcimSessionManager vcimSessionMgr) {
        this.taskService = taskService;
        this.vcloudRestClient = vcloudRestClient;
        this.vcimSessionMgr = vcimSessionMgr;
        this.populateEntityTypes();
    }

    private void populateEntityTypes() {
        this.entityTypes = new HashMap<String, ObjectType>();
        this.entityTypes.put("application/vnd.vmware.vcloud.vm+xml", ObjectType.VM);
        this.entityTypes.put("application/vnd.vmware.vcloud.vApp+xml", ObjectType.VM);
    }

    public void pushTask(TaskType task, String vdcId) {
        try {
            VCimTask vcimTask = this.convertToVcimTask(task, vdcId);
            this.taskService.pushTask(vcimTask);
        }
        catch (TaskException e) {
            logger.error("Unable to push task to Task Service", (Throwable)e);
        }
    }

    private VCimTask convertToVcimTask(TaskType task, String vdcId) {
        VCimTask vcimTask = new VCimTask(this.getTaskId(task.getId()), null);
        vcimTask.setVcloudTask(task);
        vcimTask.setEntityId(task.getOwner().getId());
        vcimTask.setEntityType(this.entityTypes.get(task.getOwner().getType()));
        vcimTask.setName(task.getOwner().getName());
        vcimTask.setStartTime(task.getStartTime().toGregorianCalendar().getTime());
        if (task.getEndTime() != null) {
            vcimTask.setEndTime(task.getEndTime().toGregorianCalendar().getTime());
        }
        vcimTask.setDescription(task.getOperation());
        vcimTask.setOwner(task.getUser().getName());
        if (task.getStatus().equalsIgnoreCase("queued") || task.getStatus().equalsIgnoreCase("preRunning") || task.getStatus().equalsIgnoreCase("running")) {
            vcimTask.setState(VCimTask.TaskState.RUNNING);
        }
        if (task.getStatus().equalsIgnoreCase("error") || task.getStatus().equalsIgnoreCase("canceled") || task.getStatus().equalsIgnoreCase("aborted")) {
            vcimTask.setState(VCimTask.TaskState.ERROR);
        }
        if (task.getStatus().equalsIgnoreCase("success")) {
            vcimTask.setState(VCimTask.TaskState.SUCCESS);
        }
        vcimTask.setVdcId(vdcId);
        return vcimTask;
    }

    public void monitorTasks() {
        List<VCimTask> runningTasks = this.taskService.getTasks(VCimTask.TaskState.RUNNING);
        if (runningTasks == null || runningTasks.isEmpty()) {
            return;
        }
        for (VCimTask task : runningTasks) {
            if (!task.isVcloudTask()) continue;
            String url = "/api/task/<TASK_ID>";
            url = url.replace("<TASK_ID>", task.getId());
            String clientSessionId = this.vcimSessionMgr.getClientSessionId(task.getOwner());
            if (clientSessionId == null) continue;
            ResponseEntity taskTypeResponse = (ResponseEntity)this.vcloudRestClient.sendGetRequest(url, TaskType.class, clientSessionId, task.getVdcId());
            TaskType taskType = (TaskType)taskTypeResponse.getBody();
            try {
                this.taskService.pushTask(this.convertToVcimTask(taskType, task.getVdcId()));
            }
            catch (TaskException e) {
                logger.error("Unable to push task to Task Service", (Throwable)e);
            }
        }
    }

    private String getTaskId(String taskUrn) {
        String[] urnParts = taskUrn.split(":");
        return urnParts[urnParts.length - 1];
    }
}

