/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VCimRegion;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.vpc.contracts.RegionOperations;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RegionVpcAdapter
implements RegionOperations,
DataAdapter {
    private VcimSessionManager vcimSessionMgr;
    private DataAdapterFactory dataAdapterFactory;
    private static final Logger logger = LoggerFactory.getLogger(RegionVpcAdapter.class);

    public RegionVpcAdapter(VcimSessionManager vcimSessionMgr) {
        this.vcimSessionMgr = vcimSessionMgr;
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimRegion> getRegions(String clientSessionId) {
        logger.info("Fetching regions for client id - " + clientSessionId);
        List<VCimRegion> regions = new ArrayList<VCimRegion>();
        VCimSession vcimSession = this.vcimSessionMgr.getSession(clientSessionId);
        if (null != vcimSession) {
            regions = vcimSession.getRegions();
        }
        return regions;
    }

    @Override
    public VCimRegion getRegion(String clientSessionId, String id) {
        logger.info("Fetching region with id " + id + " for client id - " + clientSessionId);
        List<VCimRegion> regions = this.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            if (!region.getId().equals(id)) continue;
            return region;
        }
        return null;
    }

    @Override
    public VCimRegion getRegion(String clientSessionId, URI regionUri) {
        logger.info("Fetching region with uri " + regionUri.toString() + " for client id - " + clientSessionId);
        List<VCimRegion> regions = this.getRegions(clientSessionId);
        for (VCimRegion region : regions) {
            if (!region.getUri().equals(regionUri)) continue;
            return region;
        }
        return null;
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_WRITE_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.REGION;
    }
}

