/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import com.vmware.ares.common.v1.TaskType;
import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.vcd.v1.OperatingSystemCatalogRecordListType;
import com.vmware.ares.vcd.v1.OperatingSystemCatalogRecordType;
import com.vmware.ares.vcd.v1.VmNetworkListType;
import com.vmware.ares.vcd.v1.VmStorageParamsType;
import com.vmware.ares.vcd.v2.DeployVmFromCatalogParamsType;
import com.vmware.ares.vcd.v2.MyImageRecordType;
import com.vmware.ares.vcd.v2.MyImagesListType;
import com.vmware.ares.vcd.v2.StorageProfileConfigType;
import com.vmware.ares.vcd.v2.VmNetworkTypeV2;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.model.Network;
import com.vmware.vcim.ngc.service.model.VCimTemplate;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VMStorage;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.rest.vcim.VcloudRestClient;
import com.vmware.vcim.ngc.service.vpc.contracts.TemplateOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vcim.ngc.service.vpc.impl.VpcAdapter;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultOrgVdcStorageProfileRecordType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultRecordType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultRecordsType;
import java.net.URI;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class TemplateVpcAdapter
extends VpcAdapter
implements TemplateOperations,
DataAdapter {
    private DataAdapterFactory dataAdapterFactory;
    private final AdapterWrapper adapterWrapper;
    private final VcloudRestClient vcloudRestClient;
    private static final String DEPLOY_DESCRIPTION = "Deploying VM";
    private static final Logger logger = LoggerFactory.getLogger(TemplateVpcAdapter.class);

    public TemplateVpcAdapter(VcimRestClient vcimRestClient, AdapterWrapper adapterWrapper, VcloudRestClient vcloudRestClient) {
        super(vcimRestClient);
        this.adapterWrapper = adapterWrapper;
        this.vcloudRestClient = vcloudRestClient;
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimTemplate> getTemplates(String clientSessionId) {
        ArrayList<VCimTemplate> templates = new ArrayList<VCimTemplate>();
        List<VCimVirtualDatacenter> vDCs = this.getVdcReadOnlyAdapter().getVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                if (!vDC.isPrivate()) {
                    if (CloudTypeType.DR_2_C == vDC.getContainerCloudType()) {
                        templates.addAll(this.getSharedDR2COsCatalogs(clientSessionId, vDC));
                        templates.addAll(this.getSharedDR2CImages(clientSessionId, vDC));
                        continue;
                    }
                    templates.addAll(this.getSharedOsCatalogs(clientSessionId, vDC));
                    templates.addAll(this.getSharedImages(clientSessionId, vDC));
                    continue;
                }
                templates.addAll(this.getPrivateOsCatalogs(clientSessionId, vDC));
                templates.addAll(this.getPrivateImages(clientSessionId, vDC));
            }
        }
        return templates;
    }

    private List<VCimTemplate> getSharedOsCatalogs(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching OS catalogs for shared VDC - " + vDC.getName());
        String url = "/api/private/vpc/<VDC_ID>/spCatalogs";
        url = url.replace("<VDC_ID>", vDC.getId());
        return this.getOsCatalogs(clientSessionId, url, false, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getSharedDR2COsCatalogs(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching OS catalogs for shared VDC - " + vDC.getName());
        String url = "/api/private/dr2c/<VDC_ID>/spCatalogs";
        url = url.replace("<VDC_ID>", vDC.getId());
        return this.getOsCatalogs(clientSessionId, url, false, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getPrivateOsCatalogs(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.info("Fetching OS catalogs for dedicated VDC - " + vDC.getName());
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/spCatalogs";
        url = url.replace("<VPC_ID>", vDC.getCloudId());
        url = url.replace("<VDC_ID>", vDC.getId());
        return this.getOsCatalogs(clientSessionId, url, true, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getOsCatalogs(String clientSessionId, String url, boolean isPrivate, String vpcId, String vdcId) {
        ArrayList<VCimTemplate> templates = new ArrayList<VCimTemplate>();
        try {
            ResponseEntity osCatalogResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, OperatingSystemCatalogRecordListType.class, null, clientSessionId);
            OperatingSystemCatalogRecordListType osList = (OperatingSystemCatalogRecordListType)osCatalogResponse.getBody();
            logger.info("Found " + osList.getOsCatalogRecords().size() + " OS catalogs");
            for (OperatingSystemCatalogRecordType osCatalogRecord : osList.getOsCatalogRecords()) {
                templates.add(new VCimTemplate(osCatalogRecord, isPrivate, vpcId, vdcId));
            }
        }
        catch (Exception ex) {
            logger.error("Error fetching OS catalogs.", (Throwable)ex);
        }
        return templates;
    }

    private List<VCimTemplate> getSharedImages(String clientSessionId, VCimVirtualDatacenter vDC) {
        String url = "/api/private/vpc/<VDC_ID>/myCatalogs";
        url = url.replace("<VDC_ID>", vDC.getId());
        return this.getMyImages(clientSessionId, url, false, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getSharedDR2CImages(String clientSessionId, VCimVirtualDatacenter vDC) {
        String url = "/api/private/dr2c/<VDC_ID>/myCatalogs";
        url = url.replace("<VDC_ID>", vDC.getId());
        return this.getMyImages(clientSessionId, url, false, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getPrivateImages(String clientSessionId, VCimVirtualDatacenter vDC) {
        String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/myCatalogs";
        url = url.replace("<VPC_ID>", vDC.getCloudId());
        url = url.replace("<VDC_ID>", vDC.getId());
        return this.getMyImages(clientSessionId, url, true, vDC.getCloudId(), vDC.getId());
    }

    private List<VCimTemplate> getMyImages(String clientSessionId, String url, boolean isPrivate, String vpcId, String vdcId) {
        ArrayList<VCimTemplate> templates = new ArrayList<VCimTemplate>();
        try {
            ResponseEntity myImageResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, MyImagesListType.class, null, clientSessionId);
            MyImagesListType imageList = (MyImagesListType)myImageResponse.getBody();
            logger.info("Found " + imageList.getMyImage().size() + " my images.");
            for (MyImageRecordType imageRecord : imageList.getMyImage()) {
                templates.add(new VCimTemplate(imageRecord, isPrivate, vpcId, vdcId));
            }
        }
        catch (Exception ex) {
            logger.error("Error fetching my images.", (Throwable)ex);
        }
        return templates;
    }

    @Override
    public VCimTemplate getTemplate(String clientSessionId, URI templateUri) {
        logger.info("Fetching template with URI - " + templateUri + "for client id - " + clientSessionId);
        String vdcId = VCimTemplate.getVdcId(templateUri);
        List<VCimTemplate> templates = this.getTemplatesForVdc(clientSessionId, vdcId);
        for (VCimTemplate template : templates) {
            if (!templateUri.equals(template.getUri())) continue;
            logger.info("Found template with URI - " + templateUri);
            return template;
        }
        return null;
    }

    @Override
    public void deployTemplate(String clientSessionId, URI templateUri, String name, int vcpu, long memory, List<VMStorage> storage, List<Network> networks) {
        logger.info("Deploying template: URI - " + templateUri + ", Name - " + name + ", VCPU - " + vcpu + ", Memory - " + memory + ", Number of hard disks - " + storage.size() + ", Number of networks - " + networks.size());
        VCimTemplate template = this.getTemplate(clientSessionId, templateUri);
        DeployVmFromCatalogParamsType deployTemplate = new DeployVmFromCatalogParamsType();
        String vdcId = VCimTemplate.getVdcId(templateUri);
        String queryUrl = "/api/query?type=orgVdcStorageProfile";
        ResponseEntity queryResultRecordsTypeResponse = (ResponseEntity)this.vcloudRestClient.sendGetRequest(queryUrl, QueryResultRecordsType.class, clientSessionId, vdcId);
        QueryResultRecordsType queryResultRecordsType = (QueryResultRecordsType)queryResultRecordsTypeResponse.getBody();
        HashMap<String, String> storageProfiles = new HashMap<String, String>();
        for (JAXBElement jaxbElement : queryResultRecordsType.getRecord()) {
            QueryResultRecordType queryResultRecord = (QueryResultRecordType)jaxbElement.getValue();
            QueryResultOrgVdcStorageProfileRecordType vdcStorageProfile = (QueryResultOrgVdcStorageProfileRecordType)queryResultRecord;
            storageProfiles.put(vdcStorageProfile.getName(), vdcStorageProfile.getHref());
        }
        if (null != template) {
            deployTemplate.setVAppTemplateHref(template.getTemplate().getHref());
            deployTemplate.setVmName(name);
            deployTemplate.setVCpu(vcpu);
            deployTemplate.setMemoryMb(memory);
            deployTemplate.setHardwareChanged(true);
            for (int i = 0; i < storage.size(); ++i) {
                VMStorage vmStorage = storage.get(i);
                VmStorageParamsType storageType = new VmStorageParamsType();
                storageType.setCapacityMb(vmStorage.getCapacity());
                storageType.setPort(i);
                storageType.setNew(true);
                storageType.setStorageProfile(vmStorage.getProfile());
                deployTemplate.getStorage().add(storageType);
                StorageProfileConfigType stconfig = new StorageProfileConfigType();
                stconfig.setProfileName(vmStorage.getProfile());
                stconfig.setHref((String)storageProfiles.get(vmStorage.getProfile()));
                stconfig.setPort(i);
                stconfig.setBus(vmStorage.getBus());
                deployTemplate.getDiskLevelStorageProfile().add(stconfig);
            }
            VmNetworkListType networkList = new VmNetworkListType();
            for (Network network : networks) {
                VmNetworkTypeV2 networkType = new VmNetworkTypeV2();
                networkType.setId(network.getId());
                networkType.setName(network.getName());
                networkType.setHref(network.getHref());
                networkList.getVmNetwork().add(networkType);
            }
            deployTemplate.setVMNetworkList(networkList);
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "vnd.vmware.ares.deployvmfromcatalogparams");
            ResponseEntity taskTypeResponse = null;
            if (template.isPrivate()) {
                String url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/vms";
                url = url.replace("<VPC_ID>", template.getVpcId());
                url = url.replace("<VDC_ID>", template.getVdcId());
                taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPostRequest(url, deployTemplate, String.class, headers, clientSessionId);
            } else {
                String url = "/api/private/vpc/<VDC_ID>/vms";
                url = url.replace("<VDC_ID>", template.getVdcId());
                taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPostRequest(url, deployTemplate, String.class, headers, clientSessionId);
            }
            int responseStatusCode = taskTypeResponse.getStatusCode().value();
            TaskType task = this.unMarshallTask(responseStatusCode, (String)taskTypeResponse.getBody());
            this.startTask(task, clientSessionId, name, DEPLOY_DESCRIPTION);
        }
    }

    @Override
    public List<VCimTemplate> getTemplatesForVdc(String clientSessionId, String vdcId) {
        ArrayList<VCimTemplate> templates = new ArrayList<VCimTemplate>();
        logger.info("Fetching templates for vdc id - " + vdcId);
        Date currentTimestamp = new Date();
        logger.info("Started fetching templates for VDC " + vdcId + " from vCHS, Timestamp @ " + currentTimestamp.getTime());
        VCimVirtualDatacenter vDC = this.getVdcReadOnlyAdapter().getVDCById(clientSessionId, vdcId);
        if (vDC != null) {
            if (!vDC.isPrivate()) {
                if (CloudTypeType.DR_2_C == vDC.getContainerCloudType()) {
                    templates.addAll(this.getSharedDR2COsCatalogs(clientSessionId, vDC));
                    templates.addAll(this.getSharedDR2CImages(clientSessionId, vDC));
                } else {
                    templates.addAll(this.getSharedOsCatalogs(clientSessionId, vDC));
                    templates.addAll(this.getSharedImages(clientSessionId, vDC));
                }
            } else {
                templates.addAll(this.getPrivateOsCatalogs(clientSessionId, vDC));
                templates.addAll(this.getPrivateImages(clientSessionId, vDC));
            }
        }
        currentTimestamp = new Date();
        logger.info("Completed fetching templates for VDC " + vdcId + " from vCHS, Timestamp @ " + currentTimestamp.getTime());
        return templates;
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_WRITE_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.TEMPLATE;
    }

    private VirtualDatacenterOperations getVdcReadOnlyAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER));
    }
}

