/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import com.vmware.ares.company.v1.RoleType;
import com.vmware.ares.company.v1.UserListType;
import com.vmware.ares.company.v1.UserType;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.common.UriUtils;
import com.vmware.vcim.ngc.service.model.UserRole;
import com.vmware.vcim.ngc.service.model.VCimUser;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.vpc.contracts.UserOperations;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import org.springframework.http.ResponseEntity;

public class UserVpcAdapter
implements UserOperations,
DataAdapter {
    private VcimRestClient vcimRestClient;
    private DataAdapterFactory dataAdapterFactory;

    public UserVpcAdapter(VcimRestClient vcimRestClient) {
        this.vcimRestClient = vcimRestClient;
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    @Override
    public List<VCimUser> getUsers(String clientSessionId) {
        ArrayList<VCimUser> vcimUsers = new ArrayList<VCimUser>();
        ResponseEntity userResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest("/api/private/users", UserListType.class, null, clientSessionId);
        if (null != userResponse) {
            UserListType users = (UserListType)userResponse.getBody();
            for (UserType user : users.getUser()) {
                vcimUsers.add(new VCimUser(user));
            }
        }
        return vcimUsers;
    }

    @Override
    public VCimUser getUser(String clientSessionId, URI userUri) {
        ArrayList<UserRole> userRoleList = new ArrayList<UserRole>();
        ResponseEntity userResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest("/api/private/users", UserListType.class, null, clientSessionId);
        if (null != userResponse) {
            UserListType users = (UserListType)userResponse.getBody();
            for (UserType user : users.getUser()) {
                URI vcimUserUri = UriUtils.createURIUsingDefaults("User", user.getEmail());
                if (!vcimUserUri.equals(userUri)) continue;
                VCimUser vcimUser = new VCimUser(user);
                if (user.getState().name() == "ACTIVE") {
                    vcimUser.setUserStatus("Enabled");
                } else {
                    vcimUser.setUserStatus("Disabled");
                }
                for (RoleType roleType : user.getRoles()) {
                    UserRole userRole = new UserRole("", "");
                    userRole.setName(roleType.getName());
                    userRole.setDescription(roleType.getDescription());
                    userRoleList.add(userRole);
                }
                vcimUser.setUserRole(userRoleList);
                return vcimUser;
            }
        }
        return null;
    }

    @Override
    public void changeUserStatus(String clientSessionId, String userId, boolean userStatus) {
        if (userStatus) {
            String url = "/api/private/user/<USER_ID>/enable";
            url = url.replace("<USER_ID>", userId);
            this.vcimRestClient.sendPutRequest(url, null, null, null, clientSessionId);
        } else {
            String url = "/api/private/user/<USER_ID>/disable";
            url = url.replace("<USER_ID>", userId);
            this.vcimRestClient.sendPutRequest(url, null, null, null, clientSessionId);
        }
    }

    @Override
    public void deleteUser(String clientSessionId, String userId) {
        String url = "/api/private/user/<USER_ID>";
        url = url.replace("<USER_ID>", userId);
        this.vcimRestClient.sendDeleteRequest(url, null, null, null, clientSessionId);
    }

    @Override
    public void resetPassword(String clientSessionId, String userId) {
        String url = "/api/private/user/<USER_ID>/password/reset";
        url = url.replace("<USER_ID>", userId);
        this.vcimRestClient.sendPutRequest(url, null, null, null, clientSessionId);
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_WRITE_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.DATACENTER_USER;
    }
}

