/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import com.vmware.ares.common.v1.LinkType;
import com.vmware.ares.common.v1.TaskType;
import com.vmware.ares.common.v2.CloudTypeType;
import com.vmware.ares.vcd.v1.BackupParamsType;
import com.vmware.ares.vcd.v1.NetworkDetailsType;
import com.vmware.ares.vcd.v1.VdcAvailableComputeDetailsType;
import com.vmware.ares.vcd.v1.VmNetworkListType;
import com.vmware.ares.vcd.v1.VmNetworkType;
import com.vmware.ares.vcd.v1.VmOwnerType;
import com.vmware.ares.vcd.v1.VmScreenTicketType;
import com.vmware.ares.vcd.v2.DR2CTestFailoverParamsType;
import com.vmware.ares.vcd.v2.VMListType;
import com.vmware.ares.vcd.v2.VMRecordType;
import com.vmware.ares.vcd.v2.VmNetworkTypeV2;
import com.vmware.ares.vcd.v2.VmSettingsTypeV2;
import com.vmware.ares.vcd.v2.VmStorageParamsTypeV2;
import com.vmware.vcim.ngc.service.adapter.common.AdapterWrapper;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapter;
import com.vmware.vcim.ngc.service.adapter.common.DataAdapterFactory;
import com.vmware.vcim.ngc.service.impl.VcimSessionManager;
import com.vmware.vcim.ngc.service.model.VCimTemplate;
import com.vmware.vcim.ngc.service.model.VCimVirtualDatacenter;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachine;
import com.vmware.vcim.ngc.service.model.VCimVirtualMachineReplicationStatus;
import com.vmware.vcim.ngc.service.model.VMNetwork;
import com.vmware.vcim.ngc.service.model.VMStorage;
import com.vmware.vcim.ngc.service.model.VMSummary;
import com.vmware.vcim.ngc.service.model.VchsObjectType;
import com.vmware.vcim.ngc.service.model.VdcAvailableComputeData;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.rest.vcim.VcloudRestClient;
import com.vmware.vcim.ngc.service.tasks.ObjectType;
import com.vmware.vcim.ngc.service.tasks.TaskException;
import com.vmware.vcim.ngc.service.tasks.TaskService;
import com.vmware.vcim.ngc.service.tasks.VCimTask;
import com.vmware.vcim.ngc.service.tasks.monitor.impl.VCloudTaskMonitor;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualDatacenterOperations;
import com.vmware.vcim.ngc.service.vpc.contracts.VirtualMachineOperations;
import com.vmware.vcim.ngc.service.vpc.impl.VpcAdapter;
import com.vmware.vcloud.api.rest.schema_v1_5.CreateSnapshotParamsType;
import com.vmware.vcloud.api.rest.schema_v1_5.ObjectFactory;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultOrgVdcStorageProfileRecordType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultRecordType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultRecordsType;
import com.vmware.vcloud.api.rest.schema_v1_5.QueryResultVMRecordType;
import com.vmware.vcloud.api.rest.schema_v1_5.SnapshotSectionType;
import com.vmware.vcloud.api.rest.schema_v1_5.UndeployVAppParamsType;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.xml.bind.JAXBElement;
import javax.xml.namespace.QName;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.ResponseEntity;

public class VirtualMachineVpcAdapter
extends VpcAdapter
implements VirtualMachineOperations,
DataAdapter {
    private final HashMap<URI, HashMap<String, String>> vmHashMap = new HashMap();
    private DataAdapterFactory dataAdapterFactory;
    private final AdapterWrapper adapterWrapper;
    private VcloudRestClient vcloudRestClient;
    private final VCloudTaskMonitor vcloudTaskMonitor;
    private TaskService taskService;
    private VcimSessionManager vcimSessionMgr;
    private static final Logger logger = LoggerFactory.getLogger(VirtualMachineVpcAdapter.class);
    public static final ObjectFactory vcloudRest_v1_5_ObjectFactory = new ObjectFactory();
    public static final String POWER_ON_DESCRIPTION = "Powering On VM";
    public static final String POWER_OFF_DESCRIPTION = "Powering Off VM";
    public static final String SUSPEND_DESCRIPTION = "Suspending VM";
    public static final String RESET_DESCRIPTION = "Resetting VM";
    public static final String CREATE_DESCRIPTION = "Creating VM";
    public static final String DELETE_DESCRIPTION = "Deleting VM";
    public static final String CHANGE_OWNER_DESCRIPTION = "Changing VM Owner";
    public static final String VM_UPDATE_DESCRIPTION = "Updating VM";
    public static final String VM_UPDATE_NAME_DESCRIPTION = "Updating VM Name and Description";
    public static final String VM_UPDATE_STORAGE_DESCRIPTION = "Updating VM Storage";
    public static final String VM_UPDATE_MEMORY_DESCRIPTION = "Updating VM Memory";
    public static final String VM_UPDATE_CPU_DESCRIPTION = "Updating VM CPU";
    public static final String VM_NETWORK_UPDATE_DESCRIPTION = "Updating VM Networks";
    public static final String VM_CREATE_SNAPSHOT_DESCRIPTION = "Creating snapshot";
    public static final String VM_DELETE_SNAPSHOT_DESCRIPTION = "Deleting Snapshot";
    public static final String VM_REVERT_SNAPSHOT_DESCRIPTION = "Reverting Snapshot";
    public static final String TEST_DESCRIPTION = "Test";
    public static final String CLEANUP_DESCRIPTION = "Cleanup";
    public static final String FAILOVER_DESCRIPTION = "Recover";
    public static final String REMOVE_REPLICATION_DESCRIPTION = "Remove Replication";

    private VirtualMachineVpcAdapter(VcimRestClient vcimRestClient, VCloudTaskMonitor vcloudTaskMonitor, AdapterWrapper adapterWrapper) {
        super(vcimRestClient);
        this.adapterWrapper = adapterWrapper;
        this.vcloudTaskMonitor = vcloudTaskMonitor;
    }

    public DataAdapterFactory getDataAdapterFactory() {
        return this.dataAdapterFactory;
    }

    public void setDataAdapterFactory(DataAdapterFactory dataAdapterFactory) {
        this.dataAdapterFactory = dataAdapterFactory;
        this.dataAdapterFactory.registerAdapter(this);
    }

    public void setVcloudRestClient(VcloudRestClient restClient) {
        this.vcloudRestClient = restClient;
    }

    public VcloudRestClient getVcloudRestClient() {
        return this.vcloudRestClient;
    }

    public void setTaskService(TaskService taskService) {
        this.taskService = taskService;
    }

    public TaskService getTaskService() {
        return this.taskService;
    }

    public void setVcimSessionMgr(VcimSessionManager vcimSessionMgr) {
        this.vcimSessionMgr = vcimSessionMgr;
    }

    public VcimSessionManager getVcimSessionMgr() {
        return this.vcimSessionMgr;
    }

    @Override
    public List<VCimVirtualMachine> getVirtualMachines(String clientSessionId) {
        ArrayList<VCimVirtualMachine> vms = new ArrayList<VCimVirtualMachine>();
        logger.debug("Fetching virtual machines for client id - " + clientSessionId);
        List<VCimVirtualDatacenter> vDCs = this.getVdcReadOnlyAdapter().getVDCs(clientSessionId);
        if (vDCs != null) {
            for (VCimVirtualDatacenter vDC : vDCs) {
                vms.addAll(this.getVirtualMachines(clientSessionId, vDC));
            }
        }
        return vms;
    }

    @Override
    public List<VCimVirtualMachine> getVirtualMachinesForVdc(String clientSessionId, String vdcId) {
        List<VCimVirtualMachine> vms = new ArrayList<VCimVirtualMachine>();
        VCimVirtualDatacenter vDC = this.getVdcReadOnlyAdapter().getVDCById(clientSessionId, vdcId);
        if (null != vDC) {
            vms = this.getVirtualMachines(clientSessionId, vDC);
        }
        return vms;
    }

    @Override
    public List<VCimVirtualMachine> getVirtualMachinesForVdc(String clientSessionId, VCimVirtualDatacenter vdc) {
        List<VCimVirtualMachine> vms = new ArrayList<VCimVirtualMachine>();
        if (null != vdc) {
            vms = this.getVirtualMachines(clientSessionId, vdc);
        }
        return vms;
    }

    private List<VCimVirtualMachine> getVirtualMachines(String clientSessionId, VCimVirtualDatacenter vDC) {
        logger.debug("Fetching virtual machines for VDC - " + vDC.getName());
        Date currentTimestamp = new Date();
        logger.info("Fetching virtual machines for VDC " + vDC.getName() + " from vCHS, Timestamp @ " + currentTimestamp.getTime());
        ArrayList<VCimVirtualMachine> vms = new ArrayList<VCimVirtualMachine>();
        String url = null;
        Boolean isShared = false;
        if (!vDC.isPrivate()) {
            isShared = true;
            url = CloudTypeType.DR_2_C == vDC.getContainerCloudType() ? "/api/private/dr2c/<VDC_ID>/vms" : "/api/private/vpc/<VDC_ID>/vms";
        } else {
            url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/vms";
            url = url.replace("<VPC_ID>", vDC.getCloudId());
        }
        url = url.replace("<VDC_ID>", vDC.getId());
        ResponseEntity vmsResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VMListType.class, null, clientSessionId);
        if (null != vmsResponse) {
            VMListType vmList = (VMListType)vmsResponse.getBody();
            List<VCimVirtualMachineReplicationStatus> listOfStatuses = null;
            if (vDC.getContainerCloudType() == CloudTypeType.DR_2_C) {
                listOfStatuses = this.getVdcReadOnlyAdapter().getVirtualMachineReplicationStatusesForVdc(clientSessionId, vDC.getId());
            }
            for (VMRecordType vmRecord : vmList.getVMRecord()) {
                vmRecord.setVDCId(vDC.getId());
                VCimVirtualMachine vm = null;
                vm = vDC.getContainerCloudType() == CloudTypeType.DR_2_C ? new VCimVirtualMachine(vmRecord, isShared != false ? "" : vDC.getCloudId(), true, listOfStatuses) : new VCimVirtualMachine(vmRecord, isShared != false ? "" : vDC.getCloudId());
                vm.setVDC(vDC);
                vm.setvAppName(vmRecord.getVAppDetails().getVAPPName());
                vm.setAllocatedMemory(vmRecord.getLiveUsage().getMemoryAllocated());
                vms.add(vm);
            }
        }
        currentTimestamp = new Date();
        logger.info("Completed fetching virtual machines for VDC " + vDC.getName() + " from vCHS, Timestamp @ " + currentTimestamp.getTime());
        return vms;
    }

    private VmSettingsTypeV2 getVMSettings(String clientSessionId, VCimVirtualMachine vm) {
        String url;
        logger.debug("Fetching settings for VM - " + vm.getName());
        if (StringUtils.isEmpty((String)vm.getVpcId())) {
            url = CloudTypeType.DR_2_C == vm.getVDC().getContainerCloudType() ? "/api/private/dr2c/<VDC_ID>/vapp/<VAPP_ID>/vm/<VM_ID>" : "/api/private/vpc/<VDC_ID>/vapp/<VAPP_ID>/vm/<VM_ID>";
        } else {
            url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/vapp/<VAPP_ID>/vm/<VM_ID>";
            url = url.replace("<VPC_ID>", vm.getVpcId());
        }
        url = url.replace("<VDC_ID>", vm.getVDCId());
        url = url.replace("<VAPP_ID>", vm.getVAppDetails().getVAPP());
        url = url.replace("<VM_ID>", vm.getId());
        ResponseEntity vmResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(url, VmSettingsTypeV2.class, null, clientSessionId);
        VmSettingsTypeV2 vmSettings = (VmSettingsTypeV2)vmResponse.getBody();
        logger.debug("VM Settings fetched for VM - " + vm.getName());
        return vmSettings;
    }

    @Override
    public VCimVirtualMachine getVirtualMachine(String clientSessionId, URI vmUri) {
        return this.getVirtualMachine(clientSessionId, vmUri, true);
    }

    private VCimVirtualMachine getVirtualMachine(String clientSessionId, URI vmUri, boolean getSettings) {
        logger.debug("Getting details of VM with URI: " + vmUri.toString());
        String vpcId = VCimVirtualMachine.getVpcId(vmUri);
        List<VCimVirtualDatacenter> vDCs = StringUtils.isEmpty((String)vpcId) ? this.getVdcReadOnlyAdapter().getSharedVDCs(clientSessionId) : this.getVdcReadOnlyAdapter().getPrivateVDCs(clientSessionId);
        if (vDCs != null) {
            String vdcId = VCimVirtualMachine.getVdcId(vmUri);
            for (VCimVirtualDatacenter vDC : vDCs) {
                List<VCimVirtualMachine> vms;
                if (!vDC.getId().equals(vdcId) || (vms = this.getVirtualMachines(clientSessionId, vDC)) == null) continue;
                for (VCimVirtualMachine vm : vms) {
                    if (!vmUri.equals(vm.getUri())) continue;
                    if (getSettings) {
                        VmSettingsTypeV2 vmSettings = this.getVMSettings(clientSessionId, vm);
                        vm.setAllocatedCPU(vmSettings.getVCpu());
                        vm.setAllocatedMemory(vmSettings.getMemoryMb());
                        vm.setSnapshotStateBoolean(this.isSnapshotAvailable(clientSessionId, vmUri));
                        vm.setGuestOSCustomization(vmSettings.isEnableGuestCustomization());
                        vm.setGuestOSPassword(vmSettings.getGuestPassword());
                        vm.setVmwareTools(vmSettings.getVmwareTools());
                        long storage = 0L;
                        for (int i = 0; i < vmSettings.getStorageMb().size(); ++i) {
                            storage += (long)vmSettings.getStorageMb().get(i).getCapacityMb();
                        }
                        vm.setAllocatedStorage(storage);
                        vm.setVDC(vDC);
                    }
                    return vm;
                }
            }
        }
        return null;
    }

    @Override
    public void powerOnVirtualMachine(String clientSessionId, URI vmUri) {
        logger.debug("Power on requested for VM with URI: " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String url = "/api/vApp/<VM_ID>/power/action/powerOn";
        url = url.replace("<VM_ID>", vmId);
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcloudRestClient.sendPostRequest(url, null, com.vmware.vcloud.api.rest.schema_v1_5.TaskType.class, clientSessionId, vdcId);
        com.vmware.vcloud.api.rest.schema_v1_5.TaskType task = (com.vmware.vcloud.api.rest.schema_v1_5.TaskType)taskTypeResponse.getBody();
        this.vcloudTaskMonitor.pushTask(task, vdcId);
    }

    @Override
    public void powerOffVirtualMachine(String clientSessionId, URI vmUri) {
        logger.debug("Power off requested for VM with URI: " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vappId = VCimVirtualMachine.getVappId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String url = "/api/vApp/<VM_ID>/action/undeploy";
        url = this.vappHasMoreVms(vdcId, vappId, vmId, clientSessionId) ? url.replace("<VM_ID>", vmId) : url.replace("<VM_ID>", vappId);
        UndeployVAppParamsType undeployParams = vcloudRest_v1_5_ObjectFactory.createUndeployVAppParamsType();
        undeployParams.setUndeployPowerAction("powerOff");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.vcloud.undeployVAppParams");
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcloudRestClient.sendPostRequest(url, undeployParams, com.vmware.vcloud.api.rest.schema_v1_5.TaskType.class, headers, clientSessionId, vdcId);
        com.vmware.vcloud.api.rest.schema_v1_5.TaskType task = (com.vmware.vcloud.api.rest.schema_v1_5.TaskType)taskTypeResponse.getBody();
        this.vcloudTaskMonitor.pushTask(task, vdcId);
    }

    @Override
    public String getScreenTicket(String clientSessionId, URI vmUri) {
        ResponseEntity screenTicketResponse;
        logger.debug("VMRC console requested for VM with URI: " + vmUri.toString());
        String url = this.getURL("screenticket", vmUri);
        if (url.isEmpty()) {
            String vpcId = VCimVirtualMachine.getVpcId(vmUri);
            String vdcId = VCimVirtualMachine.getVdcId(vmUri);
            String vmId = VCimVirtualMachine.getVmId(vmUri);
            if (!StringUtils.isEmpty((String)vpcId)) {
                url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/vm/<VM_ID>/screenticket";
                url = url.replace("<VPC_ID>", vpcId);
            } else {
                url = "/api/private/vpc/<VDC_ID>/vm/<VM_ID>/screenticket";
            }
            url = url.replace("<VDC_ID>", vdcId);
            url = url.replace("<VM_ID>", vmId);
        }
        if (null != (screenTicketResponse = (ResponseEntity)this.vcimRestClient.sendPostRequest(url, null, VmScreenTicketType.class, null, clientSessionId))) {
            logger.debug("Screen ticket obtained for VM: " + vmUri.toString());
            VmScreenTicketType screenTicket = (VmScreenTicketType)screenTicketResponse.getBody();
            return "vmIP=" + screenTicket.getVmIP() + "&moRef=" + screenTicket.getVmMoRef() + "&ticket=" + screenTicket.getTicket();
        }
        return "";
    }

    private boolean vappHasMoreVms(String vdcId, String vappId, String vmId, String clientSessionId) {
        logger.debug("Check if the vapp " + vappId + " has more vms other than vm " + vmId);
        String filter = "(container==" + vappId.substring(vappId.indexOf(45) + 1) + ")";
        ResponseEntity queryResultRecordsTypeResponse = (ResponseEntity)this.vcloudRestClient.sendQueryRequest("vm", filter, clientSessionId, vdcId);
        QueryResultRecordsType queryResultRecordsType = (QueryResultRecordsType)queryResultRecordsTypeResponse.getBody();
        for (JAXBElement jaxbElement : queryResultRecordsType.getRecord()) {
            QueryResultRecordType queryResultRecord = (QueryResultRecordType)jaxbElement.getValue();
            QueryResultVMRecordType vmRecord = (QueryResultVMRecordType)queryResultRecord;
            String idUrn = vmRecord.getId();
            String[] idParts = idUrn.split(":");
            String id = "vm-" + idParts[idParts.length - 1];
            if (id.equalsIgnoreCase(vmId)) continue;
            logger.debug("vapp {} has more vms", (Object)vappId);
            return true;
        }
        logger.debug("vapp {} has NO more vms", (Object)vappId);
        return false;
    }

    @Override
    public void suspendVirtualMachine(String clientSessionId, URI vmUri) {
        logger.debug("Suspend operation requested for VM with URI: " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String vappId = VCimVirtualMachine.getVappId(vmUri);
        String url = "/api/vApp/<VM_ID>/action/undeploy";
        url = this.vappHasMoreVms(vdcId, vappId, vmId, clientSessionId) ? url.replace("<VM_ID>", vmId) : url.replace("<VM_ID>", vappId);
        UndeployVAppParamsType undeployParams = vcloudRest_v1_5_ObjectFactory.createUndeployVAppParamsType();
        undeployParams.setUndeployPowerAction("suspend");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.vcloud.undeployVAppParams");
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcloudRestClient.sendPostRequest(url, undeployParams, com.vmware.vcloud.api.rest.schema_v1_5.TaskType.class, headers, clientSessionId, vdcId);
        com.vmware.vcloud.api.rest.schema_v1_5.TaskType task = (com.vmware.vcloud.api.rest.schema_v1_5.TaskType)taskTypeResponse.getBody();
        this.vcloudTaskMonitor.pushTask(task, vdcId);
    }

    @Override
    public void resetVirtualMachine(String clientSessionId, URI vmUri) {
        logger.debug("Reset operation requested for VM with URI: " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String url = "/api/vApp/<VM_ID>/power/action/reset";
        url = url.replace("<VM_ID>", vmId);
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcloudRestClient.sendPostRequest(url, null, com.vmware.vcloud.api.rest.schema_v1_5.TaskType.class, clientSessionId, vdcId);
        com.vmware.vcloud.api.rest.schema_v1_5.TaskType task = (com.vmware.vcloud.api.rest.schema_v1_5.TaskType)taskTypeResponse.getBody();
        this.vcloudTaskMonitor.pushTask(task, vdcId);
    }

    @Override
    public void deleteVirtualMachine(String clientSessionId, URI vmUri) {
        logger.debug("Delete operation requested for VM with URI: " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String vappId = VCimVirtualMachine.getVappId(vmUri);
        String url = "/api/vApp/<VM_ID>";
        url = this.vappHasMoreVms(vdcId, vappId, vmId, clientSessionId) ? url.replace("<VM_ID>", vmId) : url.replace("<VM_ID>", vappId);
        url = url + "?force=true";
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcloudRestClient.sendDeleteRequest(url, null, com.vmware.vcloud.api.rest.schema_v1_5.TaskType.class, clientSessionId, vdcId);
        this.vmHashMap.remove(vmUri);
        com.vmware.vcloud.api.rest.schema_v1_5.TaskType task = (com.vmware.vcloud.api.rest.schema_v1_5.TaskType)taskTypeResponse.getBody();
        this.vcloudTaskMonitor.pushTask(task, vdcId);
    }

    @Override
    public void createSnapshot(String clientSessionId, URI vmUri) {
        logger.debug("Creating snapshot for vm with URI - " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String url = "/api/vApp/<VM_ID>/action/createSnapshot";
        url = url.replace("<VM_ID>", vmId);
        CreateSnapshotParamsType snapshotParams = vcloudRest_v1_5_ObjectFactory.createCreateSnapshotParamsType();
        snapshotParams.setMemory(Boolean.valueOf(true));
        snapshotParams.setName(vmId);
        snapshotParams.setQuiesce(Boolean.valueOf(true));
        snapshotParams.setDescription("");
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.vcloud.createSnapshotParams");
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcloudRestClient.sendPostRequest(url, snapshotParams, com.vmware.vcloud.api.rest.schema_v1_5.TaskType.class, headers, clientSessionId, vdcId);
        com.vmware.vcloud.api.rest.schema_v1_5.TaskType task = (com.vmware.vcloud.api.rest.schema_v1_5.TaskType)taskTypeResponse.getBody();
        this.vcloudTaskMonitor.pushTask(task, vdcId);
    }

    @Override
    public void revertSnapshot(String clientSessionId, URI vmUri) {
        logger.debug("Reverting snapshot for vm with URI - " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String url = "/api/vApp/<VM_ID>/action/revertToCurrentSnapshot";
        url = url.replace("<VM_ID>", vmId);
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcloudRestClient.sendPostRequest(url, null, com.vmware.vcloud.api.rest.schema_v1_5.TaskType.class, clientSessionId, vdcId);
        com.vmware.vcloud.api.rest.schema_v1_5.TaskType task = (com.vmware.vcloud.api.rest.schema_v1_5.TaskType)taskTypeResponse.getBody();
        this.vcloudTaskMonitor.pushTask(task, vdcId);
    }

    @Override
    public void deleteSnapshot(String clientSessionId, URI vmUri) {
        logger.debug("Deleting snapshot for vm with URI - " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String url = "/api/vApp/<VM_ID>/action/removeAllSnapshots";
        url = url.replace("<VM_ID>", vmId);
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcloudRestClient.sendPostRequest(url, null, com.vmware.vcloud.api.rest.schema_v1_5.TaskType.class, clientSessionId, vdcId);
        com.vmware.vcloud.api.rest.schema_v1_5.TaskType task = (com.vmware.vcloud.api.rest.schema_v1_5.TaskType)taskTypeResponse.getBody();
        this.vcloudTaskMonitor.pushTask(task, vdcId);
    }

    @Override
    public boolean isSnapshotAvailable(String clientSessionId, URI vmUri) {
        logger.debug("Check if snapshot is available for vm with URI - " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String url = "/api/vApp/<VM_ID>/snapshotSection";
        url = url.replace("<VM_ID>", vmId);
        ResponseEntity snapshotTypeResponse = (ResponseEntity)this.vcloudRestClient.sendGetRequest(url, SnapshotSectionType.class, clientSessionId, vdcId);
        SnapshotSectionType snapshotSection = (SnapshotSectionType)snapshotTypeResponse.getBody();
        return snapshotSection != null && snapshotSection.getSnapshot() != null;
    }

    private void changeOwner(String clientSessionId, URI vmUri, VMSummary vmSummary) {
        logger.debug("Change Owner:  VM Name = " + vmSummary.getName() + "VM URI = " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        String changeOwnerUrl = this.getURL("changeOwner", vmUri);
        if (changeOwnerUrl.isEmpty()) {
            String vpcId = VCimVirtualMachine.getVpcId(vmUri);
            if (!StringUtils.isEmpty((String)vpcId)) {
                changeOwnerUrl = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/vm/<VM_ID>/owner";
                changeOwnerUrl = changeOwnerUrl.replace("<VPC_ID>", vpcId);
            } else {
                changeOwnerUrl = "/api/private/vpc/<VDC_ID>/vm/<VM_ID>/owner";
            }
            changeOwnerUrl = changeOwnerUrl.replace("<VDC_ID>", vdcId);
            changeOwnerUrl = changeOwnerUrl.replace("<VM_ID>", vmId);
        }
        if (!StringUtils.isEmpty((String)vmSummary.getOwnerHref())) {
            logger.debug("Changing owner of VM (" + vmSummary.getName() + ") to " + vmSummary.getOwnerHref());
            VmOwnerType vmOwner = new VmOwnerType();
            vmOwner.setVAppId(vmSummary.getvAppId());
            vmOwner.setOwnerName(vmSummary.getOwnerHref());
            HashMap<String, String> headers = new HashMap<String, String>();
            headers.put("Content-Type", "vnd.vmware.ares.vmowner");
            ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPutRequest(changeOwnerUrl, vmOwner, String.class, headers, clientSessionId);
            TaskType task = this.unMarshallTask(taskTypeResponse.getStatusCode().value(), (String)taskTypeResponse.getBody());
            this.startTask(task, clientSessionId, vmSummary.getName(), CHANGE_OWNER_DESCRIPTION);
        }
    }

    @Override
    public VMSummary getVMData(String clientSessionId, URI vmUri) {
        logger.debug("Fetching VM Summary for VM with URI: " + vmUri.toString());
        VCimVirtualMachine vm = this.getVirtualMachine(clientSessionId, vmUri, false);
        VmSettingsTypeV2 vmSettings = this.getVMSettings(clientSessionId, vm);
        VMSummary vmSummary = this.getVMSummaryFromVMSettings(vmSettings, vm.isDR2cVm());
        vmSummary.setVdcId(vm.getVDCId());
        vmSummary.setPowerState(vm.getVMState());
        vmSummary.setVpcId(vm.getVpcId());
        vmSummary.setStorageProfiles(vm.getVDC().getStorageTier());
        vmSummary.setDr2cvm(vm.isDR2cVm());
        return vmSummary;
    }

    private VMSummary getVMSummaryFromVMSettings(VmSettingsTypeV2 vmSettings, boolean dr2cvm) {
        ArrayList<VMStorage> storage = new ArrayList<VMStorage>();
        ArrayList<VMNetwork> network = new ArrayList<VMNetwork>();
        VMSummary vmSummary = new VMSummary(0, 0L, null);
        ArrayList<com.vmware.vcim.ngc.service.model.LinkType> links = new ArrayList<com.vmware.vcim.ngc.service.model.LinkType>();
        for (LinkType linkType : vmSettings.getVCloudUILink()) {
            com.vmware.vcim.ngc.service.model.LinkType vcdLink = new com.vmware.vcim.ngc.service.model.LinkType(linkType.getHref(), linkType.getName(), linkType.getRel());
            links.add(vcdLink);
        }
        vmSummary.setDr2cvm(dr2cvm);
        vmSummary.setLinks(links);
        vmSummary.setId(vmSettings.getId());
        vmSummary.setHref(vmSettings.getHref());
        vmSummary.setName(vmSettings.getName());
        vmSummary.setDescription(vmSettings.getDescription());
        vmSummary.setvAppId(vmSettings.getVAppId());
        vmSummary.setBackup(vmSettings.isBackup());
        vmSummary.setVmwareTools(vmSettings.getVmwareTools());
        vmSummary.setVcpu(vmSettings.getVCpu());
        vmSummary.setMemory(vmSettings.getMemoryMb());
        vmSummary.setEnableGuestCustomization(vmSettings.isEnableGuestCustomization());
        vmSummary.setOwner(vmSettings.getOwner());
        vmSummary.setGuestPassword(vmSettings.getGuestPassword());
        if (vmSettings.getVdcAvailableComputeDetails() != null) {
            vmSummary.setVdcAvailableComputeResources(new VdcAvailableComputeData(vmSettings.getVdcAvailableComputeDetails().getVCpu(), vmSettings.getVdcAvailableComputeDetails().getMemoryMb(), vmSettings.getVdcAvailableComputeDetails().getStorageMb()));
        }
        vmSummary.setDpsProvisioned(vmSettings.isDPSProvisioned());
        for (VmStorageParamsTypeV2 vmStore : vmSettings.getStorageMb()) {
            VMStorage vmStorage = new VMStorage(0, 0);
            vmStorage.setCapacity(vmStore.getCapacityMb());
            vmStorage.setPort(vmStore.getPort());
            vmStorage.setProfile(vmStore.getStorageProfile());
            storage.add(vmStorage);
        }
        for (NetworkDetailsType networkDetails : vmSettings.getNetworkDetails()) {
            VMNetwork vmNetwork = new VMNetwork();
            vmNetwork.setDr2cvm(dr2cvm);
            ArrayList<String> gatewayNames = new ArrayList<String>();
            ArrayList<String> gatewayIps = new ArrayList<String>();
            vmNetwork.setNetworkId(networkDetails.getId());
            vmNetwork.setHref(networkDetails.getHref());
            vmNetwork.setName(networkDetails.getName());
            for (JAXBElement<?> element : networkDetails.getRest()) {
                String elementName = element.getName().getLocalPart();
                if (elementName.equalsIgnoreCase("Type")) {
                    vmNetwork.setType(element.getValue().toString());
                    continue;
                }
                if (elementName.equalsIgnoreCase("vmIP")) {
                    vmNetwork.setIpAddress(element.getValue().toString());
                    continue;
                }
                if (!elementName.equalsIgnoreCase("primaryNic")) continue;
                vmNetwork.setIsPrimaryNic(new Boolean(element.getValue().toString()));
            }
            vmNetwork.setGatewayNames(gatewayNames);
            vmNetwork.setGatewayIps(gatewayIps);
            network.add(vmNetwork);
        }
        vmSummary.setStorage(storage);
        vmSummary.setNetwork(network);
        return vmSummary;
    }

    @Override
    public void editVMSettings(String clientSessionId, URI vmUri, VMSummary vmSummary) {
        logger.info("Edit VM: VM Name = " + vmSummary.getName() + "VM URI = " + vmUri.toString());
        String updateSettingsUrl = this.getURL("update settings", vmUri);
        if (updateSettingsUrl.isEmpty()) {
            String vpcId = VCimVirtualMachine.getVpcId(vmUri);
            String vdcId = VCimVirtualMachine.getVdcId(vmUri);
            String vappId = VCimVirtualMachine.getVappId(vmUri);
            String vmId = VCimVirtualMachine.getVmId(vmUri);
            if (updateSettingsUrl.isEmpty()) {
                if (!StringUtils.isEmpty((String)vpcId)) {
                    updateSettingsUrl = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/vapp/<VAPP_ID>/vm/<VM_ID>";
                    updateSettingsUrl = updateSettingsUrl.replace("<VPC_ID>", vpcId);
                } else {
                    updateSettingsUrl = vmSummary.isDr2cvm() ? "/api/private/dr2c/<VDC_ID>/vapp/<VAPP_ID>/vm/<VM_ID>" : "/api/private/vpc/<VDC_ID>/vapp/<VAPP_ID>/vm/<VM_ID>";
                }
                updateSettingsUrl = updateSettingsUrl.replace("<VDC_ID>", vdcId);
                updateSettingsUrl = updateSettingsUrl.replace("<VAPP_ID>", vappId);
                updateSettingsUrl = updateSettingsUrl.replace("<VM_ID>", vmId);
            }
        }
        String vdcId = VCimTemplate.getVdcId(vmUri);
        String queryUrl = "/api/query?type=orgVdcStorageProfile";
        ResponseEntity queryResultRecordsTypeResponse = (ResponseEntity)this.vcloudRestClient.sendGetRequest(queryUrl, QueryResultRecordsType.class, clientSessionId, vdcId);
        QueryResultRecordsType queryResultRecordsType = (QueryResultRecordsType)queryResultRecordsTypeResponse.getBody();
        HashMap<String, String> storageProfiles = new HashMap<String, String>();
        for (JAXBElement jaxbElement : queryResultRecordsType.getRecord()) {
            QueryResultRecordType queryResultRecord = (QueryResultRecordType)jaxbElement.getValue();
            QueryResultOrgVdcStorageProfileRecordType vdcStorageProfile = (QueryResultOrgVdcStorageProfileRecordType)queryResultRecord;
            storageProfiles.put(vdcStorageProfile.getName(), vdcStorageProfile.getHref());
        }
        ResponseEntity vmResponse = (ResponseEntity)this.vcimRestClient.sendGetRequest(updateSettingsUrl, VmSettingsTypeV2.class, null, clientSessionId);
        VmSettingsTypeV2 vmxSettings = (VmSettingsTypeV2)vmResponse.getBody();
        this.changeOwner(clientSessionId, vmUri, vmSummary);
        vmxSettings.setName(vmSummary.getName());
        vmxSettings.setHref(vmSummary.getHref());
        vmxSettings.setId(vmSummary.getId());
        vmxSettings.setVCpu(vmSummary.getVcpu());
        vmxSettings.setMemoryMb(vmSummary.getMemory());
        vmxSettings.setDescription(vmSummary.getDescription());
        vmxSettings.setVAppId(vmSummary.getvAppId());
        vmxSettings.setBackup(vmSummary.isBackup());
        vmxSettings.setVmwareTools(vmSummary.getVmwareTools());
        vmxSettings.setState(vmSummary.getPowerState());
        vmxSettings.setOwner(vmSummary.getOwner());
        vmxSettings.setGuestPassword(vmSummary.getGuestPassword());
        VdcAvailableComputeDetailsType computeDetails = new VdcAvailableComputeDetailsType();
        computeDetails.setVCpu(vmSummary.getVdcAvailableComputeResources().getCpu());
        computeDetails.setMemoryMb(vmSummary.getVdcAvailableComputeResources().getMemory());
        computeDetails.setStorageMb(vmSummary.getVdcAvailableComputeResources().getStorage());
        vmxSettings.setVdcAvailableComputeDetails(computeDetails);
        ArrayList<VmStorageParamsTypeV2> newStorageOptions = new ArrayList<VmStorageParamsTypeV2>();
        for (int i = 0; i < vmSummary.getStorage().size(); ++i) {
            VmStorageParamsTypeV2 storageType;
            VMStorage vmStorage = vmSummary.getStorage().get(i);
            if (i < vmxSettings.getStorageMb().size()) {
                storageType = vmxSettings.getStorageMb().get(i);
            } else {
                storageType = new VmStorageParamsTypeV2();
                storageType.setNew(true);
                storageType.setBus(0);
            }
            storageType.setCapacityMb(vmStorage.getCapacity());
            storageType.setPort(i);
            storageType.setStorageProfile(vmStorage.getProfile());
            storageType.setStorageProfileHref((String)storageProfiles.get(vmStorage.getProfile()));
            newStorageOptions.add(storageType);
        }
        vmxSettings.getStorageMb().clear();
        vmxSettings.getStorageMb().addAll(newStorageOptions);
        List<NetworkDetailsType> networkOptions = vmxSettings.getNetworkDetails();
        for (int j = 0; j < vmSummary.getNetwork().size(); ++j) {
            VMNetwork vmNetwork = vmSummary.getNetwork().get(j);
            NetworkDetailsType networkDetails = networkOptions.get(j);
            networkDetails.setName(vmNetwork.getName());
            networkDetails.setHref(vmNetwork.getHref());
            networkDetails.setId(vmNetwork.getNetworkId());
            List<JAXBElement<?>> elements = networkDetails.getRest();
            elements.clear();
            QName qName = new QName("http://www.vmware.com/ares/vcd/v1", "Type", "");
            JAXBElement element = new JAXBElement(qName, String.class, (Object)vmNetwork.getType());
            elements.add(element);
            qName = new QName("http://www.vmware.com/ares/vcd/v1", "vmIP", "");
            element = new JAXBElement(qName, String.class, (Object)vmNetwork.getIpAddress());
            elements.add(element);
            qName = new QName("http://www.vmware.com/ares/vcd/v2", "primaryNic", "");
            JAXBElement primaryNicEl = new JAXBElement(qName, Boolean.class, (Object)true);
            elements.add(primaryNicEl);
        }
        for (com.vmware.vcim.ngc.service.model.LinkType linkType : vmSummary.getLinks()) {
            if (!linkType.getRel().equals("vms")) continue;
            LinkType vcdLink = new LinkType();
            vcdLink.setHref(linkType.getHref());
            vcdLink.setName(linkType.getLinkName());
            vcdLink.setRel(linkType.getRel());
            vmxSettings.getVCloudUILink().add(vcdLink);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        if (vmSummary.isDr2cvm()) {
            headers.put("Content-Type", "vnd.vmware.ares.vmsettings");
        } else {
            headers.put("Content-Type", "vnd.vmware.ares.vmsettings");
        }
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPutRequest(updateSettingsUrl, vmxSettings, String.class, headers, clientSessionId);
        TaskType task = this.unMarshallTask(taskTypeResponse.getStatusCode().value(), (String)taskTypeResponse.getBody());
        this.startTask(task, clientSessionId, null, VM_UPDATE_DESCRIPTION);
    }

    @Override
    public void updateVMNetworks(String clientSessionId, URI vmUri, String vAppId, List<VMNetwork> networks) {
        logger.debug("Updating networks of VM with URI - " + vmUri.toString());
        String url = this.getURL("addNetorkToVM", vmUri);
        if (url.isEmpty()) {
            String vpcId = VCimVirtualMachine.getVpcId(vmUri);
            String vdcId = VCimVirtualMachine.getVdcId(vmUri);
            String vmId = VCimVirtualMachine.getVmId(vmUri);
            if (!StringUtils.isEmpty((String)vpcId)) {
                url = "/api/private/dc/<VPC_ID>/vdc/<VDC_ID>/vm/<VM_ID>/network";
                url = url.replace("<VPC_ID>", vpcId);
            } else {
                url = networks.get(0).isDr2cvm() ? "/api/private/dr2c/<VDC_ID>/vm/<VM_ID>/network" : "/api/private/vpc/<VDC_ID>/vm/<VM_ID>/network";
            }
            url = url.replace("<VDC_ID>", vdcId);
            url = url.replace("<VM_ID>", vmId);
        }
        VmNetworkListType vmNetworkList = new VmNetworkListType();
        vmNetworkList.setVAppId(vAppId);
        List<VmNetworkType> vmNetworks = vmNetworkList.getVmNetwork();
        for (VMNetwork network : networks) {
            VmNetworkTypeV2 vmNetwork = new VmNetworkTypeV2();
            vmNetwork.setHref(network.getHref());
            vmNetwork.setId(network.getNetworkId());
            vmNetwork.setName(network.getName());
            vmNetworks.add(vmNetwork);
        }
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.ares.vmnetworklist");
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPutRequest(url, vmNetworkList, String.class, headers, clientSessionId);
        TaskType task = this.unMarshallTask(taskTypeResponse.getStatusCode().value(), (String)taskTypeResponse.getBody());
        this.startTask(task, clientSessionId, null, VM_NETWORK_UPDATE_DESCRIPTION);
    }

    private String getURL(String name, URI vmUri) {
        HashMap<String, String> linksHashMap;
        if (this.vmHashMap.containsKey(vmUri) && (linksHashMap = this.vmHashMap.get(vmUri)).containsKey(name)) {
            return linksHashMap.get(name);
        }
        return "";
    }

    @Override
    public void enrollVmForDps(String clientSessionId, URI vmUri, boolean backup) {
        String url = this.getURL("backup", vmUri);
        String vpcId = VCimVirtualMachine.getVpcId(vmUri);
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        String vappId = VCimVirtualMachine.getVappId(vmUri);
        String vmId = VCimVirtualMachine.getVmId(vmUri);
        if (url.isEmpty()) {
            if (!StringUtils.isEmpty((String)vpcId)) {
                url = "/api/private/dps/dc/<VPC_ID>/vdc/<VDC_ID>/vm/<VM_ID>/backup";
                url = url.replace("<VPC_ID>", vpcId);
            } else {
                url = "/api/private/dps/vpc/<VDC_ID>/vm/<VM_ID>/backup";
            }
            url = url.replace("<VDC_ID>", vdcId);
            url = url.replace("<VM_ID>", vmId);
        }
        BackupParamsType backupParams = new BackupParamsType();
        backupParams.setVAppId(vappId);
        backupParams.setBackup(backup);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.ares.backupparams");
        this.vcimRestClient.sendPostRequest(url, backupParams, null, headers, clientSessionId);
    }

    @Override
    public DataAdapter.AdapterType getAdapterType() {
        return DataAdapter.AdapterType.READ_WRITE_ADAPTER;
    }

    @Override
    public VchsObjectType getSupportedObjectType() {
        return VchsObjectType.VIRTUAL_MACHINE;
    }

    private VirtualDatacenterOperations getVdcReadOnlyAdapter() {
        return (VirtualDatacenterOperations)((Object)this.adapterWrapper.getReadOnlyAdapter(VchsObjectType.DATACENTER));
    }

    public URI getDR2CTestLinkURI(List<LinkType> list) {
        for (LinkType item : list) {
            if (!item.getName().equals("test")) continue;
            try {
                URI uri = new URI(item.getHref());
                return uri;
            }
            catch (URISyntaxException e) {
                logger.debug("Could not find href for test on DR2C Link");
            }
        }
        return null;
    }

    public URI getDR2CCleanupLinkURI(List<LinkType> list) {
        for (LinkType item : list) {
            if (!item.getName().equals("clean")) continue;
            try {
                URI uri = new URI(item.getHref());
                return uri;
            }
            catch (URISyntaxException e) {
                logger.debug("Could not find href for clean on DR2C Link");
            }
        }
        return null;
    }

    public URI getDR2CRecoverLinkURI(List<LinkType> list) {
        for (LinkType item : list) {
            if (!item.getName().equals("failover")) continue;
            try {
                URI uri = new URI(item.getHref());
                return uri;
            }
            catch (URISyntaxException e) {
                logger.debug("Could not find href for failover/recovery on DR2C Link");
            }
        }
        return null;
    }

    public URI getDR2CRemoveReplicationLinkURI(List<LinkType> list) {
        for (LinkType item : list) {
            if (!item.getName().equals("failover")) continue;
            try {
                URI uri = new URI(item.getHref());
                return uri;
            }
            catch (URISyntaxException e) {
                logger.debug("Could not find href for remove replication on DR2C Link");
            }
        }
        return null;
    }

    public String getDR2CPlaceholderId(URI uri) {
        String[] urlParts = uri.toString().split("/");
        return urlParts[urlParts.length - 3];
    }

    @Override
    public void test(String clientSessionId, URI vmUri) {
        logger.debug("On a DR2C VM, Test operation is requested with URI: " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        VCimVirtualMachine summary = this.getVirtualMachine(clientSessionId, vmUri, false);
        URI dr2cTestURI = this.getDR2CTestLinkURI(summary.getLink());
        String placeholder = this.getDR2CPlaceholderId(dr2cTestURI);
        String url = "/api/private/dr2c/<VDC_ID>/placeholder/<PLACEHOLDER_ID>/action/test";
        url = url.replace("<VDC_ID>", vdcId);
        url = url.replace("<PLACEHOLDER_ID>", placeholder);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.ares.dr2ctestfailoverparams");
        DR2CTestFailoverParamsType params = new DR2CTestFailoverParamsType();
        params.setSynchronize(false);
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPostRequest(url, params, TaskType.class, headers, clientSessionId);
        TaskType task = (TaskType)taskTypeResponse.getBody();
        this.pushTask(this.buildVcimTask(task, this.vcimSessionMgr.getSession(clientSessionId).getUsername(), ObjectType.VM, summary.getName(), TEST_DESCRIPTION));
    }

    @Override
    public void cleanup(String clientSessionId, URI vmUri) {
        logger.debug("On a DR2C VM, Cleanup operation is requested with URI: " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        VCimVirtualMachine summary = this.getVirtualMachine(clientSessionId, vmUri, false);
        URI dr2cTestURI = this.getDR2CCleanupLinkURI(summary.getLink());
        String placeholder = this.getDR2CPlaceholderId(dr2cTestURI);
        String url = "/api/private/dr2c/<VDC_ID>/placeholder/<PLACEHOLDER_ID>/action/clean";
        url = url.replace("<VDC_ID>", vdcId);
        url = url.replace("<PLACEHOLDER_ID>", placeholder);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.ares.dr2ctestfailoverparams");
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPostRequest(url, null, TaskType.class, headers, clientSessionId);
        TaskType task = (TaskType)taskTypeResponse.getBody();
        this.pushTask(this.buildVcimTask(task, this.vcimSessionMgr.getSession(clientSessionId).getUsername(), ObjectType.VM, summary.getName(), CLEANUP_DESCRIPTION));
    }

    @Override
    public void failover(String clientSessionId, URI vmUri) {
        logger.debug("On a DR2C VM, Recovery operation is requested with URI: " + vmUri.toString());
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        VCimVirtualMachine summary = this.getVirtualMachine(clientSessionId, vmUri, false);
        URI dr2cTestURI = this.getDR2CRecoverLinkURI(summary.getLink());
        String placeholder = this.getDR2CPlaceholderId(dr2cTestURI);
        String url = "/api/private/dr2c/<VDC_ID>/placeholder/<PLACEHOLDER_ID>/action/failover";
        url = url.replace("<VDC_ID>", vdcId);
        url = url.replace("<PLACEHOLDER_ID>", placeholder);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.ares.dr2ctestfailoverparams");
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendPostRequest(url, null, TaskType.class, headers, clientSessionId);
        TaskType task = (TaskType)taskTypeResponse.getBody();
        this.pushTask(this.buildVcimTask(task, this.vcimSessionMgr.getSession(clientSessionId).getUsername(), ObjectType.VM, summary.getName(), FAILOVER_DESCRIPTION));
    }

    @Override
    public void removereplication(String clientSessionId, URI vmUri) {
        logger.debug("On a DR2C VM, Remove Replication operation is requested with URI: " + vmUri.toString());
        logger.debug("Fetching the placeholders for the given VDC");
        String vdcId = VCimVirtualMachine.getVdcId(vmUri);
        VCimVirtualMachine summary = this.getVirtualMachine(clientSessionId, vmUri, false);
        URI dr2cTestURI = this.getDR2CRecoverLinkURI(summary.getLink());
        String placeholder = this.getDR2CPlaceholderId(dr2cTestURI);
        String url = "/api/private/dr2c/<VDC_ID>/placeholder/<PLACEHOLDER_ID>";
        url = url.replace("<VDC_ID>", vdcId);
        url = url.replace("<PLACEHOLDER_ID>", placeholder);
        HashMap<String, String> headers = new HashMap<String, String>();
        headers.put("Content-Type", "vnd.vmware.ares.dr2ctestfailoverparams");
        ResponseEntity taskTypeResponse = (ResponseEntity)this.vcimRestClient.sendDeleteRequest(url, null, TaskType.class, headers, clientSessionId);
        TaskType task = (TaskType)taskTypeResponse.getBody();
        this.pushTask(this.buildVcimTask(task, this.vcimSessionMgr.getSession(clientSessionId).getUsername(), ObjectType.VM, summary.getName(), REMOVE_REPLICATION_DESCRIPTION));
    }

    private void pushTask(VCimTask task) {
        try {
            this.taskService.pushTask(task);
        }
        catch (TaskException e) {
            logger.error("Unable to push task to Task Service", (Throwable)e);
        }
    }
}

