/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.impl;

import com.vmware.ares.common.v1.ErrorType;
import com.vmware.ares.common.v1.TaskState;
import com.vmware.ares.common.v1.TaskType;
import com.vmware.vcim.ngc.service.exception.VCimException;
import com.vmware.vcim.ngc.service.rest.vcim.VcimRestClient;
import com.vmware.vcim.ngc.service.tasks.ObjectType;
import com.vmware.vcim.ngc.service.tasks.VCimTask;
import java.io.ByteArrayInputStream;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class VpcAdapter {
    public static final int LOGIN_SUCCESS = 200;
    public static final int SERVER_PROBLEM = 500;
    private static final Logger logger = LoggerFactory.getLogger(VpcAdapter.class);
    protected VcimRestClient vcimRestClient;

    public VpcAdapter(VcimRestClient vcimRestClient) {
        this.vcimRestClient = vcimRestClient;
    }

    protected void startTask(TaskType taskType, String clientSessionId, String name, String description) {
    }

    protected VCimTask buildVcimTask(TaskType task, String owner, ObjectType type, String name, String description) {
        VCimTask vcimTask = new VCimTask(task.getId(), null);
        vcimTask.setNotification(null);
        vcimTask.setEntityId(task.getOwnerName());
        vcimTask.setEntityType(type);
        vcimTask.setName(name);
        vcimTask.setStartTime(task.getStartTime().toGregorianCalendar().getTime());
        if (task.getEndTime() != null) {
            vcimTask.setEndTime(task.getEndTime().toGregorianCalendar().getTime());
        }
        vcimTask.setDescription(description);
        vcimTask.setOwner(owner);
        if (task.getStatus() == TaskState.QUEUED || task.getStatus() == TaskState.RUNNING) {
            vcimTask.setState(VCimTask.TaskState.RUNNING);
        }
        if (task.getStatus() == TaskState.TASK_ERROR || task.getStatus() == TaskState.CANCELED || task.getStatus() == TaskState.ABORTED) {
            vcimTask.setState(VCimTask.TaskState.ERROR);
        }
        if (task.getStatus() == TaskState.SUCCESS) {
            vcimTask.setState(VCimTask.TaskState.SUCCESS);
        }
        return vcimTask;
    }

    protected TaskType unMarshallTask(int responseStatusCode, String strResponse) {
        TaskType task = null;
        if (200 == responseStatusCode) {
            logger.info("vCHS Login successful for user: ");
            ByteArrayInputStream is = null;
            try {
                JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{TaskType.class});
                Unmarshaller um = context.createUnmarshaller();
                is = new ByteArrayInputStream(strResponse.getBytes());
                JAXBElement jaxb = um.unmarshal((Source)new StreamSource(is), TaskType.class);
                task = (TaskType)jaxb.getValue();
                return task;
            }
            catch (JAXBException e) {
                logger.error("Problem unmarshalling task response.", (Throwable)e);
                throw new VCimException(500, "Please try after some time.");
            }
        }
        ByteArrayInputStream is = null;
        try {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{ErrorType.class});
            Unmarshaller um = context.createUnmarshaller();
            is = new ByteArrayInputStream(strResponse.getBytes());
            JAXBElement jaxb = um.unmarshal((Source)new StreamSource(is), ErrorType.class);
            ErrorType error = (ErrorType)jaxb.getValue();
            throw new VCimException(responseStatusCode, error.getMessage());
        }
        catch (JAXBException e) {
            logger.error("Problem unmarshalling error response.", (Throwable)e);
            return task;
        }
    }
}

