/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.notification.impl;

import com.vmware.vcim.ngc.service.model.SubscriptionDetails;
import com.vmware.vcim.ngc.service.vpc.notification.NotificationService;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VCimNotifierImpl {
    private NotificationService notificationService;
    private Map<String, Integer> sessionCounter = new HashMap<String, Integer>();
    private static final Logger logger = LoggerFactory.getLogger(VCimNotifierImpl.class);
    private final String SUFFIX = "PI_THETA_ALPHA";

    public void setNotificationService(NotificationService notificationService) {
        this.notificationService = notificationService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void createChannel(String user, String company, String aresAuthToken, String subscribeUrl) {
        logger.info("Opening notification channel for user: " + user);
        String lockObj = user + "PI_THETA_ALPHA";
        String string = lockObj.intern();
        synchronized (string) {
            Integer count = 1;
            user = user.toLowerCase();
            if (this.sessionCounter.containsKey(user)) {
                logger.warn("Notification channel is already open for user: " + user);
                Integer n = count = this.sessionCounter.get(user);
                Integer n2 = count = Integer.valueOf(count + 1);
                this.sessionCounter.put(user, count);
                return;
            }
            try {
                SubscriptionDetails details = new SubscriptionDetails(user, company, aresAuthToken, subscribeUrl);
                this.notificationService.subscribeForNotifications(details);
                this.sessionCounter.put(user, count);
                logger.info("Notification channel opened for user: " + user);
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyChannel(String user, boolean killForAllSessions) {
        logger.info("Closing notification channel for user: " + user + ", close for all users: " + killForAllSessions);
        String lockObj = user + "PI_THETA_ALPHA";
        String string = lockObj.intern();
        synchronized (string) {
            Integer count = 0;
            user = user.toLowerCase();
            if (this.sessionCounter.containsKey(user)) {
                Integer n = count = this.sessionCounter.get(user);
                Integer n2 = count = Integer.valueOf(count - 1);
                if (killForAllSessions) {
                    logger.info("Closing notification channel for all active sessions of the same user: " + user);
                    count = 0;
                }
                if (0 == count) {
                    logger.info("No active sessions for user: " + user + ". Hence, closing notification channel.");
                    if (!killForAllSessions) {
                        this.notificationService.unSubscribeAllSessions(user);
                    } else {
                        this.notificationService.unSubscribe(user);
                    }
                    this.sessionCounter.remove(user);
                } else {
                    logger.info("There are " + count + " active sessions for user: " + user + ". Hence, not closing notification channel.");
                    this.sessionCounter.put(user, count);
                }
            }
        }
    }

    public boolean isChannelRegistered(String user) {
        return this.sessionCounter.containsKey(user.toLowerCase());
    }
}

