/*
 * Decompiled with CFR 0.152.
 */
package com.vmware.vcim.ngc.service.vpc.notification.impl;

import com.vmware.vcim.ngc.service.impl.VCimSession;
import com.vmware.vcim.ngc.service.vpc.notification.NotificationChannelStateListener;
import com.vmware.vcim.ngc.service.vpc.notification.impl.VCimNotifierImpl;
import java.net.URI;
import java.net.URISyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VcimNotificationChannelMgr
implements NotificationChannelStateListener {
    private VCimNotifierImpl notifier;
    private static final Logger logger = LoggerFactory.getLogger(VcimNotificationChannelMgr.class);

    public VcimNotificationChannelMgr(VCimNotifierImpl VcimNotifier) {
        this.notifier = VcimNotifier;
    }

    public void reEstablishNotificationChannel(VCimSession session) {
        if (!this.notifier.isChannelRegistered(session.getVchsSession().getUser().getUserName())) {
            this.openNotificationChannel(session);
        }
    }

    public void openNotificationChannel(VCimSession session) {
        try {
            URI notifUri = new URI(session.getVpcUrl());
            String subscribeUrl = "https://" + notifUri.getHost() + "/api/private/notifications/subscribe";
            this.notifier.createChannel(session.getVchsSession().getUser().getUserName(), session.getVchsSession().getUser().getCompany().getId(), session.getAresAuthToken(), subscribeUrl);
        }
        catch (URISyntaxException e) {
            logger.error("Could create URI from string {} to open the notification channel", (Object)session.getVpcUrl(), (Object)e);
        }
        catch (Exception e) {
            logger.error("Could not open the notification channel", (Throwable)e);
        }
    }

    public void closeChannel(String username) {
        this.notifier.destroyChannel(username, false);
    }

    @Override
    public void channelClosed(String username) {
        this.notifier.destroyChannel(username, true);
    }

    @Override
    public void channelError(String username) {
        this.notifier.destroyChannel(username, true);
    }
}

