/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.MetricInvalidException;
import org.hyperic.hq.product.MetricProperties;
import org.hyperic.util.StringUtil;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.config.ConfigSchema;

public class Metric {
    private static final Log log = LogFactory.getLog(Metric.class);
    public static final String ATTR_AVAIL = "Availability";
    public static final double AVAIL_UNKNOWN = 2.0;
    public static final double AVAIL_UP = 100.0;
    public static final double AVAIL_DOWN = 0.0;
    @Deprecated
    public static final double AVAIL_WARN = 0.5;
    @Deprecated
    public static final double AVAIL_PAUSED = -0.01;
    @Deprecated
    public static final double AVAIL_POWERED_OFF = -0.02;
    private static HashMap cache = new HashMap();
    private static final MetricProperties NO_PROPERTIES = new MetricProperties();
    private final Object lock = new Object();
    private String template = null;
    private String domainName = null;
    private String objectName = null;
    private String objectPropString = null;
    private MetricProperties objectProperties = null;
    private String attributeName = null;
    private String propString = null;
    private MetricProperties props = null;
    private String id = null;
    private String category = null;
    private long interval;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Metric() {
        Object object = this.lock;
        synchronized (object) {
            this.interval = -1L;
        }
    }

    private static String getEncoding(char c) {
        switch (c) {
            case ':': {
                return "%3A";
            }
            case '=': {
                return "%3D";
            }
            case ',': {
                return "%2C";
            }
        }
        return null;
    }

    private static char getDecoding(String s, int i) {
        char c1 = s.charAt(i + 1);
        char c2 = s.charAt(i + 2);
        if (c1 == '2' && c2 == 'C') {
            return ',';
        }
        if (c1 == '3') {
            if (c2 == 'A') {
                return ':';
            }
            if (c2 == 'D') {
                return '=';
            }
        }
        return '0';
    }

    private static String getUnescapedDecoding(String s, int i) {
        String escapeIndicator = "\\\\";
        String[] specialVals = new String[]{"%3D", "%3A", "%2C"};
        String unescapedDecoding = null;
        try {
            String encodedString = s.substring(i, i + 5);
            for (int j = 0; j < specialVals.length; ++j) {
                String escapedString = escapeIndicator + specialVals[j];
                if (!escapedString.equals(encodedString)) continue;
                unescapedDecoding = specialVals[j];
                break;
            }
        }
        catch (IndexOutOfBoundsException iob) {
            // empty catch block
        }
        return unescapedDecoding;
    }

    public static String encode(String val) {
        StringBuffer buf = new StringBuffer(val.length());
        boolean changed = false;
        for (int i = 0; i < val.length(); ++i) {
            char c = val.charAt(i);
            String enc = Metric.getEncoding(c);
            if (enc == null) {
                buf.append(c);
                continue;
            }
            buf.append(enc);
            changed = true;
        }
        return changed ? buf.toString() : val;
    }

    public static String decode(String val) {
        StringBuffer buf = new StringBuffer(val.length());
        boolean changed = false;
        int len = val.length();
        for (int i = 0; i < len; ++i) {
            char dc;
            char c = val.charAt(i);
            if (c == '\\' && i + 4 < len) {
                String unesc = Metric.getUnescapedDecoding(val, i);
                if (unesc == null) {
                    buf.append(c);
                    continue;
                }
                i += 4;
                buf.append(unesc);
                changed = true;
                continue;
            }
            if (c == '%' && i + 2 < len && (dc = Metric.getDecoding(val, i)) != '0') {
                i += 2;
                c = dc;
                changed = true;
            }
            buf.append(c);
        }
        return changed ? buf.toString() : val;
    }

    public String getDomainName() {
        return this.domainName;
    }

    public void setDomainName(String domain) {
        this.domainName = domain;
    }

    public String getObjectName() {
        return this.objectName;
    }

    public void setObjectName(String objectName) {
        this.objectName = objectName;
        this.objectProperties = null;
    }

    public String getAttributeName() {
        return this.attributeName;
    }

    public String toString() {
        return this.template;
    }

    static String mask(String val) {
        if (val == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < val.length(); ++i) {
            sb.append('*');
        }
        return sb.toString();
    }

    private String toDebugString(String orig, Properties props) {
        if (props == null && orig == null) {
            return orig;
        }
        StringBuffer ds = new StringBuffer();
        StringTokenizer tok = new StringTokenizer(orig, ",");
        while (tok.hasMoreTokens()) {
            String pair = tok.nextToken();
            int ix = pair.indexOf(61);
            if (ix == -1) {
                ds.append(pair);
                continue;
            }
            String key = pair.substring(0, ix);
            if (ConfigSchema.isSecret((String)key) || ConfigSchema.isSensitive((String)key)) {
                ds.append(key).append('=');
                ds.append("******");
            } else {
                ds.append(pair);
            }
            if (!tok.hasMoreTokens()) continue;
            ds.append(',');
        }
        return ds.toString();
    }

    public String toDebugString() {
        StringBuffer dm = new StringBuffer();
        dm.append(this.domainName).append(':');
        dm.append(this.toDebugString(this.objectPropString, this.objectProperties));
        dm.append(':').append(this.attributeName);
        if (this.propString != null) {
            dm.append(':');
            dm.append(this.toDebugString(this.propString, this.props));
        }
        return dm.toString();
    }

    public Properties getProperties() {
        if (this.props == null) {
            this.props = this.propString == null ? NO_PROPERTIES : Metric.parseProperties(this.propString);
        }
        return this.props;
    }

    public void setPropString(String propString) {
        this.propString = propString;
    }

    public String getPropString() {
        return this.propString;
    }

    public String getObjectProperty(String property) {
        return this.getObjectProperties().getProperty(property);
    }

    public Properties getObjectProperties() {
        if (this.objectProperties == null) {
            this.objectProperties = Metric.parseProperties(this.objectPropString);
            this.objectProperties.setDefaults(this.props);
        }
        return this.objectProperties;
    }

    public String getObjectPropString() {
        return this.objectPropString;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static MetricProperties parseProperties(String config) {
        MetricProperties props;
        HashMap hashMap = cache;
        synchronized (hashMap) {
            props = (MetricProperties)cache.get(config);
            if (props != null) {
                return props;
            }
            props = new MetricProperties();
            cache.put(config, props);
        }
        if (config.indexOf(",") == -1 && config.startsWith("%") && config.endsWith("%")) {
            return props;
        }
        StringTokenizer st = new StringTokenizer(config, ",");
        while (st.hasMoreTokens()) {
            String key;
            String val;
            int ix;
            String attr = st.nextToken();
            if (attr.equals("*") || (ix = attr.indexOf(61)) == -1 || (val = attr.substring((key = attr.substring(0, ix)).length() + 1)).length() == 0) continue;
            ix = val.length() - 1;
            if (val.charAt(0) == '%' && val.charAt(ix) == '%' && val.substring(1, ix).equals(key)) continue;
            props.setProperty(key, Metric.decode(val));
        }
        return props;
    }

    public String getId() {
        return this.id;
    }

    public void setId(int type, int id) {
        this.id = type + ":" + id;
    }

    public String getCategory() {
        return this.category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getInterval() {
        Object object = this.lock;
        synchronized (object) {
            return this.interval;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setInterval(long interval) {
        Object object = this.lock;
        synchronized (object) {
            this.interval = interval;
        }
    }

    public boolean isAvail() {
        return "AVAILABILITY".equals(this.getCategory()) || this.getAttributeName().equals(ATTR_AVAIL);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Metric parse(String template) throws MetricInvalidException {
        Metric metric;
        if (template == null || template.length() == 0) {
            throw new MetricInvalidException();
        }
        HashMap hashMap = cache;
        synchronized (hashMap) {
            metric = (Metric)cache.get(template);
        }
        if (metric != null) {
            return metric;
        }
        metric = new Metric();
        metric.template = template;
        StringTokenizer st = new StringTokenizer(template, ":");
        try {
            metric.domainName = st.nextToken();
            metric.objectPropString = st.nextToken();
            if (!st.hasMoreTokens()) {
                if (template.endsWith(":")) {
                    metric.attributeName = "";
                } else {
                    metric.attributeName = metric.objectPropString;
                    metric.objectPropString = "DummyKey=DummyVal";
                    metric.objectName = metric.domainName + ":" + metric.objectPropString;
                }
            } else {
                metric.objectName = template.substring(0, metric.domainName.length() + 1 + metric.objectPropString.length());
                metric.attributeName = st.nextToken();
            }
            if (st.hasMoreTokens()) {
                int offset = metric.objectName.length() + metric.attributeName.length() + 2;
                metric.propString = template.substring(offset);
            }
        }
        catch (Exception e) {
            throw new MetricInvalidException(template, e);
        }
        HashMap hashMap2 = cache;
        synchronized (hashMap2) {
            cache.put(template, metric);
        }
        metric.attributeName = Metric.decode(metric.attributeName);
        return metric;
    }

    private static String replace(String template, String key, String val) {
        if (val == null) {
            return template;
        }
        return StringUtil.replace((String)template, (String)("%" + key + "%"), (String)Metric.encode(val));
    }

    public static String translate(String template, ConfigResponse config) {
        for (String key : config.getKeys()) {
            String val = config.getValue(key);
            template = Metric.replace(template, key, val);
        }
        return template;
    }

    public static String translate(String template, Properties props) {
        for (Map.Entry<Object, Object> entry : props.entrySet()) {
            String key = (String)entry.getKey();
            String val = (String)entry.getValue();
            template = Metric.replace(template, key, val);
        }
        return template;
    }

    public static String configTemplate(String[] props) {
        String template = "";
        for (int i = 0; i < props.length; ++i) {
            template = template + props[i] + "=" + "%" + props[i] + "%";
            if (i + 1 >= props.length) continue;
            template = template + ",";
        }
        return template;
    }

    private static void list(Metric metric) {
        System.out.println("DomainName: '" + metric.getDomainName() + "'");
        System.out.println("ObjectName: '" + metric.getObjectName() + "'");
        System.out.println("AttributeName: '" + metric.getAttributeName() + "'");
        System.out.println("Object Properties: '" + metric.getObjectPropString() + "'" + " (" + metric.getObjectProperties().size() + ")");
        if (metric.propString == null) {
            return;
        }
        System.out.println("Connection Properties: '" + metric.getPropString() + "'" + " (" + metric.getProperties().size() + ")");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void list(File file) throws Exception {
        BufferedReader reader = null;
        try {
            String line;
            reader = new BufferedReader(new FileReader(file));
            while ((line = reader.readLine()) != null) {
                if ((line = line.trim()).length() == 0 || line.startsWith("#")) continue;
                System.out.println("Template: " + line);
                Metric.list(Metric.parse(line));
                System.out.println("----------------------------");
            }
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
    }

    public static void main(String[] args) throws Exception {
        long memStart = Runtime.getRuntime().freeMemory();
        for (int i = 0; i < args.length; ++i) {
            String template = args[i];
            File file = new File(template);
            if (file.exists()) {
                Metric.list(file);
                continue;
            }
            Metric.list(Metric.parse(template));
        }
        long memEnd = Runtime.getRuntime().freeMemory();
        System.out.println("mem diff=" + (memStart - memEnd));
        int nMetrics = 0;
        int nProps = 0;
        for (Object o : cache.values()) {
            if (o instanceof Metric) {
                ++nMetrics;
                continue;
            }
            ++nProps;
        }
        System.out.println("cache entries=" + cache.size() + ", metrics=" + nMetrics + ", props=" + nProps);
    }
}

