/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.util.List;
import java.util.Map;
import org.hyperic.hq.plugin.system.ProcessData;
import org.hyperic.sigar.ProcCred;
import org.hyperic.sigar.ProcExe;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;

public class ProcessDetailData
extends ProcessData {
    private String[] _procArgs;
    private Map _procEnv;
    private List _procModules;
    private ProcExe _procExe;
    private ProcFd _procFd;
    private ProcCred _procCred;

    public void populate(SigarProxy sigar, long pid) throws SigarException {
        super.populate(sigar, pid);
        try {
            this._procArgs = sigar.getProcArgs(pid);
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            this._procEnv = sigar.getProcEnv(pid);
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            this._procModules = sigar.getProcModules(pid);
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            this._procExe = sigar.getProcExe(pid);
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            this._procFd = sigar.getProcFd(pid);
        }
        catch (SigarException e) {
            // empty catch block
        }
        try {
            this._procCred = sigar.getProcCred(pid);
        }
        catch (SigarException e) {
            // empty catch block
        }
    }

    public static ProcessData gather(SigarProxy sigar, long pid) throws SigarException {
        ProcessDetailData data = new ProcessDetailData();
        data.populate(sigar, pid);
        return data;
    }

    public String[] getProcArgs() {
        return this._procArgs;
    }

    public Map getProcEnv() {
        return this._procEnv;
    }

    public List getProcModules() {
        return this._procModules;
    }

    public ProcExe getProcExe() {
        return this._procExe;
    }

    public ProcFd getProcFd() {
        return this._procFd;
    }

    public ProcCred getProcCred() {
        return this._procCred;
    }
}

