/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.server.session;

import java.io.Serializable;
import org.hyperic.hq.product.MetricValue;

public class DataPoint
implements Serializable {
    private final Integer measurementId;
    private final MetricValue metricVal;

    public DataPoint(DataPoint other) {
        this.metricVal = new MetricValue(other.getMetricValue(), other.getTimestamp());
        this.measurementId = other.getMeasurementId();
    }

    public DataPoint(int measId, double metricVal, long timestamp) {
        this.metricVal = new MetricValue(metricVal, timestamp);
        this.measurementId = new Integer(measId);
    }

    public DataPoint(Integer measurementId, MetricValue metricVal) {
        this.measurementId = measurementId;
        this.metricVal = metricVal;
    }

    public Integer getMeasurementId() {
        return this.measurementId;
    }

    public MetricValue getMetricValue() {
        return this.metricVal;
    }

    public double getValue() {
        return this.metricVal.getValue();
    }

    public long getTimestamp() {
        return this.metricVal.getTimestamp();
    }

    public String toString() {
        return "id=" + this.measurementId + " val=" + this.metricVal.getValue() + " time=" + this.metricVal.getTimestamp();
    }

    public int hashCode() {
        return 17 + 37 * this.measurementId.hashCode() + 37 * new Long(this.metricVal.getTimestamp()).hashCode();
    }

    public boolean equals(Object rhs) {
        if (this == rhs) {
            return true;
        }
        if (!(rhs instanceof DataPoint)) {
            return false;
        }
        DataPoint d = (DataPoint)rhs;
        return d.getMeasurementId().equals(this.getMeasurementId()) && d.getTimestamp() == this.getTimestamp();
    }
}

