/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory.agent.server;

import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.AgentRemoteException;
import org.hyperic.hq.agent.AgentRemoteValue;
import org.hyperic.hq.agent.diagnostics.AgentDiagnosticObject;
import org.hyperic.hq.agent.diagnostics.AgentDiagnostics;
import org.hyperic.hq.agent.server.AgentDaemon;
import org.hyperic.hq.agent.server.AgentRunningException;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.agent.server.ConfigStorage;
import org.hyperic.hq.appdef.shared.AIPlatformValue;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.CompositeRuntimeResourceReport;
import org.hyperic.hq.autoinventory.RuntimeScanner;
import org.hyperic.hq.autoinventory.Scanner;
import org.hyperic.hq.autoinventory.SyncModeManager;
import org.hyperic.hq.autoinventory.agent.server.AutoinventoryCommandsServer;
import org.hyperic.hq.autoinventory.agent.server.RuntimeReportFilter;
import org.hyperic.hq.bizapp.client.AutoinventoryCallbackClient;
import org.hyperic.hq.product.AutoinventoryPluginManager;
import org.hyperic.hq.product.PlatformResource;
import org.hyperic.hq.product.PluginException;
import org.hyperic.hq.product.PluginNotFoundException;
import org.hyperic.hq.product.RuntimeDiscoverer;
import org.hyperic.hq.product.RuntimeResourceReport;
import org.hyperic.hq.product.ServerDetector;
import org.hyperic.hq.util.properties.PropertiesUtil;
import org.hyperic.util.PluginLoader;
import org.hyperic.util.config.ConfigResponse;
import org.hyperic.util.timer.StopWatch;

class RuntimeAutodiscoverer
implements RuntimeScanner,
AgentDiagnosticObject {
    private static final long DEFAULT_SCAN_INTERVAL = 900000L;
    private static final long DEFAULT_RUNTIME_SCAN_INTERVAL = Long.MAX_VALUE;
    private static final long DEFAULT_SYNC_SCAN_INTERVAL = 86400000L;
    private static final String SYNC_INTERVAL_SUBFIX = "syncScan";
    private static final String DEFAULT_INTERVAL_SUBFIX = "defaultScan";
    private static final String STORAGE_PREFIX = "runtimeautodiscovery";
    private static final String STORAGE_KEYLIST = "runtimeAD-keylist";
    private static final String SERVICE_PREFIX = "service-config";
    private static final String SERVICE_KEYLIST = "service-keylist";
    private static Log _log = LogFactory.getLog(RuntimeAutodiscoverer.class);
    private final AutoinventoryCommandsServer _aicmd;
    private final AgentDaemon _agent;
    private final AutoinventoryCallbackClient _client;
    private final SyncModeManager syncModeManager;
    private final ConfigStorage _storage;
    private final ConfigStorage _serviceStorage;
    private long _currentScanInterval;
    private final long _normalScanInterval;
    private long _currentDefaultScanInterval;
    private final long _normalDefaultScanInterval;
    private volatile boolean _isRuntimeScanning = false;
    private volatile Map<ConfigStorage.Key, ConfigResponse> _insertsDuringScan = new HashMap<ConfigStorage.Key, ConfigResponse>();
    private final AtomicReference<CompositeRuntimeResourceReport> _lastReport = new AtomicReference();
    private final AtomicBoolean _writeLastReportDiag = new AtomicBoolean(true);

    public RuntimeAutodiscoverer(AutoinventoryCommandsServer aicmd, AgentStorageProvider storageProvider, AgentDaemon agent, AutoinventoryCallbackClient client) {
        AgentDiagnostics.getInstance().addDiagnostic((AgentDiagnosticObject)this);
        this._aicmd = aicmd;
        this._storage = new ConfigStorage(storageProvider, STORAGE_KEYLIST, STORAGE_PREFIX);
        this._serviceStorage = new ConfigStorage(storageProvider, SERVICE_KEYLIST, SERVICE_PREFIX);
        this._agent = agent;
        this._client = client;
        this._normalScanInterval = Long.MAX_VALUE;
        this.triggerScan();
        this._normalDefaultScanInterval = this.loadScanInterval(DEFAULT_INTERVAL_SUBFIX);
        this.syncModeManager = agent.getSyncModeManager();
        boolean readNextSyncScanTimeFromStorage = this.syncModeManager.initSyncScanFromStorage(this.loadScanInterval(SYNC_INTERVAL_SUBFIX));
        if (readNextSyncScanTimeFromStorage) {
            this.sendPluginStatusToServer(true);
        }
        this.triggerDefaultScan();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateConfig(AgentRemoteValue args) throws AgentRemoteException {
        block7: {
            int type = Integer.parseInt(args.getValue("entity.type"));
            ConfigStorage configStorage = type == 3 ? this._serviceStorage : this._storage;
            ConfigStorage.Key key = configStorage.getKey(args);
            boolean isEnable = args.getValue("disable.rtad") == null;
            try {
                this._lastReport.set(null);
                if (isEnable) {
                    ConfigResponse config = configStorage.put(key, args);
                    if (this._isRuntimeScanning) {
                        _log.debug((Object)("Scan running while storing config for: " + key));
                        Map<ConfigStorage.Key, ConfigResponse> map = this._insertsDuringScan;
                        synchronized (map) {
                            this._insertsDuringScan.put(key, config);
                            break block7;
                        }
                    }
                    _log.debug((Object)("Triggering scan after storing config for: " + key));
                    this.triggerScan();
                    break block7;
                }
                configStorage.remove(key);
            }
            catch (AgentStorageException e) {
                String method = isEnable ? "store" : "remove";
                String msg = "Failed to " + method + " config for " + key + ": " + (Object)((Object)e);
                throw new AgentRemoteException(msg, (Exception)((Object)e));
            }
        }
    }

    public long getScanInterval() {
        return this._currentScanInterval;
    }

    public long getDefaultScanInterval() {
        return this._currentDefaultScanInterval;
    }

    public void triggerScan() {
        this._currentScanInterval = 5000L;
    }

    public void triggerDefaultScan() {
        this._currentDefaultScanInterval = 5000L;
    }

    public void scheduleDefaultScan() {
        this.scheduleDefaultScan(false);
    }

    public void scheduleDefaultSyncScan() {
        this.syncModeManager.tickNextSyncScanTime();
        this.scheduleDefaultScan(true);
        this.sendPluginStatusToServer(true);
    }

    private void scheduleDefaultScan(boolean isSyncScan) {
        if (isSyncScan) {
            this._aicmd.scheduleDefaultSyncScan();
        } else {
            this._aicmd.scheduleDefaultScan();
        }
        this._currentDefaultScanInterval = this._normalDefaultScanInterval;
    }

    public void doRuntimeSyncScan() throws AutoinventoryException {
        this.doRuntimeScan(true);
    }

    public void doRuntimeScan() throws AutoinventoryException {
        this.doRuntimeScan(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRuntimeScan(boolean isSyncScan) throws AutoinventoryException {
        Map configs = this._storage.load();
        boolean bl = this._isRuntimeScanning = configs.size() > 0;
        while (this._isRuntimeScanning) {
            try {
                this.doRuntimeScan_internal(configs, isSyncScan);
            }
            catch (AgentRunningException e) {
                throw new IllegalStateException("Agent not running?", e);
            }
            catch (PluginException e) {
                throw new IllegalStateException("Error getting plugin managers.", e);
            }
            Map<ConfigStorage.Key, ConfigResponse> map = this._insertsDuringScan;
            synchronized (map) {
                int size = this._insertsDuringScan.size();
                if (size == 0) {
                    this._isRuntimeScanning = false;
                    break;
                }
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Processing " + size + " configs inserted while scan was running"));
                }
                configs.clear();
                configs.putAll(this._insertsDuringScan);
                this._insertsDuringScan.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRuntimeScan_internal(Map<ConfigStorage.Key, ConfigResponse> configs, boolean isSyncScan) throws AutoinventoryException, AgentRunningException, PluginException {
        Map serviceConfigs = this._serviceStorage.load();
        for (Map.Entry entry : serviceConfigs.entrySet()) {
            ConfigStorage.Key key = (ConfigStorage.Key)entry.getKey();
            ConfigResponse config = (ConfigResponse)entry.getValue();
            String type = key.getTypeName();
            AgentDaemon.getMainInstance().getAutoinventoryPluginManager().addServiceConfig(type, config);
        }
        CompositeRuntimeResourceReport compositeReport = new CompositeRuntimeResourceReport();
        compositeReport.setIsSyncScan(isSyncScan);
        for (Map.Entry<ConfigStorage.Key, ConfigResponse> entry : configs.entrySet()) {
            ServerDetector detector;
            ConfigStorage.Key key = entry.getKey();
            ConfigResponse config = entry.getValue();
            String type = key.getTypeName();
            try {
                detector = (ServerDetector)AgentDaemon.getMainInstance().getAutoinventoryPluginManager().getPlugin(type);
            }
            catch (PluginNotFoundException e) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Plugin does not support server detection: " + type), (Throwable)e);
                continue;
            }
            if (!detector.isRuntimeDiscoverySupported()) {
                if (!_log.isDebugEnabled()) continue;
                _log.debug((Object)("Plugin does not support runtime discovery: " + type));
                continue;
            }
            PluginLoader.setClassLoader((Object)detector);
            try {
                RuntimeDiscoverer discoverer = detector.getRuntimeDiscoverer();
                _log.info((Object)("Running runtime autodiscovery for " + type));
                PlatformResource platform = Scanner.detectPlatform((AutoinventoryPluginManager)AgentDaemon.getMainInstance().getAutoinventoryPluginManager(), (ConfigResponse)config);
                StopWatch timer = new StopWatch();
                RuntimeResourceReport report = discoverer.discoverResources(key.getId(), (AIPlatformValue)platform, config);
                _log.info((Object)(key.getTypeName() + " discovery took " + timer));
                compositeReport.addServerReport(report);
            }
            catch (Exception e) {
                _log.error((Object)("Unexpected error running autodiscoverer for plugin: " + type + ": " + e), (Throwable)e);
            }
            catch (NoClassDefFoundError e) {
                _log.error((Object)("Unable to run autodiscoverer for plugin: " + type + " (consult product setup help): " + e), (Throwable)e);
                _log.debug((Object)("Current ClassLoader=" + PluginLoader.getClassLoader()));
            }
            finally {
                PluginLoader.resetClassLoader((Object)detector);
            }
        }
        compositeReport = this.loadReportFilter().filterReport(compositeReport);
        if (!isSyncScan && compositeReport.isSameReport(this._lastReport.get())) {
            _log.debug((Object)"No changes detected, not sending runtime report, because agent not in sync mode.");
            this._writeLastReportDiag.set(false);
        } else {
            String errMsg = "Error sending runtime report to server: ";
            this._lastReport.set(compositeReport);
            this._writeLastReportDiag.set(true);
            try {
                if (_log.isDebugEnabled()) {
                    _log.debug((Object)("Sending RuntimeReport: " + compositeReport.simpleSummary()));
                }
                this._client.aiSendRuntimeReport(compositeReport);
            }
            catch (Exception e) {
                _log.error((Object)("Error sending runtime report to server: " + e), (Throwable)e);
            }
        }
        this._currentScanInterval = this._normalScanInterval;
    }

    private long loadScanInterval(String type) {
        String prop;
        Properties bootProps = this._agent.getBootConfig().getBootProperties();
        String value = bootProps.getProperty(prop = "autoinventory." + type + ".interval.millis");
        long interval = value == null ? (SYNC_INTERVAL_SUBFIX.equals(type) ? 86400000L : 900000L) : PropertiesUtil.getLongValue((String)prop, (String)value);
        if (interval == -1L) {
            interval = Long.MAX_VALUE;
        }
        _log.debug((Object)(type + " scan interval is " + interval));
        return interval;
    }

    private RuntimeReportFilter loadReportFilter() {
        RuntimeReportFilter defaultFilter = new RuntimeReportFilter(){

            public CompositeRuntimeResourceReport filterReport(CompositeRuntimeResourceReport r) {
                return r;
            }
        };
        String val = this._agent.getBootConfig().getBootProperties().getProperty("autoinventory.reportFilter");
        if (val == null) {
            return defaultFilter;
        }
        try {
            Class<?> c = Class.forName(val);
            return (RuntimeReportFilter)c.newInstance();
        }
        catch (Throwable t) {
            _log.error((Object)("Unable to create autoinventory.reportFilter [" + val + "], using default"), t);
            return defaultFilter;
        }
    }

    public String getDiagStatus() {
        if (!this._writeLastReportDiag.get() || this._lastReport.get() == null) {
            return "Discovery report has not changed";
        }
        this._writeLastReportDiag.set(false);
        return this._lastReport.get().fullSummary();
    }

    public String getDiagName() {
        return "Runtime Report Diagnostic";
    }

    private void sendPluginStatusToServer(boolean resyncAgentPlugins) {
        this._agent.sendPluginStatusToServer(resyncAgentPlugins);
    }
}

