/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.plugin.system;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.product.Collector;

public class OtherUnixCollector
extends Collector {
    private static final Log log = LogFactory.getLog(OtherUnixCollector.class);
    private static final String[] VMSTAT = new String[]{"vmstat", "-s"};
    private static final String[][] METRICS = new String[][]{{"pgfault", "minor (as) faults"}, {"pgmajfault", "major faults"}, {"pgfault", "total address trans. faults"}, {"pgmajfault", "executable filled pages faults"}, {"pgfault", "total address trans. faults taken"}, {"pgmajfault", "executable fill page faults"}};

    public void collect() {
        log.info((Object)"[collect]");
        try {
            Process cmd = Runtime.getRuntime().exec(VMSTAT);
            cmd.waitFor();
            if (cmd.exitValue() != 0) {
                String msg = OtherUnixCollector.inputStreamAsString(cmd.getErrorStream());
                log.info((Object)("[collect] cmd error: " + msg));
                this.setErrorMessage(msg);
            } else {
                Map<String, Double> stats = OtherUnixCollector.parseVMStat(cmd.getInputStream());
                for (String[] metric : METRICS) {
                    Double val = stats.get(metric[1]);
                    log.info((Object)("[collect] " + metric[0] + "=" + val));
                    if (val == null) continue;
                    this.setValue(metric[0], val);
                }
            }
        }
        catch (IOException e) {
            log.info((Object)("[collect] error: " + e.getMessage()), (Throwable)e);
            this.setErrorMessage(e.getLocalizedMessage(), e);
        }
        catch (InterruptedException e) {
            log.info((Object)("[collect] error: " + e.getMessage()), (Throwable)e);
            this.setErrorMessage(e.getLocalizedMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final Map<String, Double> parseVMStat(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        HashMap<String, Double> res = new HashMap<String, Double>();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                line = line.trim();
                int sep = line.indexOf(" ");
                log.info((Object)("[parseVMStat] line='" + line + "' (" + sep + ")"));
                if (sep <= 0) continue;
                String key = line.substring(sep).trim();
                String val = line.substring(0, sep).trim();
                log.info((Object)("[parseVMStat] " + key + " = " + val));
                res.put(key, Double.parseDouble(val));
            }
        }
        finally {
            br.close();
        }
        return res;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final String inputStreamAsString(InputStream stream) throws IOException {
        BufferedReader br = new BufferedReader(new InputStreamReader(stream));
        StringBuilder sb = new StringBuilder();
        try {
            String line;
            while ((line = br.readLine()) != null) {
                sb.append(line).append("\n");
            }
        }
        finally {
            br.close();
        }
        return sb.toString();
    }
}

