/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.agent;

import java.io.Externalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.commons.lang.StringUtils;

public class FileMetadata
implements Externalizable {
    private String sourceFileUri;
    private String destFileRelativePath;
    private String md5sum;

    public FileMetadata() {
    }

    public FileMetadata(String sourceFileURI, String destFileRelativePath, String md5sum) {
        if (StringUtils.isBlank((String)sourceFileURI) || StringUtils.isBlank((String)destFileRelativePath) || StringUtils.isBlank((String)md5sum)) {
            throw new NullPointerException("Source or destination location is empty, whitespace or null");
        }
        this.sourceFileUri = sourceFileURI;
        this.destFileRelativePath = destFileRelativePath;
        this.md5sum = md5sum;
    }

    public String getSourceFileUri() {
        return this.sourceFileUri;
    }

    public String getDestFileRelativePath() {
        return this.destFileRelativePath;
    }

    public String getMD5CheckSum() {
        return this.md5sum;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.sourceFileUri = in.readUTF();
        this.destFileRelativePath = in.readUTF();
        this.md5sum = in.readUTF();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeUTF(this.sourceFileUri);
        out.writeUTF(this.destFileRelativePath);
        out.writeUTF(this.md5sum);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("File metadata of:\n");
        sb.append(this.sourceFileUri);
        sb.append("\n\twith md5: ");
        sb.append(this.md5sum);
        sb.append("\n\t dest. path: ");
        sb.append(this.destFileRelativePath);
        return sb.toString();
    }
}

