/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.units;

import java.math.BigDecimal;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Arrays;
import java.util.Locale;
import org.hyperic.util.ArrayUtil;
import org.hyperic.util.units.UnitsConstants;

class UnitsUtil
implements UnitsConstants {
    static final BigDecimal FACT_NONE = new BigDecimal(Integer.toString(1));
    static final BigDecimal FACT_BIT = new BigDecimal(0.125);
    static final BigDecimal FACT_KILO_BIN = new BigDecimal(Integer.toString(1024));
    static final BigDecimal FACT_MEGA_BIN = FACT_KILO_BIN.multiply(FACT_KILO_BIN);
    static final BigDecimal FACT_GIGA_BIN = FACT_MEGA_BIN.multiply(FACT_KILO_BIN);
    static final BigDecimal FACT_TERA_BIN = FACT_GIGA_BIN.multiply(FACT_KILO_BIN);
    static final BigDecimal FACT_PETA_BIN = FACT_TERA_BIN.multiply(FACT_KILO_BIN);
    static final BigDecimal FACT_NANOS = new BigDecimal(Integer.toString(1));
    static final BigDecimal FACT_MICROS = new BigDecimal(Integer.toString(1000));
    static final BigDecimal FACT_MILLIS = new BigDecimal(Integer.toString(1000000));
    static final BigDecimal FACT_JIFFYS = new BigDecimal(Integer.toString(10000000));
    static final BigDecimal FACT_SECS = FACT_MILLIS.multiply(new BigDecimal(Integer.toString(1000)));
    static final BigDecimal FACT_MINS = FACT_SECS.multiply(new BigDecimal(Integer.toString(60)));
    static final BigDecimal FACT_HOURS = FACT_MINS.multiply(new BigDecimal(Integer.toString(60)));
    static final BigDecimal FACT_DAYS = FACT_HOURS.multiply(new BigDecimal(Integer.toString(24)));
    static final BigDecimal FACT_WEEKS = FACT_DAYS.multiply(new BigDecimal(Integer.toString(7)));
    static final BigDecimal FACT_YEARS = FACT_DAYS.multiply(new BigDecimal(Integer.toString(365)));

    UnitsUtil() {
    }

    static void checkValidUnits(int unit) {
        if (unit < 0 || unit >= 10) {
            throw new IllegalArgumentException("Invalid units specified");
        }
    }

    static void checkValidScale(int scale) {
        if (scale < 0 || scale > 16) {
            throw new IllegalArgumentException("Invalid scale specified");
        }
    }

    static void checkValidScaleForUnits(int unit, int scale) {
        if (scale == 0 || unit == 3 && scale == 16 || (unit == 2 || unit == 3 || unit == 9) && scale >= 1 && scale <= 5 || (unit == 4 || unit == 5 || unit == 8) && scale >= 6 && scale <= 15 || unit == 6 && scale != 0 || unit == 0 && scale != 0) {
            return;
        }
        throw new IllegalArgumentException("Scale is not valid for the specified units");
    }

    static int findNonNumberIdx(String val, NumberFormat fmt) {
        ParsePosition pos = new ParsePosition(0);
        fmt.parse(val, pos);
        if (pos.getIndex() == val.length()) {
            return -1;
        }
        return pos.getIndex();
    }

    public static NumberFormat getNumberFormat(double[] inValues, Locale locale) {
        NumberFormat res = NumberFormat.getInstance(locale);
        double[] values = new double[inValues.length];
        System.arraycopy(inValues, 0, values, 0, inValues.length);
        Arrays.sort(values);
        values = ArrayUtil.uniq(values);
        if (values.length < 2) {
            res.setMinimumFractionDigits(1);
            res.setMaximumFractionDigits(1);
            return res;
        }
        Object[] sValues = new String[values.length];
        for (int numDigits = 0; numDigits < 9; ++numDigits) {
            res.setMinimumFractionDigits(numDigits);
            res.setMaximumFractionDigits(numDigits);
            for (int i = 0; i < sValues.length; ++i) {
                sValues[i] = res.format(values[i]);
            }
            Arrays.sort(sValues);
            if (ArrayUtil.isUniq((String[])sValues)) break;
        }
        return res;
    }

    public static int getUniqueDigits(double[] inValues, Locale locale) {
        return UnitsUtil.getNumberFormat(inValues, locale).getMaximumFractionDigits();
    }
}

