/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.jmx;

import org.hyperic.sigar.ProcCpu;
import org.hyperic.sigar.ProcDiskIO;
import org.hyperic.sigar.ProcFd;
import org.hyperic.sigar.ProcMem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.SigarProxy;
import org.hyperic.sigar.SigarProxyCache;
import org.hyperic.sigar.jmx.SigarProcessMBean;

public class SigarProcess
implements SigarProcessMBean {
    private static final Long NOTIMPL = new Long(-1L);
    private Sigar sigarImpl;
    private SigarProxy sigar;
    private long pid = -1L;

    public SigarProcess() {
        this.sigarImpl = new Sigar();
        this.sigar = SigarProxyCache.newInstance(this.sigarImpl);
    }

    public SigarProcess(SigarProxy sigar) {
        this.sigar = sigar;
    }

    public void close() {
        if (this.sigarImpl != null) {
            this.sigarImpl.close();
        }
    }

    private RuntimeException unexpectedError(String type, SigarException e) {
        String msg = "Unexected error in Sigar.get" + type + ": " + e.getMessage();
        return new IllegalArgumentException(msg);
    }

    private synchronized ProcMem getMem() {
        try {
            return this.sigar.getProcMem(this.getPid());
        }
        catch (SigarException e) {
            throw this.unexpectedError("Mem", e);
        }
    }

    private synchronized ProcCpu getCpu() {
        try {
            return this.sigar.getProcCpu(this.getPid());
        }
        catch (SigarException e) {
            throw this.unexpectedError("Cpu", e);
        }
    }

    private synchronized ProcDiskIO getDiskIO() {
        try {
            return this.sigar.getProcDiskIO(this.getPid());
        }
        catch (SigarException e) {
            throw this.unexpectedError("DiskIO", e);
        }
    }

    private synchronized ProcFd getFd() throws SigarException {
        return this.sigar.getProcFd(this.getPid());
    }

    public long getPid() {
        if (this.pid < 0L) {
            return this.sigar.getPid();
        }
        return this.pid;
    }

    public void setPid(long pid) {
        this.pid = pid;
    }

    public Long getMemSize() {
        return new Long(this.getMem().getSize());
    }

    public Long getMemVsize() {
        return this.getMemSize();
    }

    public Long getMemResident() {
        return new Long(this.getMem().getResident());
    }

    public Long getMemShare() {
        return new Long(this.getMem().getShare());
    }

    public Long getMemPageFaults() {
        return new Long(this.getMem().getPageFaults());
    }

    public Long getTimeUser() {
        return new Long(this.getCpu().getUser());
    }

    public Long getTimeSys() {
        return new Long(this.getCpu().getSys());
    }

    public Double getCpuUsage() {
        return new Double(this.getCpu().getPercent());
    }

    public Long getOpenFd() {
        try {
            return new Long(this.getFd().getTotal());
        }
        catch (SigarException e) {
            return NOTIMPL;
        }
    }

    public static void main(String[] args) {
        SigarProcess proc = new SigarProcess();
        System.out.println("MemSize=" + proc.getMemSize());
        System.out.println("MemResident=" + proc.getMemResident());
        System.out.println("MemShared=" + proc.getMemShare());
        System.out.println("MemPageFaults=" + proc.getMemPageFaults());
        System.out.println("TimeUser=" + proc.getTimeUser());
        System.out.println("TimeSys=" + proc.getTimeSys());
        System.out.println("OpenFd=" + proc.getOpenFd());
    }

    public Double getBytesReadWriteTotal() {
        return new Double(this.getDiskIO().getBytesTotal());
    }
}

