/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.http;

import java.io.IOException;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.entity.BufferedHttpEntity;
import org.apache.http.util.EntityUtils;
import org.hyperic.util.http.AgentRequest;
import org.hyperic.util.http.CommunicationConfiguration;
import org.hyperic.util.http.HQHttpClient;
import org.hyperic.util.timer.StopWatch;

public class Server {
    private static final String UNAUTHORIZED_AGENT_DENIED_ERROR_MSG = "Unauthorized agent denied";
    private static final String LATHER_ERROR_HEADER = "X-error-response";
    private static final Set<Integer> SERVER_NOT_REACHABLE_HTTP_CODES;
    private long lastSuccessTimestamp;
    private final InetAddress ipAddress;
    private boolean isDown = false;
    private StopWatch downPeriodWatch;
    private long downPeriod;
    private long failPeriod;
    private Random random = null;
    private int downPeriodInterval;
    private int minDownPeriodIntervalInMin = 5;
    private HQHttpClient client = null;
    private static final Log logger;

    public Server(InetAddress ipAddress, HQHttpClient client, CommunicationConfiguration config) {
        this.ipAddress = ipAddress;
        this.client = client;
        this.lastSuccessTimestamp = System.currentTimeMillis();
        this.downPeriodWatch = new StopWatch();
        this.failPeriod = TimeUnit.MINUTES.toMillis(config.getFailPeriodInMin());
        this.downPeriodInterval = config.getDownPeriodIntervalInMin();
        try {
            this.random = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            this.random = new SecureRandom();
        }
    }

    public boolean isAvailable() {
        if (this.isDown) {
            return this.isDownTimeElapsed();
        }
        return this.isServerAccessible();
    }

    private boolean isServerAccessible() {
        if (System.currentTimeMillis() >= this.lastSuccessTimestamp + this.failPeriod) {
            this.isDown = true;
            this.downPeriod = this.getDownPeriod();
            this.downPeriodWatch.reset();
            logger.error((Object)("Server is not available for a period of " + TimeUnit.MILLISECONDS.toMinutes(this.failPeriod) + " minutes -  Mark " + this + " as down for a period of " + TimeUnit.MILLISECONDS.toMinutes(this.downPeriod) + " minutes"));
            return false;
        }
        return true;
    }

    public long getDownPeriod() {
        int downPeriodInMin = this.random.nextInt(this.downPeriodInterval) + this.minDownPeriodIntervalInMin;
        return TimeUnit.MINUTES.toMillis(downPeriodInMin);
    }

    private boolean isDownTimeElapsed() {
        if (this.downPeriodWatch.getElapsed() < this.downPeriod) {
            return false;
        }
        this.isDown = false;
        logger.info((Object)("Down period end - wake up server " + this));
        return true;
    }

    private String buildUrl(String originalUrl) throws MalformedURLException {
        URL notResolvedUrl = new URL(originalUrl);
        URL newUrl = new URL(notResolvedUrl.getProtocol(), this.ipAddress.getHostAddress(), notResolvedUrl.getPort(), notResolvedUrl.getFile());
        return newUrl.toString();
    }

    public HttpResponse send(AgentRequest request) throws ClientProtocolException, IOException {
        String resolvedUrl = this.buildUrl(request.getUrl());
        HttpResponse response = null;
        switch (request.getMethod()) {
            case GET: {
                response = this.client.get(resolvedUrl, request.getHeaders());
                break;
            }
            case POST: {
                response = this.client.post(resolvedUrl, request.getHeaders(), request.getParams());
                break;
            }
            default: {
                throw new IOException("Request Method " + (Object)((Object)request.getMethod()) + " is not supported");
            }
        }
        if (response == null || response.getStatusLine() == null) {
            throw new IOException(request.getUrl() + " is not reachable");
        }
        if (SERVER_NOT_REACHABLE_HTTP_CODES.contains(response.getStatusLine().getStatusCode())) {
            EntityUtils.consume((HttpEntity)response.getEntity());
            throw new IOException(response.getStatusLine().getReasonPhrase());
        }
        if (this.isAgentUnauthorized(response)) {
            String msg = String.format("Unable to invoke method '%s'. Unauthorized agent.", new Object[]{request.getMethod()});
            throw new IOException(msg);
        }
        this.lastSuccessTimestamp = System.currentTimeMillis();
        this.isDown = false;
        return response;
    }

    private boolean isAgentUnauthorized(HttpResponse response) throws IOException {
        if (response == null || response.getStatusLine().getStatusCode() != 200) {
            return false;
        }
        Header errHeader = response.getFirstHeader(LATHER_ERROR_HEADER);
        if (errHeader == null) {
            return false;
        }
        BufferedHttpEntity bufferedEntity = new BufferedHttpEntity(response.getEntity());
        response.setEntity((HttpEntity)bufferedEntity);
        String responseBody = EntityUtils.toString((HttpEntity)bufferedEntity);
        return responseBody.contains(UNAUTHORIZED_AGENT_DENIED_ERROR_MSG);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("Server[").append("IP:").append(this.ipAddress.getHostAddress()).append("  ").append("isDown:").append(this.isDown).append("  ").append("lastSuccess:").append(new Date(this.lastSuccessTimestamp)).append("  ").append("]");
        return sb.toString();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Server other = (Server)obj;
        return !(this.ipAddress == null ? other.ipAddress != null : !this.ipAddress.equals(other.ipAddress));
    }

    static {
        HashSet<Integer> serverNotReachableHttpCodes = new HashSet<Integer>();
        serverNotReachableHttpCodes.add(503);
        serverNotReachableHttpCodes.add(404);
        SERVER_NOT_REACHABLE_HTTP_CODES = Collections.unmodifiableSet(serverNotReachableHttpCodes);
        logger = LogFactory.getLog(Server.class);
    }
}

