/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.autoinventory;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import org.hyperic.hq.autoinventory.AutoinventoryException;
import org.hyperic.hq.autoinventory.ScanConfigurationCore;
import org.hyperic.hq.autoinventory.ScanStateCore;
import org.hyperic.hq.bizapp.shared.lather.ScanConfigurationCoreValue;
import org.hyperic.hq.bizapp.shared.lather.ScanStateCoreLatherValue;
import org.hyperic.lather.LatherValue;
import org.hyperic.lather.xcode.LatherXCoder;
import org.hyperic.util.encoding.Base64;

public class LatherUtil {
    public static byte[] serialize(LatherValue value) throws IOException {
        LatherXCoder xCoder = new LatherXCoder();
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        try {
            xCoder.encode(value, dOs);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
        return bOs.toByteArray();
    }

    public static String encode(LatherValue value) throws IOException {
        return Base64.encode((byte[])LatherUtil.serialize(value));
    }

    public static LatherValue deserialize(byte[] value, Class resClass) throws IOException {
        LatherXCoder xCoder = new LatherXCoder();
        ByteArrayInputStream bIs = new ByteArrayInputStream(value);
        DataInputStream dIs = new DataInputStream(bIs);
        try {
            return xCoder.decode(dIs, resClass);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new IOException(e.getMessage());
        }
    }

    public static LatherValue decode(String value, Class resClass) throws IOException {
        return LatherUtil.deserialize(Base64.decode((String)value), resClass);
    }

    static byte[] serialize(ScanConfigurationCore core) throws AutoinventoryException {
        try {
            ScanConfigurationCoreValue value = new ScanConfigurationCoreValue(core);
            return LatherUtil.serialize(value);
        }
        catch (Exception e) {
            String msg = "Error writing ScanConfiguration: " + e.getMessage();
            throw new AutoinventoryException(msg, e);
        }
    }

    static ScanConfigurationCore deserializeScanConfigurationCore(byte[] data) throws AutoinventoryException {
        try {
            ScanConfigurationCoreValue value = (ScanConfigurationCoreValue)LatherUtil.deserialize(data, ScanConfigurationCoreValue.class);
            return value.getCore();
        }
        catch (Exception e) {
            String msg = "Error reading ScanConfiguration: " + e.getMessage();
            throw new AutoinventoryException(msg, e);
        }
    }

    static String encode(ScanStateCore core) throws AutoinventoryException {
        ScanStateCoreLatherValue value = new ScanStateCoreLatherValue(core);
        try {
            return LatherUtil.encode(value);
        }
        catch (IOException e) {
            throw new AutoinventoryException("Error writing ScanState", e);
        }
    }

    static ScanStateCore decodeScanStateCore(String data) throws AutoinventoryException {
        ScanStateCoreLatherValue value;
        try {
            value = (ScanStateCoreLatherValue)LatherUtil.decode(data, ScanStateCoreLatherValue.class);
        }
        catch (IOException e) {
            throw new AutoinventoryException("Error reading ScanState", e);
        }
        return value.getScanStateCore();
    }
}

