/*
 * Decompiled with CFR 0.152.
 */
package org.snmp4j.log;

import java.util.Collections;
import java.util.Iterator;
import org.snmp4j.log.LogAdapter;
import org.snmp4j.log.LogLevel;

public class ConsoleLogAdapter
implements LogAdapter {
    private static boolean debugEnabled = false;
    private static boolean infoEnabled = true;
    private static boolean warnEnabled = true;

    public void debug(Object message) {
        if (debugEnabled) {
            System.out.println(message.toString());
        }
    }

    public void error(Object message) {
        System.err.println(message.toString());
    }

    public void error(Object message, Throwable throwable) {
        System.err.println(message.toString());
    }

    public void fatal(Object message) {
        System.err.println(message.toString());
    }

    public void fatal(Object message, Throwable throwable) {
        System.err.println(message.toString());
    }

    public void info(Object message) {
        if (infoEnabled) {
            System.out.println(message.toString());
        }
    }

    public boolean isDebugEnabled() {
        return debugEnabled;
    }

    public boolean isInfoEnabled() {
        return infoEnabled;
    }

    public boolean isWarnEnabled() {
        return warnEnabled;
    }

    public void warn(Object message) {
        if (warnEnabled) {
            System.out.println(message.toString());
        }
    }

    public static void setDebugEnabled(boolean isDebugEnabled) {
        debugEnabled = isDebugEnabled;
    }

    public static void setWarnEnabled(boolean isWarnEnabled) {
        warnEnabled = isWarnEnabled;
    }

    public static void setInfoEnabled(boolean isInfoEnabled) {
        infoEnabled = isInfoEnabled;
    }

    public void setLogLevel(LogLevel level) {
        debugEnabled = false;
        warnEnabled = false;
        infoEnabled = false;
        switch (level.getLevel()) {
            case 2: {
                debugEnabled = true;
                warnEnabled = true;
                infoEnabled = true;
                break;
            }
            case 3: 
            case 4: {
                debugEnabled = true;
                break;
            }
            case 5: {
                infoEnabled = true;
                break;
            }
            case 6: {
                warnEnabled = true;
                break;
            }
        }
    }

    public String getName() {
        return "";
    }

    public LogLevel getLogLevel() {
        if (debugEnabled) {
            return LogLevel.DEBUG;
        }
        if (infoEnabled) {
            return LogLevel.INFO;
        }
        if (warnEnabled) {
            return LogLevel.WARN;
        }
        return LogLevel.OFF;
    }

    public LogLevel getEffectiveLogLevel() {
        return this.getLogLevel();
    }

    public Iterator getLogHandler() {
        return Collections.EMPTY_LIST.iterator();
    }
}

