/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.pluginxml;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.measurement.MeasurementConstants;
import org.hyperic.hq.product.MeasurementInfo;
import org.hyperic.hq.product.Metric;
import org.hyperic.hq.product.pluginxml.BaseTag;
import org.hyperic.hq.product.pluginxml.MetricsTag;
import org.hyperic.hq.product.pluginxml.ResourceTag;
import org.hyperic.util.filter.TokenReplacer;
import org.hyperic.util.xmlparser.XmlAttrException;
import org.hyperic.util.xmlparser.XmlEndAttrHandler;
import org.hyperic.util.xmlparser.XmlUnAttrHandler;

class MetricTag
extends BaseTag
implements XmlEndAttrHandler,
XmlUnAttrHandler {
    private static final Log log = LogFactory.getLog(MetricTag.class);
    private static final Set VALID_UNITS = new HashSet<String>(Arrays.asList(MeasurementConstants.VALID_UNITS));
    private static final Set VALID_CATEGORIES = new HashSet<String>(Arrays.asList(MeasurementConstants.VALID_CATEGORIES));
    private static final String[] REQUIRED_ATTRS = new String[0];
    private static final String ATTR_ALIAS = "alias";
    private static final String ATTR_CAT = "category";
    private static final String ATTR_DEFAULTON = "defaultOn";
    private static final String ATTR_INDICATOR = "indicator";
    private static final String ATTR_TYPE = "collectionType";
    private static final String ATTR_UNITS = "units";
    private static final String ATTR_INTERVAL = "interval";
    private static final String ATTR_GROUP = "group";
    private static final String ATTR_RATE = "rate";
    private static final String ATTR_TEMPLATE = "template";
    private static final String[] OPTIONAL_ATTRS = new String[]{"name", "alias", "category", "defaultOn", "indicator", "collectionType", "units", "interval", "group", "rate", "template"};
    private String metricsName;
    private TokenReplacer replacer = new TokenReplacer();

    private void addFilter(String key) {
        String val = this.getAttribute(key);
        if (val != null) {
            this.replacer.addFilter(key, val);
        }
    }

    MetricTag(BaseTag parent) {
        super(parent);
    }

    @Override
    public String getName() {
        return "metric";
    }

    @Override
    public String[] getOptionalAttributes() {
        return OPTIONAL_ATTRS;
    }

    @Override
    public String[] getRequiredAttributes() {
        return REQUIRED_ATTRS;
    }

    public void handleUnknownAttribute(String name, String value) {
        this.replacer.addFilter(name, Metric.encode(value));
    }

    private String filter(String val) {
        val = this.data.applyFilters(val);
        val = this.replacer.replaceTokens(val);
        return val;
    }

    private void filterAttribute(String attr) throws XmlAttrException {
        String val = this.getAttribute(attr);
        if (val == null) {
            val = this.data.getFilter(attr);
        }
        if (val == null && this.isResourceParent()) {
            String configName = ((ResourceTag)this.parent).configName;
            if (attr.equals(ATTR_TEMPLATE) && configName != null) {
                val = "${" + configName + ".template}:${alias}";
            }
        }
        if (val == null) {
            throw new XmlAttrException("Missing attribute: " + attr);
        }
        val = this.filter(val);
        this.props.put(attr, val);
    }

    public void endAttributes() throws XmlAttrException {
        if (!this.collectMetrics) {
            return;
        }
        this.metricsName = this.isResourceParent() ? ((ResourceTag)this.parent).typeName : ((MetricsTag)this.parent).metricsName;
        if (!this.collectMetrics) {
            return;
        }
        if (this.isSet(ATTR_ALIAS)) {
            this.addFilter(ATTR_ALIAS);
        }
        this.filterAttribute("name");
        this.addFilter("name");
        if (this.notSet(ATTR_ALIAS)) {
            String name = this.getAttribute("name");
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < name.length(); ++i) {
                char c = name.charAt(i);
                if (Character.isWhitespace(c)) continue;
                buf.append(c);
            }
            this.props.put(ATTR_ALIAS, buf.toString());
            this.addFilter(ATTR_ALIAS);
        }
        this.filterAttribute(ATTR_TEMPLATE);
        this.replacer.clear();
        this.data.addMetric(this.metricsName, this.createMetric());
    }

    private boolean notSet(String attr) {
        return this.getAttribute(attr) == null;
    }

    private boolean isSet(String attr) {
        return this.getAttribute(attr) != null;
    }

    private boolean isTrue(String attr) {
        return "true".equals(this.getAttribute(attr));
    }

    private MeasurementInfo createMetric() throws XmlAttrException {
        MeasurementInfo metric = new MeasurementInfo();
        try {
            metric.setAttributes(this.props);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
        }
        if (metric.getName().equals("Availability")) {
            if (this.notSet(ATTR_CAT)) {
                metric.setCategory("AVAILABILITY");
            }
            if (this.notSet(ATTR_UNITS)) {
                metric.setUnits("percentage");
            }
        } else {
            if (this.notSet(ATTR_UNITS)) {
                metric.setUnits("none");
            }
            if (this.notSet(ATTR_CAT)) {
                metric.setCategory("UTILIZATION");
            }
        }
        if (this.notSet(ATTR_TYPE)) {
            metric.setCollectionType(0);
        }
        if (this.isTrue(ATTR_INDICATOR) && this.notSet(ATTR_DEFAULTON)) {
            metric.setDefaultOn(true);
        }
        metric.setCategory(metric.getCategory().toUpperCase());
        try {
            this.validateMetric(metric);
        }
        catch (XmlAttrException e) {
            String msg = e.getMessage() + " (metric=" + this.props + ")";
            throw new XmlAttrException(msg);
        }
        return metric;
    }

    private XmlAttrException invalidAttr(String attr, String val) {
        return this.invalidAttr(attr, val, null);
    }

    private XmlAttrException invalidAttr(String attr, String val, String why) {
        String msg = "Invalid " + attr + "=\"" + val + "\"";
        if (why != null) {
            msg = msg + " - " + why;
        }
        return new XmlAttrException(msg);
    }

    private void validateMetric(MeasurementInfo metric) throws XmlAttrException {
        String units = metric.getUnits();
        String cat = metric.getCategory();
        String alias = metric.getAlias();
        String attrType = this.props.getProperty(ATTR_TYPE);
        int type = metric.getCollectionType();
        if (type == -1) {
            throw this.invalidAttr(ATTR_TYPE, attrType);
        }
        if (!VALID_UNITS.contains(units)) {
            throw this.invalidAttr(ATTR_UNITS, units);
        }
        if (!VALID_CATEGORIES.contains(cat)) {
            throw this.invalidAttr(ATTR_CAT, cat);
        }
        String reason = this.validateAlias(alias);
        if (reason != null) {
            throw this.invalidAttr(ATTR_ALIAS, alias, reason);
        }
        if (cat.equals("AVAILABILITY") && metric.isIndicator()) {
            reason = "Availability indicator with ";
            String expect = "Availability";
            String actual = alias;
            if (!expect.equals(actual)) {
                throw this.invalidAttr(ATTR_ALIAS, actual, reason + ATTR_ALIAS + " != " + expect);
            }
            expect = "percentage";
            actual = units;
            if (!expect.equals(actual)) {
                throw this.invalidAttr(ATTR_UNITS, actual, reason + ATTR_UNITS + " != " + expect);
            }
            int expectType = 0;
            expect = MeasurementConstants.COLL_TYPE_NAMES[expectType];
            actual = attrType;
            if (type != expectType) {
                throw this.invalidAttr(ATTR_TYPE, actual, reason + ATTR_TYPE + " != " + expect);
            }
        }
    }

    private String validateAlias(String alias) {
        int min = 3;
        int max = 100;
        if (alias.length() < 3) {
            return "< 3 chars";
        }
        if (alias.length() > 100) {
            return "> 100 chars";
        }
        return null;
    }
}

