/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.product.util;

import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.net.URLDecoder;
import java.util.Map;
import java.util.Properties;
import org.apache.log4j.PropertyConfigurator;
import org.hyperic.hq.product.ProductPlugin;
import org.hyperic.hq.product.ProductPluginManager;
import org.hyperic.hq.product.util.PluginDumper;
import org.hyperic.util.PluginLoader;

public class PluginMain {
    private static final String DEFAULT_PACKAGE = "org.hyperic.hq.plugin";
    private static final String[][] LOG_PROPS = new String[][]{{"log4j.appender.R", "org.apache.log4j.ConsoleAppender"}, {"log4j.appender.R.layout.ConversionPattern", "%-5p [%t] [%c{1}] %m%n"}, {"log4j.appender.R.layout", "org.apache.log4j.PatternLayout"}};

    private static URL jarURL(String jar) throws Exception {
        return new URL("jar", null, "file:" + jar + "!/");
    }

    private static URL[] getLibJars(String dir) throws Exception {
        File[] jars = new File(dir).listFiles(new FileFilter(){

            @Override
            public boolean accept(File file) {
                return file.getName().endsWith(".jar");
            }
        });
        if (jars == null) {
            return new URL[0];
        }
        URL[] urls = new URL[jars.length];
        for (int i = 0; i < jars.length; ++i) {
            urls[i] = PluginMain.jarURL(jars[i].getAbsolutePath());
        }
        return urls;
    }

    private static void addVersionFile(String pdkDir) throws Exception {
        File versionProperties = new File(pdkDir, "../lib");
        URL versionProps = versionProperties.toURI().toURL();
        PluginMain.addURLs(new URL[]{versionProps});
    }

    private static URLClassLoader getLoader() {
        return (URLClassLoader)Thread.currentThread().getContextClassLoader();
    }

    private static String getPdkDir() {
        URL[] urls = PluginMain.getLoader().getURLs();
        for (int i = 0; i < urls.length; ++i) {
            String url = urls[i].getFile();
            if (!url.contains("dcs-tools-pdk")) continue;
            url = URLDecoder.decode(url);
            return new File(url).getParentFile().getParent();
        }
        return "pdk";
    }

    private static void addURLs(URL[] jars) throws Exception {
        URLClassLoader loader = PluginMain.getLoader();
        Method addURL = URLClassLoader.class.getDeclaredMethod("addURL", URL.class);
        addURL.setAccessible(true);
        for (int i = 0; i < jars.length; ++i) {
            addURL.invoke((Object)loader, jars[i]);
        }
    }

    private static void addJarDir(String dir) throws Exception {
        URL[] jars = PluginMain.getLibJars(dir);
        PluginMain.addURLs(jars);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class getPluginClass(PluginDumper pd, String plugin, String className) throws Exception {
        pd.init();
        ProductPlugin productPlugin = pd.ppm.getProductPlugin(plugin);
        String packageName = productPlugin.getPluginProperty("package");
        if (packageName == null) {
            packageName = "org.hyperic.hq.plugin." + plugin;
        }
        String mainClass = packageName + "." + className;
        PluginLoader.setClassLoader((Object)productPlugin);
        try {
            Class<?> clazz = Class.forName(mainClass, true, productPlugin.getClass().getClassLoader());
            return clazz;
        }
        catch (ClassNotFoundException e) {
            System.out.println("Invalid ClassName: " + mainClass);
            Class clazz = null;
            return clazz;
        }
        finally {
            PluginLoader.resetClassLoader((Object)productPlugin);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void runMain(PluginDumper pd, String[] args) throws Exception {
        int offset;
        ProductPlugin productPlugin = null;
        String className = null;
        String mainClass = null;
        String usage = "Usage: PluginMain plugin ClassName";
        if (args.length < 1) {
            throw new IllegalArgumentException("Usage: PluginMain plugin ClassName");
        }
        String plugin = args[0];
        if (plugin.indexOf(".") != -1) {
            mainClass = plugin;
            plugin = null;
            offset = 1;
        } else {
            if (args.length < 2) {
                throw new IllegalArgumentException("Usage: PluginMain plugin ClassName");
            }
            className = args[1];
            offset = 2;
        }
        String[] pargs = new String[args.length - offset];
        System.arraycopy(args, offset, pargs, 0, args.length - offset);
        Class cmd = null;
        if (plugin != null) {
            cmd = PluginMain.getPluginClass(pd, plugin, className);
            if (cmd == null) {
                return;
            }
            productPlugin = pd.ppm.getProductPlugin(plugin);
        } else {
            try {
                cmd = Class.forName(mainClass);
            }
            catch (ClassNotFoundException e) {
                System.out.println("Invalid ClassName: " + mainClass);
                return;
            }
        }
        Method main = cmd.getMethod("main", String[].class);
        if (productPlugin != null) {
            PluginLoader.setClassLoader((Object)productPlugin);
        }
        try {
            main.invoke(null, new Object[]{pargs});
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (t instanceof NoClassDefFoundError) {
                System.out.println("Class Not Found: " + t.getMessage());
            } else {
                t.printStackTrace();
            }
        }
        finally {
            if (productPlugin != null) {
                PluginLoader.resetClassLoader((Object)productPlugin);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void configureLogging(String pdkDir, String level) {
        if (new File(level).exists()) {
            PropertyConfigurator.configure((String)level);
            return;
        }
        Properties props = new Properties();
        Properties agentProps = new Properties();
        File agentProperties = new File(pdkDir, "../../../conf/agent.properties");
        if (agentProperties.exists()) {
            FileInputStream is = null;
            try {
                is = new FileInputStream(agentProperties);
                agentProps.load(is);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (Exception exception) {}
                }
            }
        }
        for (String string : agentProps.keySet()) {
            if (!string.startsWith("log4j.logger.") && !string.startsWith("log4j.category.")) continue;
            props.setProperty(string, agentProps.getProperty(string));
        }
        props.setProperty("log4j.rootLogger", level.toUpperCase() + ", R");
        for (int i = 0; i < LOG_PROPS.length; ++i) {
            props.setProperty(LOG_PROPS[i][0], LOG_PROPS[i][1]);
        }
        props.putAll((Map<?, ?>)System.getProperties());
        PropertyConfigurator.configure((Properties)props);
    }

    public static void main(String[] args) throws Exception {
        String pdkDir = System.getProperty("agent.pdkDir", PluginMain.getPdkDir());
        File tmpDir = new File(new File(pdkDir).getParentFile(), "tmp");
        if (tmpDir.exists() && tmpDir.canWrite()) {
            System.setProperty("java.io.tmpdir", tmpDir.toString());
        }
        String pdkLib = pdkDir + File.separator + "lib";
        String logLevel = System.getProperty("log", "error");
        for (int i = 0; i < args.length; ++i) {
            if (!args[i].startsWith("-Dlog=")) continue;
            logLevel = args[i].substring(6);
        }
        PluginMain.addJarDir(pdkLib);
        PluginMain.addVersionFile(pdkDir);
        System.setProperty("org.hyperic.sigar.path", pdkLib);
        ProductPluginManager.setPdkDir(pdkDir);
        System.out.println("pdkDir = '" + pdkDir + "'");
        PluginMain.configureLogging(pdkDir, logLevel);
        PluginDumper pd = new PluginDumper(args);
        if (!pd.config.hasSwitches) {
            PluginMain.runMain(pd, pd.config.args);
        } else {
            pd.init();
            pd.invoke();
            pd.shutdown();
        }
        System.exit(0);
    }
}

