/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.hq.measurement.agent.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.hyperic.hq.agent.server.AgentStorageException;
import org.hyperic.hq.agent.server.AgentStorageProvider;
import org.hyperic.hq.appdef.shared.AppdefEntityID;
import org.hyperic.hq.measurement.agent.ScheduledMeasurement;
import org.hyperic.hq.measurement.server.session.SRN;
import org.hyperic.util.encoding.Base64;

class MeasurementSchedule {
    private static final String PROP_MSCHED = "measurement_schedule";
    private static final String PROP_MSRNS = "measurement_srn";
    private static final String PROP_MSRNS_LENGTH = "measurement_srn_length";
    private static final int MAX_ELEM_SIZE = 10000;
    private final AgentStorageProvider store;
    private final ArrayList<SRN> srnList = new ArrayList();
    private final Log log = LogFactory.getLog(MeasurementSchedule.class);

    MeasurementSchedule(AgentStorageProvider store, Properties bootProps) {
        String info = bootProps.getProperty(PROP_MSCHED);
        if (info != null) {
            store.addOverloadedInfo(PROP_MSCHED, info);
        }
        this.store = store;
        this.populateSRNInfo();
    }

    private void populateSRNInfo() {
        this.srnList.clear();
        String lengthBuf = this.store.getValue(PROP_MSRNS_LENGTH);
        ArrayList<Byte> encSRNBytes = new ArrayList<Byte>();
        if (lengthBuf == null) {
            String mSchedBuf = this.store.getValue(PROP_MSRNS);
            if (mSchedBuf == null) {
                this.log.warn((Object)"no srns to retrieve from storage");
                return;
            }
            byte[] bytes = Base64.decode((String)mSchedBuf);
            encSRNBytes.addAll(Arrays.asList(ArrayUtils.toObject((byte[])bytes)));
        } else {
            int length = Integer.parseInt(lengthBuf);
            for (int i = 0; i < length; ++i) {
                byte[] bytes = Base64.decode((String)this.store.getValue("measurement_srn_" + i));
                encSRNBytes.addAll(Arrays.asList(ArrayUtils.toObject((byte[])bytes)));
            }
        }
        byte[] srnBytes = ArrayUtils.toPrimitive((Byte[])encSRNBytes.toArray(new Byte[0]));
        HashSet<AppdefEntityID> seenEnts = new HashSet<AppdefEntityID>();
        String srnBuf = new String(srnBytes);
        ByteArrayInputStream bIs = new ByteArrayInputStream(srnBytes);
        DataInputStream dIs = new DataInputStream(bIs);
        try {
            int numSRNs = dIs.readInt();
            for (int i = 0; i < numSRNs; ++i) {
                int entType = dIs.readInt();
                int entID = dIs.readInt();
                int revNo = dIs.readInt();
                AppdefEntityID ent = new AppdefEntityID(entType, entID);
                if (seenEnts.contains(ent)) {
                    this.log.warn((Object)("Entity '" + ent + "' contained more than once in SRN storage.  Ignoring"));
                    continue;
                }
                seenEnts.add(ent);
                this.srnList.add(new SRN(ent, revNo));
            }
        }
        catch (IOException exc) {
            this.log.error((Object)("Unable to decode SRN list: " + exc + " srn=\"" + srnBuf + "\""), (Throwable)exc);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeSRNs() throws AgentStorageException {
        ByteArrayOutputStream bOs = new ByteArrayOutputStream();
        DataOutputStream dOs = new DataOutputStream(bOs);
        ArrayList<SRN> arrayList = this.srnList;
        synchronized (arrayList) {
            try {
                dOs.writeInt(this.srnList.size());
                for (SRN srn : this.srnList) {
                    AppdefEntityID ent = srn.getEntity();
                    dOs.writeInt(ent.getType());
                    dOs.writeInt(ent.getID());
                    dOs.writeInt(srn.getRevisionNumber());
                }
                List<Byte> bytes = Arrays.asList(ArrayUtils.toObject((byte[])bOs.toByteArray()));
                int size = bytes.size();
                if (size > 10000) {
                    this.store.setValue(PROP_MSRNS_LENGTH, new Integer(size / 10000 + 1).toString());
                    int ii = 0;
                    for (int i = 0; i < size; i += 10000) {
                        int start = i;
                        int max = Math.min(i + 10000, size);
                        List<Byte> subList = bytes.subList(start, max);
                        Byte[] b = subList.toArray(new Byte[0]);
                        this.store.setValue("measurement_srn_" + ii++, Base64.encode((byte[])ArrayUtils.toPrimitive((Byte[])b)));
                    }
                } else {
                    this.store.setValue(PROP_MSRNS_LENGTH, "1");
                    Byte[] b = bytes.toArray(new Byte[0]);
                    this.store.setValue("measurement_srn_0", Base64.encode((byte[])ArrayUtils.toPrimitive((Byte[])b)));
                }
            }
            catch (IOException exc) {
                this.log.error((Object)"Error encoding SRN list", (Throwable)exc);
                return;
            }
        }
    }

    private Iterator<ScheduledMeasurement> createMeasurementList(Collection<String> records) {
        HashSet<ScheduledMeasurement> metrics = new HashSet<ScheduledMeasurement>();
        long i = -1L;
        for (String value : records) {
            ++i;
            ScheduledMeasurement metric = ScheduledMeasurement.decode((String)value);
            if (metric == null) {
                this.log.error((Object)"Unable to decode metric from storage, deleting.");
                try {
                    this.store.removeFromList(PROP_MSCHED, i);
                }
                catch (AgentStorageException e) {
                    this.log.debug((Object)e, (Throwable)e);
                }
                continue;
            }
            metrics.add(metric);
        }
        this.log.info((Object)("Number of metrics decoded from the storage - " + metrics.size()));
        return metrics.iterator();
    }

    public synchronized Iterator<ScheduledMeasurement> getMeasurementList() throws IOException {
        ArrayList<String> records = new ArrayList<String>();
        try {
            this.readRecordsFromStorage(records);
        }
        catch (Exception e) {
            this.log.warn((Object)("Error reading measurement list from storage = '" + e + "' ," + " trying to convert the list records size"));
            this.store.convertListToCurrentRecordSize(PROP_MSCHED);
            this.readRecordsFromStorage(records);
        }
        return this.createMeasurementList(records);
    }

    private void readRecordsFromStorage(Collection<String> records) {
        records.clear();
        Iterator i = this.store.getListIterator(PROP_MSCHED);
        while (i != null && i.hasNext()) {
            String value = (String)i.next();
            records.add(value);
        }
    }

    synchronized void storeMeasurements(Collection<ScheduledMeasurement> measurements) throws AgentStorageException {
        for (ScheduledMeasurement m : measurements) {
            String encoded = m.encode();
            this.store.addToList(PROP_MSCHED, encoded.toString());
        }
        this.store.flush();
    }

    synchronized void storeMeasurement(ScheduledMeasurement newMeas) throws AgentStorageException {
        String encoded = newMeas.encode();
        this.store.addToList(PROP_MSCHED, encoded.toString());
        this.store.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void updateSRN(SRN updSRN) throws AgentStorageException {
        AppdefEntityID ent = updSRN.getEntity();
        boolean toWrite = false;
        boolean found = false;
        ArrayList<SRN> arrayList = this.srnList;
        synchronized (arrayList) {
            boolean debug = this.log.isDebugEnabled();
            for (SRN srn : this.srnList) {
                found = srn.getEntity().equals((Object)ent);
                if (!found) continue;
                toWrite = srn.getRevisionNumber() != updSRN.getRevisionNumber();
                if (!toWrite) break;
                if (debug) {
                    this.log.debug((Object)("Updating SRN for " + ent + " from " + srn.getRevisionNumber() + " to " + updSRN.getRevisionNumber()));
                }
                srn.setRevisionNumber(updSRN.getRevisionNumber());
                break;
            }
            if (!found) {
                this.log.debug((Object)("Adding new SRN for entity " + ent + ": Initial value = " + updSRN.getRevisionNumber()));
                this.srnList.add(updSRN);
                toWrite = true;
            }
            if (toWrite) {
                this.writeSRNs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeSRN(AppdefEntityID ent) throws AgentStorageException {
        boolean debug = this.log.isDebugEnabled();
        boolean toWrite = false;
        boolean found = false;
        ArrayList<SRN> arrayList = this.srnList;
        synchronized (arrayList) {
            Iterator<SRN> i = this.srnList.iterator();
            while (i.hasNext()) {
                SRN srn = i.next();
                if (!srn.getEntity().equals((Object)ent)) continue;
                found = true;
                i.remove();
                toWrite = true;
                break;
            }
            if (found) {
                if (debug) {
                    this.log.debug((Object)("SRN for entity " + ent + " removed"));
                }
            } else if (debug) {
                this.log.debug((Object)("SRN for entity " + ent + " not found"));
            }
            if (toWrite) {
                this.writeSRNs();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized void deleteMeasurements(Set<AppdefEntityID> aeids) throws AgentStorageException {
        if (aeids == null || aeids.isEmpty()) {
            return;
        }
        Iterator i = this.store.getListIterator(PROP_MSCHED);
        while (i != null && i.hasNext()) {
            String value = (String)i.next();
            ScheduledMeasurement meas = ScheduledMeasurement.decode((String)value);
            if (null == meas) {
                this.log.error((Object)"Unable to decode metric from storage, removing metric for entity");
                i.remove();
                continue;
            }
            AppdefEntityID entity = meas.getEntity();
            if (!aeids.contains(entity)) continue;
            this.log.debug((Object)("Removing scheduled measurement " + meas));
            i.remove();
        }
        ArrayList<SRN> arrayList = this.srnList;
        synchronized (arrayList) {
            Iterator<SRN> it = this.srnList.iterator();
            while (it.hasNext()) {
                SRN srn = it.next();
                AppdefEntityID entity = srn.getEntity();
                if (!aeids.contains(entity)) continue;
                it.remove();
            }
            this.writeSRNs();
        }
        this.store.flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SRN[] getSRNsAsArray() {
        ArrayList<SRN> arrayList = this.srnList;
        synchronized (arrayList) {
            return this.srnList.toArray(new SRN[0]);
        }
    }
}

