/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigInteger;
import java.security.GeneralSecurityException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.SecureRandom;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.security.spec.InvalidKeySpecException;
import java.util.Date;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.NullArgumentException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.cert.CertIOException;
import org.bouncycastle.cert.X509CertificateHolder;
import org.bouncycastle.cert.X509ExtensionUtils;
import org.bouncycastle.cert.X509v3CertificateBuilder;
import org.bouncycastle.cert.jcajce.JcaX509CertificateConverter;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.bouncycastle.openssl.PEMParser;
import org.bouncycastle.openssl.PEMWriter;
import org.bouncycastle.operator.ContentSigner;
import org.bouncycastle.operator.DigestCalculator;
import org.bouncycastle.operator.OperatorCreationException;
import org.bouncycastle.operator.bc.BcDigestCalculatorProvider;
import org.bouncycastle.operator.jcajce.JcaContentSignerBuilder;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.jcajce.JcaPKCS10CertificationRequestBuilder;
import org.hyperic.util.security.KeystoreConfig;
import org.hyperic.util.security.KeystoreManager;

public class CertificateService {
    public static final String THUMBPRINT_ALGORITHM = "SHA1";
    public static final String SIGNATURE_ALGORITHM = "SHA512WITHRSA";
    public static final String KEY_ALGORITHM = "RSA";
    public static final String PROVIDER = "BC";
    public static final int KEY_SIZE = 2048;
    public static final long CERT_VALIDITY_IN_MILLIS = 311040000000L;
    private static final String CLIENT_CERTIFICATE_SUFFIX = ", OU=Agent, O=VMware\\, Inc.";
    private static final Log log = LogFactory.getLog(CertificateService.class);
    private static final String KEYSTORE_TYPE_JKS = "JKS";
    private static final SecureRandom random = new SecureRandom();

    public static KeyStore createInternalKeystore(KeystoreConfig keystoreConfig, String dName) throws GeneralSecurityException, IOException, OperatorCreationException {
        File file = new File(keystoreConfig.getFilePath());
        KeyPair agentKeyPair = CertificateService.generateKeyPair();
        KeyStore keystore = null;
        if (!file.exists()) {
            log.debug((Object)("Creating a new keystore at " + keystoreConfig.getFilePath()));
            keystore = CertificateService.loadKeystore(keystoreConfig, null, KEYSTORE_TYPE_JKS);
            CertificateService.storeKeystore(keystore, keystoreConfig);
        }
        log.debug((Object)"Saving generated keypair to the keystore");
        keystore = CertificateService.savePrivateKey(keystoreConfig.getAlias(), dName, agentKeyPair, keystore, keystoreConfig);
        return keystore;
    }

    public static X509Certificate createSelfSignedCertificate(String dn, String issuer, KeyPair keyPair) throws OperatorCreationException, CertIOException, CertificateException {
        PublicKey subjectPublicKey = keyPair.getPublic();
        PrivateKey issuerPrivateKey = keyPair.getPrivate();
        BigInteger serialNumber = BigInteger.valueOf(Math.abs(random.nextInt()));
        X500Name subjectDN = new X500Name(dn);
        X500Name issuerDN = new X500Name(issuer);
        Date notBefore = new Date(System.currentTimeMillis());
        Date notAfter = new Date(System.currentTimeMillis() + 311040000000L);
        SubjectPublicKeyInfo subjPubKeyInfo = new SubjectPublicKeyInfo(ASN1Sequence.getInstance((Object)subjectPublicKey.getEncoded()));
        X509v3CertificateBuilder certGen = new X509v3CertificateBuilder(issuerDN, serialNumber, notBefore, notAfter, subjectDN, subjPubKeyInfo);
        DigestCalculator digCalc = new BcDigestCalculatorProvider().get(new AlgorithmIdentifier(OIWObjectIdentifiers.idSHA1));
        X509ExtensionUtils x509ExtensionUtils = new X509ExtensionUtils(digCalc);
        certGen.addExtension(Extension.subjectKeyIdentifier, false, (ASN1Encodable)x509ExtensionUtils.createSubjectKeyIdentifier(subjPubKeyInfo));
        ContentSigner sigGen = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM).setProvider(PROVIDER).build(issuerPrivateKey);
        X509CertificateHolder certHolder = certGen.build(sigGen);
        X509Certificate certificate = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certHolder);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("generated certificate for %s issued by %s", dn, issuer));
        }
        return certificate;
    }

    public static X509Certificate convertPemEncodedCertificateToX509Certificate(String certificatePemEncoded) throws GeneralSecurityException, IOException, OperatorCreationException {
        Object decodedCertificate = CertificateService.pemDecode(certificatePemEncoded);
        if (decodedCertificate instanceof X509CertificateHolder) {
            X509CertificateHolder certificateHolder = (X509CertificateHolder)decodedCertificate;
            X509Certificate certificate = new JcaX509CertificateConverter().setProvider(PROVIDER).getCertificate(certificateHolder);
            return certificate;
        }
        String errorMessage = "Failed to convert certificate. Invalid certificate.";
        log.debug((Object)"Failed to convert certificate. Invalid certificate.");
        throw new GeneralSecurityException("Failed to convert certificate. Invalid certificate.");
    }

    public static void saveCertificateToKeystore(String alias, X509Certificate certificate, KeyPair agentKeyPair, KeystoreConfig keystoreConfig) throws GeneralSecurityException, IOException, OperatorCreationException {
        KeyStore keystore = KeystoreManager.getKeystoreManager().getKeyStore(keystoreConfig);
        if (keystore.containsAlias(alias)) {
            keystore.deleteEntry(alias);
        }
        CertificateService.saveCertificateWithPrivateKey(alias, agentKeyPair.getPrivate(), certificate, keystore, keystoreConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final String pemEncode(Object obj) throws IOException {
        StringWriter sw = new StringWriter();
        PEMWriter pw = new PEMWriter((Writer)sw);
        try {
            pw.writeObject(obj);
            pw.flush();
        }
        finally {
            pw.close();
        }
        return sw.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final Object pemDecode(String str) throws IOException {
        StringReader sr = new StringReader(str);
        PEMParser parser = new PEMParser((Reader)sr);
        Object readObject = null;
        try {
            readObject = parser.readObject();
        }
        finally {
            parser.close();
        }
        return readObject;
    }

    public static KeyPair generateKeyPair() throws NoSuchAlgorithmException, InvalidAlgorithmParameterException, InvalidKeySpecException, NoSuchProviderException {
        KeyPairGenerator keyGenerator = KeyPairGenerator.getInstance(KEY_ALGORITHM, PROVIDER);
        keyGenerator.initialize(2048, random);
        KeyPair keyPair = keyGenerator.generateKeyPair();
        return keyPair;
    }

    private static KeyStore savePrivateKey(String alias, String dName, KeyPair keyPair, KeyStore store, KeystoreConfig keystoreConfig) throws GeneralSecurityException, IOException, OperatorCreationException {
        PrivateKey privateKey = keyPair.getPrivate();
        X509Certificate trustCert = CertificateService.createSelfSignedCertificate(dName, dName, keyPair);
        Certificate[] outChain = new Certificate[]{trustCert};
        KeyStore.PrivateKeyEntry pkEntry = new KeyStore.PrivateKeyEntry(privateKey, outChain);
        store = CertificateService.saveEntryToDestStore(alias, pkEntry, keystoreConfig, store);
        CertificateService.storeKeystore(store, keystoreConfig);
        return store;
    }

    private static KeyStore saveCertificateWithPrivateKey(String alias, PrivateKey privateKey, Certificate trustCert, KeyStore store, KeystoreConfig keystoreConfig) throws GeneralSecurityException, IOException, OperatorCreationException {
        Certificate[] outChain = new Certificate[]{trustCert};
        KeyStore.PrivateKeyEntry pkEntry = new KeyStore.PrivateKeyEntry(privateKey, outChain);
        store = CertificateService.saveEntryToDestStore(alias, pkEntry, keystoreConfig, store);
        CertificateService.storeKeystore(store, keystoreConfig);
        return store;
    }

    public static byte[] generateCSR(String cn, KeyPair pair) throws OperatorCreationException, IOException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("generating CSR for CN: " + cn));
        }
        JcaPKCS10CertificationRequestBuilder p10Builder = new JcaPKCS10CertificationRequestBuilder(new X500Principal(CertificateService.getAgentClientCertificateDN(cn)), pair.getPublic());
        JcaContentSignerBuilder csBuilder = new JcaContentSignerBuilder(SIGNATURE_ALGORITHM);
        ContentSigner signer = csBuilder.build(pair.getPrivate());
        PKCS10CertificationRequest csr = p10Builder.build(signer);
        if (log.isDebugEnabled()) {
            log.debug((Object)("Generated CSR for CN: " + cn));
        }
        return csr.getEncoded();
    }

    private static String getAgentClientCertificateDN(String cn) {
        return "CN=" + cn + CLIENT_CERTIFICATE_SUFFIX;
    }

    private static KeyStore saveEntryToDestStore(String alias, KeyStore.Entry entry, KeystoreConfig keystoreConfig, KeyStore store) throws GeneralSecurityException, NoSuchAlgorithmException, IOException {
        log.debug((Object)"Saving entry to keystore");
        if (null == store) {
            FileInputStream storeInputStream = null;
            storeInputStream = new FileInputStream(keystoreConfig.getFilePath());
            store = CertificateService.loadKeystore(keystoreConfig, storeInputStream, KEYSTORE_TYPE_JKS);
        }
        if (store.containsAlias(alias)) {
            store.deleteEntry(alias);
        }
        KeyStore.PasswordProtection protectionParam = new KeyStore.PasswordProtection(keystoreConfig.getFilePassword());
        store.setEntry(alias, entry, protectionParam);
        log.debug((Object)("Adding private key entry with alias: " + alias));
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static KeyStore loadKeystore(KeystoreConfig keystoreConfig, FileInputStream storeInputStream, String keystoreType) throws KeyStoreException, IOException {
        char[] filePassword = keystoreConfig.getFilePassword();
        CertificateService.checkFilePasswordExists(filePassword);
        KeyStore store = KeyStore.getInstance(keystoreType);
        try {
            store.load(storeInputStream, filePassword);
            log.debug((Object)"Loaded keystore");
        }
        catch (Exception e) {
            log.error((Object)"Failed to load keystore, ", (Throwable)e);
        }
        finally {
            if (storeInputStream != null) {
                storeInputStream.close();
            }
        }
        return store;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeKeystore(KeyStore store, KeystoreConfig keystoreConfig) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        char[] filePassword = keystoreConfig.getFilePassword();
        CertificateService.checkFilePasswordExists(filePassword);
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(keystoreConfig.getFilePath());
            store.store(fos, filePassword);
            log.debug((Object)"Stored keystore");
        }
        catch (CertificateException e) {
            log.error((Object)"Failed to store Certificate ", (Throwable)e);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    private static void checkFilePasswordExists(char[] filePassword) {
        if (ArrayUtils.isEmpty((char[])filePassword)) {
            log.error((Object)"No keystore password provided.");
            throw new NullArgumentException("keystoreConfig.filePasswordCharArray");
        }
    }

    public static String extractAgentTokenFromCertificate(X509Certificate certificate) {
        LdapName certificateNames;
        String token = "";
        X500Principal principal = certificate.getSubjectX500Principal();
        if (principal == null) {
            return null;
        }
        String subject = principal.getName();
        try {
            certificateNames = new LdapName(subject);
        }
        catch (InvalidNameException e) {
            log.error((Object)"Invalid certificate");
            return null;
        }
        for (Rdn rdn : certificateNames.getRdns()) {
            if (!"CN".equalsIgnoreCase(rdn.getType())) continue;
            token = rdn.getValue().toString();
            break;
        }
        return token;
    }

    public static String printCert(X509Certificate x509Certificate) {
        return "\nCertificate Thumbprint(SHA1): " + CertificateService.getDecoratedSHA1Thumbprint(x509Certificate) + "\nIssued To: " + x509Certificate.getSubjectDN() + "\nIssued By: " + x509Certificate.getIssuerDN() + "\nExpires: " + x509Certificate.getNotAfter();
    }

    public static String getDecoratedSHA1Thumbprint(X509Certificate x509Certificate) {
        StringBuilder builder;
        try {
            byte[] encodedCertificate = x509Certificate.getEncoded();
            MessageDigest digest = MessageDigest.getInstance(THUMBPRINT_ALGORITHM);
            digest.update(encodedCertificate);
            builder = new StringBuilder(59);
            String prefix = "";
            for (byte b : digest.digest()) {
                builder.append(prefix);
                builder.append(String.format("%02X", b));
                prefix = ":";
            }
        }
        catch (Exception ex) {
            return "Unable to compute thumbprint.";
        }
        return builder.toString();
    }

    public static boolean compareCertificateToThumbprint(X509Certificate certificate, String serverCertificateThumbprint) {
        if (serverCertificateThumbprint == null) {
            return false;
        }
        String strippedThumbprint = CertificateService.getStrippedThumbprint(serverCertificateThumbprint);
        return strippedThumbprint.equals(CertificateService.getCertificateThumbprintByLength(certificate, strippedThumbprint.length()));
    }

    private static String getStrippedThumbprint(String serverCertificateThumbprint) {
        return serverCertificateThumbprint.toLowerCase().replaceAll(":", "").replaceAll(" ", "");
    }

    private static String getCertificateThumbprintByLength(X509Certificate certificate, int thumbprintHexBytesNum) {
        try {
            switch (thumbprintHexBytesNum) {
                case 40: {
                    return DigestUtils.shaHex((byte[])certificate.getEncoded());
                }
                case 64: {
                    return DigestUtils.sha256Hex((byte[])certificate.getEncoded());
                }
            }
            return null;
        }
        catch (CertificateEncodingException e) {
            return null;
        }
    }

    public static X500Principal getClientCertificateSubjectPrincipal(KeystoreConfig keyConfig) {
        try {
            KeyStore keystore = KeystoreManager.getKeystoreManager().getKeyStore(keyConfig);
            String alias = keyConfig.getClientCertificateAlias();
            X509Certificate cert = (X509Certificate)keystore.getCertificate(alias);
            return cert.getSubjectX500Principal();
        }
        catch (Exception e) {
            return null;
        }
    }

    static {
        Security.addProvider((Provider)new BouncyCastleProvider());
    }
}

