/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.util.security;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;

public class KeyStoreUtils {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final KeyStore loadKeyStore(String ksFilePath, char[] ksPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(new File(ksFilePath));
            KeyStore keyStore = KeyStoreUtils.loadKeyStore(fis, ksPassword);
            return keyStore;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    public static final KeyStore loadKeyStore(byte[] keystoreFileContent, char[] ksPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        ByteArrayInputStream bis = new ByteArrayInputStream(keystoreFileContent);
        return KeyStoreUtils.loadKeyStore(bis, ksPassword);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final byte[] loadKeystore(String ksFilePath) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileInputStream fis = null;
        try {
            File keystoreFile = new File(ksFilePath);
            fis = new FileInputStream(keystoreFile);
            byte[] arrContent = new byte[(int)keystoreFile.length()];
            fis.read(arrContent);
            byte[] byArray = arrContent;
            return byArray;
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void persistKeyStore(KeyStore ks, String ksFilePath, char[] ksPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        FileOutputStream fos = null;
        try {
            File file = new File(ksFilePath);
            fos = new FileOutputStream(file);
            ks.store(fos, ksPassword);
        }
        finally {
            if (fos != null) {
                fos.close();
            }
        }
    }

    public static final byte[] keyStoreToByteArray(KeyStore ks, char[] ksPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        ByteArrayOutputStream bos = null;
        bos = new ByteArrayOutputStream();
        ks.store(bos, ksPassword);
        return bos.toByteArray();
    }

    private static final KeyStore loadKeyStore(InputStream is, char[] ksPassword) throws KeyStoreException, NoSuchAlgorithmException, CertificateException, IOException {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(is, ksPassword);
        return ks;
    }
}

