#!/bin/sh
#
### BEGIN INIT INFO
# Provides:          <INIT_PROVIDES>
# Required-Start:    $local_fs $network $syslog
# Should-Start:      $named $remote_fs $time <INIT_START>
# Should-Stop:       $named $remote_fs $time <INIT_STOP>
# Required-Stop:     $local_fs $network $syslog
# Default-Start:     3 5
# Default-Stop:      0 1 2 6
# Short-Description: <INIT_SHORT_DESCRIPTION>
# Description:       <INIT_DESCRIPTION>
### END INIT INFO
#
# chkconfig:         <INIT_CHKCONFIG>

# close all non-std* fds
eval exec {3..254}\>\&-


# The account to run the tomcat instance
TOMCAT_USER="<INSTANCE_USER>"
INSTANCE_LOCATION="<INSTANCE_LOCATION>/bin"
PID_LOCATION="<INSTANCE_LOCATION>/logs/tomcat.pid"

# NO EDITS BELOW
RETVAL=$?

setup () {
	#Absolute path
	INSTANCE_LOCATION=$(cd "$INSTANCE_LOCATION" ; pwd -P)
}

stop() {
	if [ -x "$INSTANCE_LOCATION/tomcat-instance-control.sh" ]; then
		echo "Stopping tomcat instance"
		/bin/su -s /bin/sh $TOMCAT_USER $INSTANCE_LOCATION/tomcat-instance-control.sh stop
		RETVAL=$?
	else
		echo "Startup script $INSTANCE_LOCATION/tomcat-instance-control.sh doesn't exist or is not executable."
		RETVAL=255
	fi
}

status() {
	if [ -x "$INSTANCE_LOCATION/tomcat-instance-control.sh" ]; then
		echo "Status-ing tomcat instance"
		/bin/su -s /bin/sh $TOMCAT_USER $INSTANCE_LOCATION/tomcat-instance-control.sh status
		RETVAL=$?
	else
		echo "Startup script $INSTANCE_LOCATION/tomcat-instance-control.sh doesn't exist or is not executable."
		RETVAL=255
	fi
}

start() {
	id -u $TOMCAT_USER  > /dev/null 2>&1
	if [ "$?" == "1" ]; then
		echo "User $TOMCAT_USER doesn't exist. Cannot start instance at: '${INSTANCE_LOCATION}'!"
		RETVAL=255
	else
		if [ -x "$INSTANCE_LOCATION/tomcat-instance-control.sh" ]; then
			action="start"
			if [ ! -z $1 ]; then
				action=$1
			fi
			echo "${action}ing tomcat instance"
			/bin/su -s /bin/sh $TOMCAT_USER $INSTANCE_LOCATION/tomcat-instance-control.sh "${action}"
			RETVAL=$?
			if [ -f "$PID_LOCATION" ]; then
				logger "`basename "$0"` instance started successfully with PID `cat "$PID_LOCATION"`"
			fi
		else
			echo "Startup script $INSTANCE_LOCATION/tomcat-instance-control.sh doesn't exist or is not executable."
			RETVAL=255
		fi
	fi
}

setup

case "$1" in
	start)
		start
		;;
	run)
		start run
		;;
	stop)
		stop
		;;
	restart)
		stop
		start
		;;
	status)
		status
		;;
	*)
		echo $"Usage: $0 {start|stop|restart|status}"
		exit 1
		;;
esac

exit $RETVAL
