#!/bin/sh

# handle softlinks
SOURCE="$0"
while [ -h "$SOURCE" ]; do
  INSTANCE_LOCATION="$( cd -P "$( dirname "$SOURCE" )" && pwd )"
  SOURCE="$(readlink "$SOURCE")"
  [[ $SOURCE != /* ]] && SOURCE="$INSTANCE_LOCATION/$SOURCE"
done
INSTANCE_LOCATION="$( cd -P "$( dirname ${SOURCE})"/../. && pwd -P)"

#Instance name
INSTANCE_NAME=`basename "$INSTANCE_LOCATION"`

#Absolute path
INSTANCE_LOCATION=$(cd "$INSTANCE_LOCATION/../." ; pwd -P)

#Set instance base if it's not already set
if [ -z "$INSTANCE_BASE" ]; then
  INSTANCE_BASE="$INSTANCE_LOCATION"
  export INSTANCE_BASE
fi

TOMCAT_LOCATION="/usr/share/tomcat"
TARGET_EXECUTABLE="$TOMCAT_LOCATION"/instance/bin/tomcat-instance-control.sh

# Check that target executable exists
if [ -d "$TOMCAT_LOCATION" ]; then
  if [ ! -x "$TARGET_EXECUTABLE" ]; then
    echo "ERROR Cannot find $TARGET_EXECUTABLE or it's not executable. This file is required to continue."
    exit 1
  fi
fi

exec "$TARGET_EXECUTABLE" "$INSTANCE_NAME" "$1" "$2"
