#!/bin/sh

##############################################################
# Script to find out if there are any stale connector ids
# present in the config-state.json.
# Source of truth is the DB
##############################################################

# color map
ERROR='\033[0;31m'
INFO='\033[0;32m'
WARN='\033[0;33m'
NC='\033[0m' # No Color

hostname=`hostname -f`
backupLocation='/tmp/connectors-backup'

ARG=$1
FLAG=0

usage()
{
  echo ${0} [-c]
  echo Script to find out if there are any stale connector ids
  echo present in the config-state.json.
  echo
  echo If -c is not provided it will clean up
  echo -c : Will only inform, and not do any update
  echo
  exit 1
}

if [[ ( "x${ARG}" != "x" && "${ARG}" != "-c" ) ]]
then
    usage
fi

echo "-----------------------------------------------------------------------"
echo "Horizon Connectors found in PostreSQL database on current node: [ ${hostname} ]"
echo "-----------------------------------------------------------------------"

dbConnectors=( $(echo "select CONCAT('/usr/local/horizon/conf/states/',\"tenantId\",'/',\"id\") from \"saas\".\"Connector\" where host like '%${hostname}%';" | su - postgres /opt/vmware/vpostgres/current/bin/psql vcac | grep '/usr/local/horizon/conf/states' ) )

for dbConnector in "${dbConnectors[@]}"
do
   echo -n "${dbConnector}"
   if [ -d "${dbConnector}" ]; then
	echo -e " ${INFO}[ found in database ]${NC}"
   else
	echo -e " ${WARN} [ missing in database ]${NC}"
  fi
done

echo "----------------------------------------------------------------------"
echo "Horizon Connectors found in horizon states folder on current $hostname"
echo "----------------------------------------------------------------------"

statesConnectors=( $(find /usr/local/horizon/conf/states/*/* -type d ) )

for stateConnector in "${statesConnectors[@]}"
do
   echo -n "${stateConnector}"
   if [[ " ${dbConnectors[@]} " =~ " ${stateConnector} " ]]; then
	echo -e " ${INFO} [ valid connector ]${NC}"
   else
        echo -en " ${ERROR} [ invalid connector "
        tenantId=$( echo $stateConnector | cut -d "/" -f7 )
	      dir="${backupLocation}/${tenantId}"
        if [ "${ARG}" == "-c" ]
        then
             echo -e ]${NC}
             FLAG=1
        else
              if [ -d {$dir} ]
              then
                  rm -f {$dir}
              fi
              mkdir -p ${dir}
	      mv ${stateConnector} ${dir}
	      echo -e "Moving to backup folder: ${dir} ]${NC}"
        fi
   fi
done
if [ $FLAG -eq 1 ]
then
   echo -e ${INFO}
   echo "----------------------------------------------------------------------"
   echo Seems like there are stale connectors present as this script was run in check only mode
   echo To remove, please run without ${ARG} argument
   echo "----------------------------------------------------------------------"
fi
