#!/bin/bash
#
# Copyright 2014 VMware, Inc.  All rights reserved.
#
# this script is sourced by any script that needs to be
# customized according to the OS we are running on
# (Currently mainly SUSE, but also CentOS)

DISTRO_SUSE=SUSE
DISTRO_CENTOS=CentOS
DISTRO_SUSE12=SUSE12

#SUSE 11
DISTRO=$DISTRO_SUSE
SYSLOGCONF=/etc/syslog-ng/syslog-ng.conf
SERVICENTP=ntp
CRONDEFCONF=/etc/sysconfig/cron
IPTABLES=/usr/sbin/iptables
IP6TABLES=/usr/sbin/ip6tables

if [ -f /etc/redhat-release ]; then
  DISTRO=$DISTRO_CENTOS
  SYSLOGCONF=/etc/rsyslog.conf
  SERVICENTP=ntpd
  CRONDEFCONF=/etc/sysconfig/crond
  IPTABLES=/sbin/iptables
  IPTABLES=/sbin/ip6tables
elif [ -f /etc/SuSE-release ]; then
  SLES_VER=$(grep VERSION /etc/SuSE-release | awk -F= '{ print $2 }' | tr -d ' ')
  if [ "$SLES_VER" = "12" ] ; then
    DISTRO=$DISTRO_SUSE12
    SYSLOGCONF=/etc/rsyslog.conf
  fi
fi

addUserToGroup()
{
    local USER=$1
    local GROUP=$2
    if [ $DISTRO = $DISTRO_CENTOS -o $DISTRO = $DISTRO_SUSE12 ]; then
        usermod -a -G ${GROUP} ${USER}
    else
        groupmod -A ${USER} ${GROUP}
    fi
}

disableDHCPHostname()
{
    if [ $DISTRO = $DISTRO_CENTOS ]; then
        echo 'DHCLIENT_SET_HOSTNAME="no"' > /etc/dhcp/dhclient-eth0.conf
    else
       sed -r -i.hzn -e 's/^ *(DHCLIENT_SET_HOSTNAME) *=.*$/\1="no"/' /etc/sysconfig/network/dhcp
    fi
}

addService()
{
    case $DISTRO in
        $DISTRO_CENTOS) /sbin/chkconfig --add ${1} ;;
        $DISTRO_SUSE) /sbin/chkconfig -f --add ${1} ;;
        $DISTRO_SUSE12) systemctl enable ${1}.service ;;
    esac
}

removeService()
{
    case $DISTRO in
        $DISTRO_CENTOS) /sbin/chkconfig --del ${1} ;;
        $DISTRO_SUSE) /sbin/chkconfig --del ${1} ;;
        $DISTRO_SUSE12) systemctl disable ${1}.service ;;
    esac
}

enableService()
{
    case $DISTRO in
        $DISTRO_CENTOS) /sbin/chkconfig ${1} on;;
        $DISTRO_SUSE) /sbin/chkconfig -f ${1} on;;
        $DISTRO_SUSE12) addService ${1} ;;
    esac
}

disableService()
{
    case $DISTRO in
        $DISTRO_CENTOS) /sbin/chkconfig ${1} off;;
        $DISTRO_SUSE) /sbin/chkconfig -f ${1} off;;
        $DISTRO_SUSE12) removeService ${1} ;;
    esac
}

controlService()
{
    case $DISTRO in
        $DISTRO_CENTOS) service ${1} ${2} ;;
        $DISTRO_SUSE) service ${1} ${2} ;;
        $DISTRO_SUSE12) systemctl ${2} ${1}.service
    esac
}

setUserPassword()
{
    local USER=$1
    local PWD=$2
    if [ $DISTRO = $DISTRO_SUSE12 ]; then
        echo ${PWD} | passwd ${USER}
    else
        echo ${PWD} | passwd --stdin ${USER}
    fi
}
