#!/bin/bash

BASE_PATH="/usr/local/horizon/DatabaseConfig"

function cleanDbExportPath()
{
   echo "Cleaning DB export path..."
   if [ -d "$BASE_PATH" ]
   then
      rm -rf ${BASE_PATH}
   fi

}

function extractDatabaseDump()
{
  echo "Exporting database dump..."
  mkdir "${BASE_PATH}"

  DB_DUMP_FILE="${BASE_PATH}/vra.sql"

  #Extract the postgres database and dump it into a text file
  /opt/vmware/vpostgres/current/bin/pg_dump -U postgres -Fp vcac -n saas -c > $DB_DUMP_FILE

}

function extractDatabasePassword()
{
  echo "Exporting database password..."
  #Extract database password and decrypt it
  pg_password=$(xpath /etc/vcac/server.xml "//@password" 2>&1 | grep password | cut -d'"' -f2)
  vcac-config prop-util -d --p ${pg_password} > ${BASE_PATH}/db.pwd

}


function replaceVcacAndRemoveCommands()
{
  echo "Replacing vcac to horizon and removing commands..."
  #Replace vcac to horizon at all the places
  `sed -i 's/vcac/horizon/g' $DB_DUMP_FILE`

  #Remove DROP Commands from the dump file
  `sed -i '/DROP/d' $DB_DUMP_FILE`

  #Remove schema related SQL commands from the dump file
  `sed -i '/SET statement_timeout/d' $DB_DUMP_FILE`
  `sed -i '/SET lock_timeout/d' $DB_DUMP_FILE`
  `sed -i '/SET client_encoding/d' $DB_DUMP_FILE`
  `sed -i '/SET standard_conforming_strings/d' $DB_DUMP_FILE`
  `sed -i '/SELECT pg_catalog.set_config/d' $DB_DUMP_FILE`
  `sed -i '/SET check_function_bodies/d' $DB_DUMP_FILE`
  `sed -i '/SET client_min_messages/d' $DB_DUMP_FILE`
  `sed -i '/SET row_security/d' $DB_DUMP_FILE`

  `sed -i '/CREATE SCHEMA saas/d' $DB_DUMP_FILE`
  `sed -i '/ALTER SCHEMA saas OWNER TO horizon/d' $DB_DUMP_FILE`
  `sed -i '/SET default_tablespace/d' $DB_DUMP_FILE`
  `sed -i '/SET default_with_oids/d' $DB_DUMP_FILE`

}


function createSchema(){
  echo "Exporting and creating schema file..."
  #Create schema creation file
  schemaFile="${BASE_PATH}/createSchema-extensions.sql"
  echo "SET statement_timeout = 0;" >> $schemaFile
  echo "SET lock_timeout = 0;" >> $schemaFile
  echo "SET client_encoding = 'UTF8';" >> $schemaFile
  echo "SET standard_conforming_strings = on;" >> $schemaFile
  echo "SELECT pg_catalog.set_config('search_path', '', false);" >> $schemaFile
  echo "SET check_function_bodies = false;" >> $schemaFile
  echo "SET client_min_messages = warning;" >> $schemaFile
  echo "SET row_security = off;" >> $schemaFile

  echo "GRANT ALL PRIVILEGES ON DATABASE saas to horizon;" >> $schemaFile
  echo "CREATE SCHEMA saas;" >> $schemaFile
  echo "ALTER ROLE horizon SET search_path TO saas;" >> $schemaFile
  echo "CREATE EXTENSION citext SCHEMA saas;" >> $schemaFile
  echo "ALTER SCHEMA saas OWNER TO horizon;" >> $schemaFile
  echo "SET default_tablespace = '';" >> $schemaFile
  echo "SET default_with_oids = false;" >> $schemaFile
}


cleanDbExportPath
extractDatabaseDump
extractDatabasePassword
replaceVcacAndRemoveCommands
createSchema